/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.controller.update;

import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.p2lib.checkforactinfos.FoundAll;
import de.p2tools.p2lib.checkforactinfos.FoundSearchDataDTO;
import de.p2tools.p2lib.tools.P2InfoFactory;
import javafx.application.Platform;
import javafx.stage.Stage;

public class SearchProgramUpdate {
    private static final String TITLE_TEXT_PROGRAM_VERSION_IS_UPTODATE = "Programmversion ist aktuell";
    private static final String TITLE_TEXT_PROGRAMMUPDATE_EXISTS = "Ein Programmupdate ist verf\u00fcgbar";
    private final ProgData progData;
    private String title = "";

    public SearchProgramUpdate(ProgData progData) {
        this.progData = progData;
    }

    public void searchNewProgramVersion(boolean showDialogAlways) {
        this.searchNewProgramVersion(this.progData.primaryStage, showDialogAlways, false);
    }

    public void searchNewProgramVersion() {
        this.searchNewProgramVersion(this.progData.primaryStage, true, true);
    }

    public void searchNewProgramVersion(Stage owner, boolean showDialogAlways, boolean showAllDownloads) {
        String SEARCH_URL = "https://www.p2tools.de";
        String SEARCH_URL_DOWNLOAD = "https://www.p2tools.de/download/";
        FoundSearchDataDTO foundSearchDataDTO = new FoundSearchDataDTO(owner, SEARCH_URL, SEARCH_URL_DOWNLOAD, ProgConfig.SYSTEM_SEARCH_UPDATE_LAST_DATE, ProgConfig.SYSTEM_SEARCH_UPDATE, ProgConfig.SYSTEM_UPDATE_SEARCH_BETA, ProgConfig.SYSTEM_UPDATE_SEARCH_DAILY, "https://www.p2tools.de/mtplayer/", "https://www.p2tools.de/mtplayer/download/", "MTPlayer", P2InfoFactory.getProgVersion(), P2InfoFactory.getBuildNo(), P2InfoFactory.getBuildDateR(), new String[]{}, ProgConfig.SYSTEM_DOWNLOAD_DIR_NEW_VERSION, showDialogAlways, ProgData.showUpdateAppParameter || showAllDownloads);
        new Thread(() -> {
            FoundAll.foundAll(foundSearchDataDTO);
            this.setTitleInfo(foundSearchDataDTO.foundNewVersionProperty().getValue());
        }).start();
    }

    private void setTitleInfo(boolean newVersion) {
        this.title = this.progData.primaryStage.getTitle();
        if (newVersion) {
            Platform.runLater(() -> this.setUpdateTitle());
        } else {
            Platform.runLater(() -> this.setNoUpdateTitle());
        }
        try {
            Thread.sleep(10000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Platform.runLater(() -> this.setOrgTitle());
    }

    private void setUpdateTitle() {
        this.progData.primaryStage.setTitle(TITLE_TEXT_PROGRAMMUPDATE_EXISTS);
    }

    private void setNoUpdateTitle() {
        this.progData.primaryStage.setTitle(TITLE_TEXT_PROGRAM_VERSION_IS_UPTODATE);
    }

    private void setOrgTitle() {
        this.progData.primaryStage.setTitle(this.title);
    }
}

