/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.controller.starter;

import de.p2tools.mtplayer.controller.ProgQuit;
import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.data.download.DownloadData;
import de.p2tools.mtplayer.controller.data.download.DownloadFactoryStarts;
import de.p2tools.mtplayer.controller.starter.DownloadDirectHttp;
import de.p2tools.mtplayer.controller.starter.DownloadExternal;
import de.p2tools.mtplayer.gui.dialog.AutomodeContinueDialogController;
import de.p2tools.p2lib.tools.log.P2Log;
import java.util.Timer;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;

public class StarterThread2 {
    private DownloadData download;
    private final Timer bandwidthCalculationTimer;
    private ProgData progData;
    private final BooleanProperty paused;
    private final BooleanProperty searchFilms;
    private final BooleanProperty checkQuitAfterDownload = new SimpleBooleanProperty(false);

    public StarterThread2(ProgData progData, BooleanProperty paused, BooleanProperty searchFilms) {
        this.progData = progData;
        this.paused = paused;
        this.searchFilms = searchFilms;
        this.bandwidthCalculationTimer = new Timer("BandwidthCalculationTimer");
    }

    public synchronized void run() {
        try {
            if (this.searchFilms.getValue().booleanValue()) {
                return;
            }
            this.download = this.getNextStart();
            if (this.download != null) {
                this.startDownload(this.download);
            }
            if (ProgData.autoMode && ProgData.downloadSearchDone && !this.checkQuitAfterDownload.getValue().booleanValue()) {
                this.checkQuitAfterDownload.setValue(true);
                this.quitProgramAfterDownload();
            }
        }
        catch (Exception ex) {
            P2Log.errorLog(613822015, ex);
        }
    }

    private void quitProgramAfterDownload() {
        Platform.runLater(() -> {
            if (this.progData.downloadList.countStartedAndRunningDownloads() == 0) {
                AutomodeContinueDialogController dialogController = new AutomodeContinueDialogController();
                if (dialogController.isContinueAutomode()) {
                    ProgQuit.quit(true);
                } else {
                    ProgData.autoMode = false;
                }
            } else {
                ProgQuit.quit(true);
                ProgData.autoMode = false;
            }
        });
    }

    private synchronized DownloadData getNextStart() throws InterruptedException {
        if (this.paused.getValue().booleanValue()) {
            this.paused.setValue(false);
            return null;
        }
        return DownloadFactoryStarts.getNextStart(this.progData.downloadList);
    }

    public void startDownload(DownloadData download) {
        download.getDownloadStartDto().startDownload();
        switch (download.getType()) {
            case "Programm": {
                DownloadExternal downloadThread = new DownloadExternal(this.progData, download);
                downloadThread.start();
                break;
            }
            default: {
                DownloadDirectHttp downloadThread = new DownloadDirectHttp(this.progData, download, this.bandwidthCalculationTimer);
                downloadThread.start();
            }
        }
    }
}

