/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.controller.starter;

import de.p2tools.mtplayer.controller.ProgQuit;
import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.data.download.DownloadData;
import de.p2tools.mtplayer.controller.data.download.DownloadFactoryStarts;
import de.p2tools.mtplayer.controller.starter.DownloadDirectHttp;
import de.p2tools.mtplayer.controller.starter.DownloadExternal;
import de.p2tools.mtplayer.gui.dialog.AutomodeContinueDialogController;
import de.p2tools.p2lib.tools.log.P2Log;
import java.util.Timer;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;

public class StarterThread
extends Thread {
    private DownloadData download;
    private final Timer bandwidthCalculationTimer;
    private ProgData progData;
    private final BooleanProperty paused;
    private final BooleanProperty searchFilms;
    private final BooleanProperty checkQuitAfterDownload = new SimpleBooleanProperty(false);

    public StarterThread(ProgData progData, BooleanProperty paused, BooleanProperty searchFilms) {
        this.progData = progData;
        this.paused = paused;
        this.searchFilms = searchFilms;
        this.setName("DownloadStarter Daemon Thread");
        this.setDaemon(true);
        this.bandwidthCalculationTimer = new Timer("BandwidthCalculationTimer");
    }

    @Override
    public synchronized void run() {
        while (!this.isInterrupted()) {
            try {
                if (this.searchFilms.getValue().booleanValue()) {
                    Thread.sleep(5000L);
                    continue;
                }
                while ((this.download = this.getNextStart()) != null && !this.searchFilms.getValue().booleanValue()) {
                    this.startDownload(this.download);
                    Thread.sleep(5000L);
                }
                if (this.searchFilms.getValue().booleanValue()) continue;
                if (ProgData.autoMode && ProgData.downloadSearchDone && !this.checkQuitAfterDownload.getValue().booleanValue()) {
                    this.checkQuitAfterDownload.setValue(true);
                    this.quitProgramAfterDownload();
                }
                Thread.sleep(3000L);
            }
            catch (Exception ex) {
                P2Log.errorLog(613822015, ex);
            }
        }
    }

    private void quitProgramAfterDownload() {
        Platform.runLater(() -> {
            if (this.progData.downloadList.countStartedAndRunningDownloads() == 0) {
                AutomodeContinueDialogController dialogController = new AutomodeContinueDialogController();
                if (dialogController.isContinueAutomode()) {
                    ProgQuit.quit(true);
                } else {
                    ProgData.autoMode = false;
                }
            } else {
                ProgQuit.quit(true);
                ProgData.autoMode = false;
            }
        });
    }

    private synchronized DownloadData getNextStart() throws InterruptedException {
        if (this.paused.getValue().booleanValue()) {
            StarterThread.sleep(5000L);
            this.paused.setValue(false);
        }
        return DownloadFactoryStarts.getNextStart(this.progData.downloadList);
    }

    public void startDownload(DownloadData download) {
        download.getDownloadStartDto().startDownload();
        switch (download.getType()) {
            case "Programm": {
                DownloadExternal downloadThread = new DownloadExternal(this.progData, download);
                downloadThread.start();
                break;
            }
            default: {
                DownloadDirectHttp downloadThread = new DownloadDirectHttp(this.progData, download, this.bandwidthCalculationTimer);
                downloadThread.start();
            }
        }
    }
}

