/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.controller.starter;

import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.data.download.DownloadData;
import de.p2tools.mtplayer.controller.data.download.DownloadFactoryDelDownloadFiles;
import de.p2tools.mtplayer.controller.data.downloaderror.DownloadErrorData;
import de.p2tools.mtplayer.controller.data.setdata.SetData;
import de.p2tools.mtplayer.controller.film.FilmDataMTP;
import de.p2tools.mtplayer.controller.mediadb.MediaCollectionData;
import de.p2tools.mtplayer.controller.mediadb.MediaDataWorker;
import de.p2tools.mtplayer.controller.starter.LogMsgFactory;
import de.p2tools.mtplayer.controller.starter.StartDownloadDto;
import de.p2tools.mtplayer.gui.dialog.DownloadSubtitleDialog;
import de.p2tools.mtplayer.gui.dialog.NoSetDialogController;
import de.p2tools.mtplayer.gui.dialog.downloaddialog.DownloadErrorDialogController;
import de.p2tools.mtplayer.gui.tools.MTInfoFile;
import de.p2tools.mtplayer.gui.tools.MTSubtitle;
import de.p2tools.p2lib.tools.log.P2Log;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import javafx.application.Platform;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;

public class StartDownloadFactory {
    static int SYSTEM_PARAMETER_DOWNLOAD_MAX_RESTART = 3;

    private StartDownloadFactory() {
    }

    public static void downloadSubtitle(FilmDataMTP filmData, boolean subtitel) {
        SetData setData = ProgData.getInstance().setDataList.getSetDataForDownloads("");
        if (setData == null) {
            new NoSetDialogController(ProgData.getInstance(), NoSetDialogController.TEXT.SAVE);
            return;
        }
        ArrayList<FilmDataMTP> list = new ArrayList<FilmDataMTP>();
        list.add(filmData);
        DownloadData downloadData = new DownloadData(list, setData);
        if (subtitel) {
            downloadData.setSubtitle(true);
        } else {
            downloadData.setInfoFile(true);
        }
        SimpleStringProperty pathProp = new SimpleStringProperty(downloadData.getDestPath());
        SimpleStringProperty nameProp = new SimpleStringProperty(downloadData.getFileNameWithoutSuffix());
        SimpleBooleanProperty okProp = new SimpleBooleanProperty(false);
        DownloadSubtitleDialog downloadSubtitleDialog = new DownloadSubtitleDialog(ProgData.getInstance(), subtitel, pathProp, nameProp, okProp);
        downloadSubtitleDialog.showDialog();
        if (!okProp.get()) {
            return;
        }
        if (!pathProp.getValueSafe().isEmpty()) {
            downloadData.setPathName(pathProp.getValueSafe(), nameProp.getValueSafe());
            StartDownloadFactory.makeDirAndLoadInfoSubtitle(downloadData);
        }
    }

    static void makeDirAndLoadInfoSubtitle(DownloadData download) {
        try {
            Files.createDirectories(Paths.get(download.getDestPath(), new String[0]), new FileAttribute[0]);
            if (download.isInfoFile()) {
                MTInfoFile.writeInfoFile(download);
            }
            if (download.isSubtitle()) {
                new MTSubtitle().writeSubtitle(download);
            }
        }
        catch (IOException iOException) {
        }
        catch (Exception ex) {
            P2Log.errorLog(945120690, ex);
        }
    }

    static void finalizeDownload(DownloadData download) {
        StartDownloadDto startDownloadDto = download.getDownloadStartDto();
        StartDownloadFactory.cleanUpDestFile(download);
        if (download.isStateError()) {
            Platform.runLater(() -> {
                ProgData.getInstance().downloadErrorList.add(new DownloadErrorData(download.getTitle(), download.getUrl(), download.getDestPathFile(), download.getDownloadStartDto().getErrorMsg(), download.getDownloadStartDto().getErrorStream()));
                if (!ProgData.autoMode && ProgConfig.DOWNLOAD_DIALOG_ERROR_SHOW.getValue().booleanValue()) {
                    new DownloadErrorDialogController(download);
                }
            });
        }
        LogMsgFactory.finishedMsg(download);
        if (download.isStateError()) {
            download.setProgress(-1.0);
        } else if (!download.isStateStopped()) {
            startDownloadDto.setTimeLeftSeconds(0);
            download.setProgress(1.0);
            download.getDownloadSize().setActuallySize(0L);
            if (startDownloadDto.getInputStream() != null) {
                download.setBandwidthEnd(startDownloadDto.getInputStream().getSumBandwidth());
            }
            download.setRemaining(-1 * startDownloadDto.getStartTime().diffInSeconds());
        }
        download.setNo(Integer.MAX_VALUE);
        ProgData.getInstance().downloadGuiController.tableRefresh();
        startDownloadDto.setProcess(null);
        startDownloadDto.setInputStream(null);
        startDownloadDto.setStartTime(null);
        StartDownloadFactory.checkMediaList(download);
    }

    static void checkMediaList(DownloadData download) {
        File fileMedia;
        String path = download.getDestPath();
        MediaCollectionData mediaCollectionData = ProgData.getInstance().mediaCollectionDataList.getMediaCollectionDataIntern(path);
        if (mediaCollectionData != null && (fileMedia = new File(mediaCollectionData.getPath())).exists()) {
            P2Log.sysLog(new String[]{"Mediensammlung aktualisieren: ", mediaCollectionData.getPath()});
            Platform.runLater(() -> MediaDataWorker.updateCollection(mediaCollectionData));
        }
    }

    static void cleanUpDestFile(DownloadData download) {
        File destFile = download.getFile();
        if (!destFile.exists()) {
            return;
        }
        if (download.isStateStopped() && download.getDownloadStartDto().isDeleteAfterStop()) {
            P2Log.sysLog(new String[]{"Gestoppter Download, auch die Datei l\u00f6schen: ", destFile.getAbsolutePath()});
            DownloadFactoryDelDownloadFiles.deleteDownloadFiles(download, true);
            return;
        }
        long length = download.getFile().length();
        if (length == 0L) {
            P2Log.sysLog(new String[]{"Restart/Aufr\u00e4umen: leere Datei l\u00f6schen", destFile.getAbsolutePath()});
            DownloadFactoryDelDownloadFiles.deleteDownloadFiles(download, false);
        } else if (length < 256000L) {
            P2Log.sysLog(new String[]{"Restart/Aufr\u00e4umen: Zu kleine Datei l\u00f6schen", destFile.getAbsolutePath()});
            DownloadFactoryDelDownloadFiles.deleteDownloadFiles(download, false);
        }
    }

    static boolean checkDownloadWasOK(ProgData progData, DownloadData download, StringProperty errorMsg) {
        double progress;
        if (download.getFile().exists()) {
            download.getDownloadSize().setActuallySize(download.getFile().length());
        } else {
            download.getDownloadSize().setActuallySize(0L);
        }
        if (download.getType().equals("direkter Download") && (progress = download.getProgress().doubleValue()) > -1.0 && progress < 0.995) {
            String str = "Download fehlgeschlagen, Datei zu klein, nur " + String.format("%.0f", progress) + " % erreicht.\nSoll aus der URL: " + download.getDownloadSize().getTargetSize() + " Byte\nIst aus der Datei: " + download.getDownloadSize().getActuallySize() + " Byte\n";
            errorMsg.setValue(str);
            P2Log.errorLog(696510258, str);
            return false;
        }
        File file = new File(download.getDestPathFile());
        if (!file.exists()) {
            String str = "Download fehlgeschlagen: Datei existiert nicht: " + download.getDestPathFile();
            errorMsg.setValue(str);
            P2Log.errorLog(550236231, str);
            return false;
        }
        if (file.length() < 256000L) {
            String str = "Download fehlgeschlagen: Datei zu klein: " + download.getDestPathFile();
            errorMsg.setValue(str);
            P2Log.errorLog(795632500, str);
            return false;
        }
        if (download.isAbo()) {
            progData.historyListAbos.addHistoryDataToHistory(download.getTheme(), download.getTitle(), download.getHistoryUrl());
        }
        return true;
    }

    public static void canAlreadyStarted(DownloadData downloadData) {
        long alreadyLoadedSeconds;
        if (downloadData.isStateStartedRun() && downloadData.getDurationMinute() > 0 && downloadData.getDownloadStartDto().getTimeLeftSeconds() > 0L && downloadData.getDownloadSize().getActuallySize() > 0L && downloadData.getDownloadSize().getTargetSize() > 0L && (double)(alreadyLoadedSeconds = (long)(downloadData.getDurationMinute() * 60) * downloadData.getDownloadSize().getActuallySize() / downloadData.getDownloadSize().getTargetSize()) > (double)downloadData.getDownloadStartDto().getTimeLeftSeconds() * 1.1) {
            downloadData.getDownloadStartDto().setStartViewing(true);
        }
    }
}

