/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.controller.starter;

import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.controller.config.ProgIcons;
import de.p2tools.mtplayer.controller.config.SizeTools;
import de.p2tools.mtplayer.controller.data.download.DownloadData;
import de.p2tools.p2lib.P2LibConst;
import de.p2tools.p2lib.guitools.P2Open;
import de.p2tools.p2lib.guitools.pnotification.P2Notification;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.HBox;

public class NotificationDownFinished {
    public void addNotification(DownloadData download, boolean error) {
        String text = "Film:   " + download.getTitle() + P2LibConst.LINE_SEPARATOR + "Sender: " + download.getChannel() + P2LibConst.LINE_SEPARATOR + "Gr\u00f6\u00dfe:  " + SizeTools.humanReadableByteCount(download.getDownloadSize().getTargetSize(), true) + P2LibConst.LINE_SEPARATOR + (error ? "Download war fehlerhaft" : "Download war erfolgreich");
        Button btnFilmStart = new Button();
        btnFilmStart.getStyleClass().addAll((String[])new String[]{"btnFunction", "btnFuncTable"});
        btnFilmStart.setTooltip(new Tooltip("Gespeicherten Film abspielen"));
        btnFilmStart.setGraphic(ProgIcons.IMAGE_TABLE_FILM_PLAY.getImageView());
        btnFilmStart.setOnAction(event -> P2Open.playStoredFilm(download.getDestPathFile(), ProgConfig.SYSTEM_PROG_PLAY_FILME, ProgIcons.ICON_BUTTON_FILE_OPEN.getImageView()));
        Button btnOpenDirectory = new Button();
        btnOpenDirectory.getStyleClass().addAll((String[])new String[]{"btnFunction", "btnFuncTable"});
        btnOpenDirectory.setTooltip(new Tooltip("Ordner mit gespeichertem Film \u00f6ffnen"));
        btnOpenDirectory.setGraphic(ProgIcons.IMAGE_TABLE_DOWNLOAD_OPEN_DIR.getImageView());
        btnOpenDirectory.setOnAction(event -> P2Open.openDir(download.getDestPath(), ProgConfig.SYSTEM_PROG_OPEN_DIR, ProgIcons.ICON_BUTTON_FILE_OPEN.getImageView()));
        HBox hBoxBottom = new HBox();
        hBoxBottom.setSpacing(10.0);
        hBoxBottom.setAlignment(Pos.CENTER_RIGHT);
        if (download.isStateError()) {
            hBoxBottom.getChildren().addAll((Node[])new Node[]{btnOpenDirectory});
        } else {
            hBoxBottom.getChildren().addAll((Node[])new Node[]{btnFilmStart, btnOpenDirectory});
        }
        this.add(text, error, hBoxBottom);
    }

    private void add(String text, boolean error, HBox hBoxBottom) {
        if (!ProgConfig.DOWNLOAD_SHOW_NOTIFICATION.getValue().booleanValue()) {
            return;
        }
        P2Notification.addNotification("Download beendet", text, error ? P2Notification.STATE.ERROR : P2Notification.STATE.INFO, hBoxBottom);
    }
}

