/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.controller.mediadb;

public class MediaFileSize
implements Comparable<MediaFileSize> {
    public Long sizeL = 0L;
    private String sizeStr = "";

    public MediaFileSize(long size) {
        this.setSize(size);
    }

    public MediaFileSize(String size) {
        this.setSize(size);
    }

    public void setSize(long size) {
        this.sizeL = size;
        this.setSizeFromLong();
    }

    public void setSize(String size) {
        try {
            this.sizeL = Long.parseLong(size);
        }
        catch (Exception ignore) {
            this.sizeL = 0L;
        }
        this.setSizeFromLong();
    }

    public long getSizeLong() {
        return this.sizeL;
    }

    public String getSizeAsStr() {
        return "" + this.sizeL;
    }

    private void setSizeFromLong() {
        if (this.sizeL > 1000000L) {
            this.sizeStr = String.valueOf(this.sizeL / 1000000L);
        } else if (this.sizeL > 0L) {
            this.sizeStr = "< 1";
        } else if (this.sizeL == 0L) {
            this.sizeStr = "";
        }
    }

    public String toString() {
        return this.sizeStr;
    }

    @Override
    public int compareTo(MediaFileSize ll) {
        return this.sizeL.compareTo(ll.sizeL);
    }
}

