/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.controller.mediadb;

import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.mediadb.MediaFileSize;
import de.p2tools.p2lib.P2LibConst;
import java.util.Arrays;

public class MediaData {
    public static final int MEDIA_DATA_NAME = 0;
    public static final int MEDIA_DATA_PATH = 1;
    public static final int MEDIA_DATA_SIZE = 2;
    public static final int MEDIA_DATA_COLLECTION_ID = 3;
    public static final int MEDIA_DATA_EXTERN = 4;
    public static final int MAX_ELEM = 5;
    public static final String[] COLUMN_NAMES = new String[]{"Name", "Pfad", "Gr\u00f6\u00dfe [MB]", "SammlungsId", "Extern"};
    public static final String[] XML_NAMES = new String[]{"Name", "Pfad", "Groesse", "SammlungsId", "Extern"};
    public static final String TAG = "Mediensammlung";
    private final String name;
    private final String path;
    private final boolean extern;
    private final MediaFileSize mediaFileSize = new MediaFileSize(0L);
    private final int collectionId;

    public MediaData(String[] arr) {
        int id;
        this.name = arr[0];
        this.path = arr[1];
        this.mediaFileSize.setSize(arr[2]);
        try {
            id = Integer.parseInt(arr[3]);
        }
        catch (Exception ex) {
            try {
                id = -1 * (int)Long.parseLong(arr[3]);
            }
            catch (Exception e) {
                id = 0;
            }
        }
        this.collectionId = id;
        this.extern = this.setExternal();
    }

    public MediaData(String name, String path, long size, int id) {
        this.mediaFileSize.setSize(size);
        this.collectionId = id;
        this.name = MediaData.cleanUp(name);
        this.path = MediaData.cleanUp(path);
        this.extern = this.setExternal();
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public MediaFileSize getSize() {
        return this.mediaFileSize;
    }

    public int getCollectionId() {
        return this.collectionId;
    }

    public boolean isExternal() {
        return this.extern;
    }

    private boolean setExternal() {
        if (this.collectionId != 0) {
            return ProgData.getInstance().mediaCollectionDataList.isMediaCollectionDataExternal(this.collectionId);
        }
        return false;
    }

    private static String cleanUp(String s) {
        s = s.replace(P2LibConst.LINE_SEPARATOR, "");
        s = s.replace("|", "");
        return s;
    }

    public boolean equal(MediaData m) {
        return m.name.equals(this.name) && m.path.equals(this.path) && m.collectionId == this.collectionId && m.getSize() == this.getSize();
    }

    public String toString() {
        Object ret = "";
        String[] arr = this.setXmlFromProps();
        for (int i = 0; i < 5; ++i) {
            ret = i == 0 ? (String)ret + "| ***|" + COLUMN_NAMES[i] + ": " + arr[i] + P2LibConst.LINE_SEPARATOR : (String)ret + "|    |" + COLUMN_NAMES[i] + ": " + arr[i] + P2LibConst.LINE_SEPARATOR;
        }
        return ret;
    }

    public String[] setXmlFromProps() {
        String[] arr = MediaData.getArr();
        arr[0] = this.name;
        arr[1] = this.path;
        arr[2] = this.getSize().getSizeAsStr();
        arr[3] = String.valueOf(this.collectionId);
        arr[4] = String.valueOf(this.extern);
        return arr;
    }

    public static String[] getArr() {
        Object[] arr = new String[5];
        Arrays.fill(arr, "");
        return arr;
    }
}

