/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.controller.mediadb;

import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.mediadb.MediaCollectionData;
import de.p2tools.mtplayer.controller.mediadb.MediaData;
import de.p2tools.mtplayer.controller.mediadb.WriteMediaDb;
import de.p2tools.p2lib.configfile.pdata.P2DataList;
import de.p2tools.p2lib.tools.P2Index;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javafx.beans.property.SimpleListProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;

public class MediaCollectionDataList
extends SimpleListProperty<MediaCollectionData>
implements P2DataList<MediaCollectionData> {
    public static final String TAG = "MediaCollectionDataList";
    private SortedList<MediaCollectionData> sortedListInternal = null;
    private SortedList<MediaCollectionData> sortedListExternal = null;
    private final ObservableList<MediaCollectionData> undoMediaCollectionInternal = FXCollections.observableArrayList();
    private final ObservableList<MediaCollectionData> undoMediaCollectionExternal = FXCollections.observableArrayList();
    private final List<MediaData> undoMediaDataExternal = new ArrayList<MediaData>();
    private final List<MediaData> undoMediaDataInternal = new ArrayList<MediaData>();

    public MediaCollectionDataList() {
        super(FXCollections.observableArrayList());
    }

    @Override
    public boolean add(MediaCollectionData mediaCollectionData) {
        if (mediaCollectionData.getIdLong() > 0L) {
            mediaCollectionData.setIdInt((int)mediaCollectionData.getIdLong() * -1);
            mediaCollectionData.setIdLong(0L);
        }
        if (mediaCollectionData.getIdInt() == 0) {
            mediaCollectionData.setIdInt(P2Index.getIndexInt());
        }
        return super.add(mediaCollectionData);
    }

    @Override
    public String getTag() {
        return TAG;
    }

    @Override
    public String getComment() {
        return "Liste aller MediaCollectionData";
    }

    @Override
    public MediaCollectionData getNewItem() {
        return new MediaCollectionData();
    }

    @Override
    public void addNewItem(Object obj) {
        if (obj.getClass().equals(MediaCollectionData.class)) {
            this.add((MediaCollectionData)obj);
        }
    }

    public SortedList<MediaCollectionData> getSortedListInternal() {
        if (this.sortedListInternal == null) {
            FilteredList<MediaCollectionData> filteredListInternal = new FilteredList<MediaCollectionData>(this, p -> !p.isExternal());
            this.sortedListInternal = new SortedList<MediaCollectionData>((ObservableList<MediaCollectionData>)filteredListInternal);
        }
        return this.sortedListInternal;
    }

    public SortedList<MediaCollectionData> getSortedListExternal() {
        if (this.sortedListExternal == null) {
            FilteredList<MediaCollectionData> filteredListExternal = new FilteredList<MediaCollectionData>(this, p -> p.isExternal());
            this.sortedListExternal = new SortedList<MediaCollectionData>((ObservableList<MediaCollectionData>)filteredListExternal);
        }
        return this.sortedListExternal;
    }

    public MediaCollectionDataList getMediaCollectionDataList(boolean external) {
        MediaCollectionDataList list = new MediaCollectionDataList();
        list.addAll(this.stream().filter(l -> l.isExternal() == external).collect(Collectors.toList()));
        return list;
    }

    public String getNextMediaCollectionName(boolean external) {
        int count;
        String name;
        if (external) {
            name = "Extern ";
            count = this.getMediaCollectionDataList(true).size();
        } else {
            name = "Intern ";
            count = this.getMediaCollectionDataList(false).size();
        }
        while (this.getMediaCollectionData(name + count) != null) {
            ++count;
        }
        return name + count;
    }

    public MediaCollectionData addNewMediaCollectionData(boolean external) {
        MediaCollectionData mediaCollectionData = new MediaCollectionData("", "", external);
        this.add(mediaCollectionData);
        return mediaCollectionData;
    }

    public MediaCollectionData getMediaCollectionData(long id) {
        return this.stream().filter(m -> (long)m.getIdInt() == id).findAny().orElse(null);
    }

    public boolean isMediaCollectionDataExternal(long id) {
        return this.stream().filter(m -> (long)m.getIdInt() == id).filter(MediaCollectionData::isExternal).findAny().orElse(null) != null;
    }

    public MediaCollectionData getMediaCollectionDataIntern(String path) {
        Path child = Paths.get(path, new String[0]).toAbsolutePath();
        return this.stream().filter(m -> !m.isExternal()).filter(m -> {
            Path parent = Paths.get(m.getPath(), new String[0]).toAbsolutePath();
            return child.startsWith(parent);
        }).findAny().orElse(null);
    }

    private MediaCollectionData getMediaCollectionData(String collectionName) {
        return this.stream().filter(m -> m.getCollectionName().equals(collectionName)).findAny().orElse(null);
    }

    public void cleanUpInternalMediaCollectionData() {
        HashSet<String> hashSet = new HashSet<String>(this.size());
        Iterator it = this.iterator();
        while (it.hasNext()) {
            MediaCollectionData mediaCollectionData = (MediaCollectionData)it.next();
            if (mediaCollectionData.isExternal() || hashSet.add(mediaCollectionData.getPath())) continue;
            it.remove();
        }
        hashSet.clear();
    }

    public ObservableList<MediaCollectionData> getUndoList(boolean external) {
        return external ? this.undoMediaCollectionExternal : this.undoMediaCollectionInternal;
    }

    public void clearUndoList() {
        this.undoMediaDataExternal.clear();
        this.undoMediaDataInternal.clear();
        this.undoMediaCollectionExternal.clear();
        this.undoMediaCollectionInternal.clear();
    }

    public synchronized void addDataToUndoList(List<MediaCollectionData> list, boolean external) {
        if (external) {
            this.undoMediaCollectionExternal.clear();
            this.undoMediaDataExternal.clear();
            this.undoMediaCollectionExternal.addAll((Collection<MediaCollectionData>)list);
            list.forEach(mediaCollectionData -> this.undoMediaDataExternal.addAll(ProgData.getInstance().mediaDataList.stream().filter(mediaData -> mediaData.getCollectionId() == mediaCollectionData.getIdInt()).toList()));
        } else {
            this.undoMediaCollectionInternal.clear();
            this.undoMediaDataInternal.clear();
            this.undoMediaCollectionInternal.addAll((Collection<MediaCollectionData>)list);
            list.forEach(mediaCollectionData -> this.undoMediaDataInternal.addAll(ProgData.getInstance().mediaDataList.stream().filter(mediaData -> mediaData.getCollectionId() == mediaCollectionData.getIdInt()).toList()));
        }
    }

    public synchronized void undoData(boolean external) {
        if (external ? this.undoMediaCollectionExternal.isEmpty() : this.undoMediaCollectionInternal.isEmpty()) {
            return;
        }
        if (external) {
            this.addAll(this.undoMediaCollectionExternal);
            this.undoMediaCollectionExternal.clear();
            ProgData.getInstance().mediaDataList.addAll(this.undoMediaDataExternal);
            this.undoMediaDataExternal.clear();
            new WriteMediaDb(ProgData.getInstance()).writeExternalMediaData();
        } else {
            this.addAll(this.undoMediaCollectionInternal);
            this.undoMediaCollectionInternal.clear();
            ProgData.getInstance().mediaDataList.addAll(this.undoMediaDataInternal);
            this.undoMediaDataInternal.clear();
        }
        ProgData.getInstance().mediaDataList.countMediaData(ProgData.getInstance());
    }
}

