/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.controller.livesearchzdf;

import de.p2tools.mtplayer.controller.film.FilmDataMTP;
import de.p2tools.mtplayer.controller.livesearch.JsonInfoDto;
import de.p2tools.mtplayer.controller.livesearch.tools.LiveConst;
import de.p2tools.mtplayer.controller.livesearch.tools.LiveFactory;
import de.p2tools.mtplayer.controller.livesearchzdf.DownloadDto;
import de.p2tools.mtplayer.controller.livesearchzdf.DownloadDtoFilmConverter;
import de.p2tools.mtplayer.controller.livesearchzdf.GeoLocations;
import de.p2tools.mtplayer.controller.livesearchzdf.ZdfDatenFilm;
import de.p2tools.mtplayer.controller.livesearchzdf.ZdfFilmDto;
import de.p2tools.mtplayer.controller.livesearchzdf.ZdfVideoUrlOptimizer;
import de.p2tools.p2lib.tools.log.P2Log;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import java.util.Optional;

public class ZdfFilmDetailTask {
    private static final transient ZdfVideoUrlOptimizer optimizer = new ZdfVideoUrlOptimizer();
    private static final DateTimeFormatter DATE_FORMAT = DateTimeFormatter.ofPattern("dd.MM.yyyy");
    private static final DateTimeFormatter TIME_FORMAT = DateTimeFormatter.ofPattern("HH:mm:ss");

    public void processRestTarget(JsonInfoDto jsonInfoDto, ZdfFilmDto zdfFilmDto, DownloadDto downloadDto) {
        try {
            this.appendSignLanguage(downloadDto, zdfFilmDto.getUrlSignLanguage());
            ZdfFilmDto result = zdfFilmDto;
            this.addFilm(jsonInfoDto, downloadDto, result);
        }
        catch (Exception e) {
            P2Log.errorLog(959562654, e, jsonInfoDto.getSearchString());
        }
    }

    private void appendSignLanguage(DownloadDto downloadDto, Optional<String> urlSignLanguage) {
        if (urlSignLanguage.isPresent()) {
            downloadDto.getDownloadUrls("deu").forEach((resolution, url) -> downloadDto.addUrl("deu-dgs", (LiveConst.Qualities)((Object)resolution), (String)url));
        }
    }

    private void addFilm(JsonInfoDto jsonInfoDto, DownloadDto downloadDto, ZdfFilmDto zdfFilmDto) {
        for (String language : downloadDto.getLanguages()) {
            if (!downloadDto.getUrl(language, LiveConst.Qualities.NORMAL).isPresent()) continue;
            DownloadDtoFilmConverter.getOptimizedUrls(downloadDto.getDownloadUrls(language), Optional.of(optimizer));
            FilmDataMTP filmWithLanguage = this.createFilm(downloadDto, zdfFilmDto, language);
            LiveFactory.setFilmSize(filmWithLanguage);
            filmWithLanguage.init();
            jsonInfoDto.getList().add(filmWithLanguage);
        }
    }

    private FilmDataMTP createFilm(DownloadDto downloadDto, ZdfFilmDto zdfFilmDto, String aLanguage) {
        Optional<String> subTitleUrl;
        String title = this.updateTitle(aLanguage, zdfFilmDto.getTitle());
        LocalDateTime time = zdfFilmDto.getTime().orElse(LocalDateTime.now());
        String dateValue = time.format(DATE_FORMAT);
        String timeValue = time.format(TIME_FORMAT);
        Map<LiveConst.Qualities, String> downloadUrls = downloadDto.getDownloadUrls(aLanguage);
        String urlNormal = downloadUrls.get((Object)LiveConst.Qualities.NORMAL);
        Duration duration = zdfFilmDto.getDuration().orElse(downloadDto.getDuration().orElse(Duration.ZERO));
        ZdfDatenFilm film = new ZdfDatenFilm("ZDF", zdfFilmDto.getTopic().orElse(title), zdfFilmDto.getWebsite().orElse(""), title, urlNormal, dateValue, timeValue, duration.getSeconds(), zdfFilmDto.getDescription().orElse(""));
        if (downloadUrls.containsKey((Object)LiveConst.Qualities.SMALL)) {
            LiveFactory.addUrlKlein(film, downloadUrls.get((Object)LiveConst.Qualities.SMALL));
        }
        if (downloadUrls.containsKey((Object)LiveConst.Qualities.HD)) {
            LiveFactory.addUrlHd(film, downloadUrls.get((Object)LiveConst.Qualities.HD));
        }
        if ((subTitleUrl = downloadDto.getSubTitleUrl(aLanguage)).isPresent()) {
            LiveFactory.addUrlSubtitle(film, subTitleUrl.get());
        }
        Optional<GeoLocations> geoLocation = downloadDto.getGeoLocation();
        geoLocation.ifPresent(geoLocations -> {
            film.arr[13] = geoLocations.getDescription();
        });
        return film;
    }

    private String updateTitle(String aLanguage, String aTitle) {
        Object title = aTitle;
        switch (aLanguage) {
            case "deu": {
                return title;
            }
            case "deu-ad": {
                title = (String)title + " (Audiodeskription)";
                break;
            }
            case "deu-dgs": {
                title = (String)title + " (Geb\u00e4rdensprache)";
                break;
            }
            case "eng": {
                title = (String)title + " (Englisch)";
                break;
            }
            case "fra": {
                title = (String)title + " (Franz\u00f6sisch)";
                break;
            }
            default: {
                title = (String)title + "(" + aLanguage + ")";
            }
        }
        return title;
    }
}

