/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.controller.livesearchzdf;

import de.p2tools.mtplayer.controller.film.FilmDataMTP;
import de.p2tools.p2lib.tools.log.P2Log;
import java.text.Normalizer;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;

public class ZdfDatenFilm
extends FilmDataMTP {
    private static final String[] LEGAL_NOTICES = new String[]{"+++ Aus rechtlichen Gr\u00fcnden ist der Film nur innerhalb von Deutschland abrufbar. +++", "+++ Aus rechtlichen Gr\u00fcnden ist diese Sendung nur innerhalb von Deutschland abrufbar. +++", "+++ Aus rechtlichen Gr\u00fcnden ist dieses Video nur innerhalb von Deutschland abrufbar. +++", "+++ Aus rechtlichen Gr\u00fcnden ist dieses Video nur innerhalb von Deutschland verf\u00fcgbar. +++", "+++ Aus rechtlichen Gr\u00fcnden kann das Video nur innerhalb von Deutschland abgerufen werden. +++ Due to legal reasons the video is only available in Germany.+++", "+++ Aus rechtlichen Gr\u00fcnden kann das Video nur innerhalb von Deutschland abgerufen werden. +++", "+++ Due to legal reasons the video is only available in Germany.+++", "+++ Aus rechtlichen Gr\u00fcnden kann das Video nur in Deutschland abgerufen werden. +++", "[Aus rechtlichen G\u00fcnden k\u00f6nnen wir die Partie nicht als Einzelclip anbieten.]", "+++ Aus rechtlichen Gr\u00fcnden ist das Video nur innerhalb von Deutschland abrufbar. +++", "+++Aus rechtlichen Gr\u00fcnden kann die Sendung nur innerhalb von Deutschland abgerufen werden. +++", "+++ Aus rechtlichen Gr\u00fcnden d\u00fcrfen wir dieses Video nur innerhalb von Deutschland anbieten. +++", "+++Aus rechtlichen Gr\u00fcnden kann dieses Video nur innerhalb von Deutschland abgerufen werden.+++"};
    private static final DateTimeFormatter DATUM_FORMATTER = DateTimeFormatter.ofPattern("dd.MM.yyyy");

    public ZdfDatenFilm(String ssender, String tthema, String filmWebsite, String ttitel, String uurl, String datum, String zeit, long dauerSekunden, String description) {
        this.arr[1] = ssender;
        this.arr[2] = tthema.isEmpty() ? ssender : ZdfDatenFilm.normalize(ZdfDatenFilm.cleanWhitespaces(tthema.trim()));
        this.arr[15] = filmWebsite;
        this.arr[3] = ttitel.isEmpty() ? tthema : ttitel.trim();
        this.arr[14] = uurl;
        this.checkDatum(datum, this.arr[1] + " " + this.arr[2] + " " + this.arr[3]);
        this.checkZeit(this.arr[6], zeit, this.arr[1] + " " + this.arr[2] + " " + this.arr[3]);
        this.arr[12] = ZdfDatenFilm.normalize(ZdfDatenFilm.cleanDescription(description));
        this.checkFilmDauer(dauerSekunden);
    }

    private void checkFilmDauer(long dauerSekunden) {
        if (dauerSekunden > 0L && dauerSekunden <= 356400L) {
            String hours = String.valueOf(dauerSekunden / 3600L);
            String min = String.valueOf((dauerSekunden %= 3600L) / 60L);
            String seconds = String.valueOf(dauerSekunden % 60L);
            this.arr[8] = this.fuellen(2, hours) + ":" + this.fuellen(2, min) + ":" + this.fuellen(2, seconds);
        } else {
            this.arr[8] = "";
        }
    }

    private String fuellen(int anz, String s) {
        while (((String)s).length() < anz) {
            s = "0" + (String)s;
        }
        return s;
    }

    private void checkZeit(String datum, String zeit, String fehlermeldung) {
        zeit = zeit.trim();
        if (!datum.isEmpty() && !zeit.isEmpty()) {
            if (zeit.contains(":") && zeit.length() == 8) {
                this.arr[7] = zeit;
            } else {
                P2Log.errorLog(159623647, "[" + zeit + "] " + fehlermeldung);
            }
        }
    }

    private void checkDatum(String datum, String fehlermeldung) {
        if ((datum = datum.trim()).contains(".") && datum.length() == 10) {
            try {
                LocalDate filmDate = LocalDate.parse(datum, DATUM_FORMATTER);
                if (filmDate.getYear() < 1900) {
                    P2Log.errorLog(923012125, "Unsinniger Wert: [" + datum + "] " + fehlermeldung);
                } else {
                    this.arr[6] = datum;
                }
            }
            catch (Exception var4) {
                P2Log.errorLog(794630593, var4);
                P2Log.errorLog(946301596, "[" + datum + "] " + fehlermeldung);
            }
        }
    }

    private static String normalize(String s) {
        return s != null ? Normalizer.normalize(s, Normalizer.Form.NFC) : null;
    }

    public static String cleanWhitespaces(String text) {
        return text.replaceAll("[\\t\\n\\x0B\\f\\r]", "").replace("\u00a0", " ");
    }

    private static String cleanDescription(String description) {
        description = ZdfDatenFilm.removeHtml(description);
        for (String legalNotice : LEGAL_NOTICES) {
            if (!description.contains(legalNotice)) continue;
            description = description.replace(legalNotice, "");
        }
        if (description.startsWith("|")) {
            description = description.substring(1).trim();
        }
        if (description.startsWith("Video-Clip")) {
            description = description.substring("Video-Clip".length()).trim();
        }
        if (description.startsWith(":") || description.startsWith(",") || description.startsWith("\n")) {
            description = description.substring(1).trim();
        }
        if (description.contains("\\\"")) {
            description = description.replace("\\\"", "\"");
        }
        return description.length() > 400 ? description.substring(0, 400) + "\n....." : description;
    }

    public static String removeHtml(String in) {
        return in.replaceAll("\\<.*?>", "");
    }

    @Override
    public String getIndex() {
        String url = this.getUrl();
        url = url.replaceFirst("https://nrodl", "https://rodl").replaceFirst("http://nrodl", "http://rodl");
        return this.arr[1].toLowerCase() + this.arr[2].toLowerCase() + url;
    }
}

