/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.controller.livesearchard;

import de.p2tools.mtplayer.controller.livesearch.tools.LiveConst;
import de.p2tools.p2lib.tools.log.P2Log;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class M3U8Dto {
    private final String url;
    private final Map<String, String> meta = new HashMap<String, String>();

    public M3U8Dto(String aUrl) {
        this.url = aUrl;
    }

    public String getUrl() {
        return this.url;
    }

    public void addMeta(String key, String value) {
        this.meta.put(key, value);
    }

    public Optional<String> getMeta(String key) {
        if (!this.meta.containsKey(key)) {
            return Optional.empty();
        }
        return Optional.of(this.meta.get(key));
    }

    public Optional<LiveConst.Qualities> getResolution() {
        Optional<String> codecMeta = this.getMeta("CODECS");
        Optional<String> resolution = this.getMeta("RESOLUTION");
        if (codecMeta.isPresent() && !codecMeta.get().contains("avc1")) {
            return Optional.empty();
        }
        if (resolution.isPresent()) {
            switch (resolution.get()) {
                case "192x144": 
                case "240x180": 
                case "256x144": 
                case "288x216": 
                case "320x180": 
                case "320x240": 
                case "360x270": 
                case "384x288": 
                case "424x240": 
                case "426x240": 
                case "442x240": 
                case "480x240": 
                case "480x270": 
                case "480x272": 
                case "480x320": 
                case "480x360": 
                case "512x288": {
                    return Optional.of(LiveConst.Qualities.SMALL);
                }
                case "636x360": 
                case "640x360": 
                case "640x480": 
                case "664x360": 
                case "720x360": 
                case "720x540": 
                case "720x544": 
                case "768x576": 
                case "852x480": 
                case "960x540": 
                case "960x544": 
                case "1024x576": 
                case "1064x576": 
                case "1152x576": {
                    return Optional.of(LiveConst.Qualities.NORMAL);
                }
                case "1280x720": 
                case "1330x720": 
                case "1440x720": 
                case "1920x1080": 
                case "2560x1440": 
                case "3840x2160": {
                    return Optional.of(LiveConst.Qualities.HD);
                }
            }
            P2Log.debugLog("Unknown resolution: {}" + resolution.get());
        }
        return Optional.empty();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        M3U8Dto other = (M3U8Dto)obj;
        if (this.url == null ? other.url != null : !this.url.equals(other.url)) {
            return false;
        }
        if (this.meta.size() != other.meta.size()) {
            return false;
        }
        for (Map.Entry<String, String> entry : this.meta.entrySet()) {
            String key = entry.getKey();
            if (!other.meta.containsKey(key)) {
                return false;
            }
            if (other.meta.get(key).equals(entry.getValue())) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hash = 7;
        hash = 23 * hash + Objects.hashCode(this.url);
        for (Map.Entry<String, String> entry : this.meta.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            hash = 23 * hash + Objects.hashCode(key) + Objects.hashCode(value);
        }
        return hash;
    }

    public Optional<String> getNormalizedMeta(String m3u8Resolution) {
        Optional<String> resolutionMeta = this.getMeta(m3u8Resolution);
        if (!resolutionMeta.isPresent()) {
            return Optional.empty();
        }
        String metaValue = resolutionMeta.get();
        int index = metaValue.indexOf(120);
        if (index == 4) {
            return resolutionMeta;
        }
        return Optional.of(String.format("0%sx0%s", metaValue.substring(0, index), metaValue.substring(index + 1)));
    }
}

