/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.controller.livesearchard;

import de.p2tools.mtplayer.controller.livesearch.tools.UrlUtils;
import java.util.Objects;
import java.util.Optional;

public class FilmUrlInfoDto {
    private final String url;
    private int height;
    private int width;
    private final Optional<String> fileType;

    public FilmUrlInfoDto(String aUrl) {
        this(aUrl, 0, 0);
    }

    public FilmUrlInfoDto(String aUrl, int aWidth, int aHeight) {
        this.url = aUrl;
        this.fileType = UrlUtils.getFileType(aUrl);
        this.width = aWidth;
        this.height = aHeight;
    }

    public String getUrl() {
        return this.url;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public Optional<String> getFileType() {
        return this.fileType;
    }

    public void setResolution(int aWidth, int aHeight) {
        this.width = aWidth;
        this.height = aHeight;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FilmUrlInfoDto that = (FilmUrlInfoDto)o;
        return this.height == that.height && this.width == that.width && Objects.equals(this.url, that.url) && Objects.equals(this.fileType, that.fileType);
    }

    public int hashCode() {
        return Objects.hash(this.url, this.height, this.width, this.fileType);
    }

    public String toString() {
        return "FilmUrlInfoDto{url='" + this.url + "', height=" + this.height + ", width=" + this.width + ", fileType=" + String.valueOf(this.fileType) + "}";
    }
}

