/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.controller.livesearchard;

import com.fasterxml.jackson.databind.JsonNode;
import de.p2tools.mtplayer.controller.livesearch.tools.JsonFactory;
import de.p2tools.mtplayer.controller.livesearch.tools.LiveConst;
import de.p2tools.mtplayer.controller.livesearch.tools.UrlUtils;
import de.p2tools.mtplayer.controller.livesearchard.ArdFilmUrlInfoDto;
import de.p2tools.mtplayer.controller.livesearchard.ArdUrlOptimizer;
import de.p2tools.mtplayer.controller.livesearchard.FilmUrlInfoDto;
import de.p2tools.p2lib.tools.log.P2Log;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;

public class ArdMediaArrayToDownloadUrlsConverter {
    private static final String ELEMENT_STREAM = "_stream";
    private static final String URL_PREFIX_PATTERN = "\\w+:";
    private static final String URL_PATTERN = "\\w+.*";
    private static final String ELEMENT_HEIGHT = "_height";
    private static final String ELEMENT_MEDIA_ARRAY = "_mediaArray";
    private static final String ELEMENT_MEDIA_STREAM_ARRAY = "_mediaStreamArray";
    private static final String ELEMENT_PLUGIN = "_plugin";
    private static final String ELEMENT_QUALITY = "_quality";
    private static final String ELEMENT_SERVER = "_server";
    private static final String ELEMENT_SORT_ARRAY = "_sortierArray";
    private static final String ELEMENT_WIDTH = "_width";
    private static final String PROTOCOL_RTMP = "rtmp";
    private static final String FILE_TYPE_F4M = "f4m";
    private final ArdUrlOptimizer ardOptimizer = new ArdUrlOptimizer();
    private final Map<LiveConst.Qualities, Set<ArdFilmUrlInfoDto>> urls = new EnumMap<LiveConst.Qualities, Set<ArdFilmUrlInfoDto>>(LiveConst.Qualities.class);

    private static List<ArdFilmUrlInfoDto> filterUrls(Set<ArdFilmUrlInfoDto> aUrls, String aFileType) {
        return aUrls.stream().filter(url -> url.getFileType().isPresent() && url.getFileType().get().equalsIgnoreCase(aFileType)).collect(Collectors.toList());
    }

    private static Optional<LiveConst.Qualities> getQuality(String qualityAsText) {
        int qualityNumber;
        try {
            if (qualityAsText.equals("auto")) {
                return Optional.of(LiveConst.Qualities.NORMAL);
            }
            qualityNumber = Integer.parseInt(qualityAsText);
        }
        catch (NumberFormatException numberFormatException) {
            P2Log.debugLog("Can't convert quality %s to an integer. " + qualityAsText);
            qualityNumber = -1;
        }
        if (qualityNumber > 0) {
            return Optional.of(ArdMediaArrayToDownloadUrlsConverter.getQualityForNumber(qualityNumber));
        }
        return Optional.empty();
    }

    private static String determineUrl(LiveConst.Qualities resolution, Set<ArdFilmUrlInfoDto> aUrls) {
        if (aUrls.isEmpty()) {
            return "";
        }
        List<ArdFilmUrlInfoDto> urls2 = ArdMediaArrayToDownloadUrlsConverter.filterUrls(aUrls, "mp4");
        ArdFilmUrlInfoDto ardUrlInfo = !urls2.isEmpty() ? ArdMediaArrayToDownloadUrlsConverter.getRelevantUrlMp4(resolution, urls2) : (!(urls2 = ArdMediaArrayToDownloadUrlsConverter.filterUrls(aUrls, "m3u8")).isEmpty() ? urls2.get(0) : aUrls.iterator().next());
        if (ardUrlInfo != null) {
            return ardUrlInfo.getUrl();
        }
        return "";
    }

    private static int extractPluginValue(JsonNode aJsonObject) {
        JsonNode pluginElement;
        Iterator<JsonNode> it;
        if (aJsonObject.has(ELEMENT_SORT_ARRAY) && (it = (pluginElement = aJsonObject.get(ELEMENT_SORT_ARRAY)).elements()).hasNext()) {
            return it.next().asInt();
        }
        return 1;
    }

    public Map<LiveConst.Qualities, URL> toDownloadUrls(JsonNode jsonElement) {
        int pluginValue = ArdMediaArrayToDownloadUrlsConverter.extractPluginValue(jsonElement);
        if (jsonElement.has(ELEMENT_MEDIA_ARRAY)) {
            Iterator<JsonNode> it = jsonElement.get(ELEMENT_MEDIA_ARRAY).elements();
            this.parseMediaArray(pluginValue, it);
        }
        return this.extractRelevantUrls();
    }

    private void addUrl(String url, String qualityText, LiveConst.Qualities quality, Optional<String> height, Optional<String> width) {
        if (!url.isEmpty()) {
            if (url.startsWith(PROTOCOL_RTMP)) {
                P2Log.debugLog("Found an Sendung with the old RTMP format: " + url);
            } else {
                ArdFilmUrlInfoDto info = new ArdFilmUrlInfoDto(UrlUtils.removeParameters(UrlUtils.addProtocolIfMissing(url, "https:")), qualityText);
                if (height.isPresent() && width.isPresent()) {
                    info.setResolution(Integer.parseInt(width.get()), Integer.parseInt(height.get()));
                }
                if (!this.urls.containsKey((Object)quality)) {
                    this.urls.put(quality, new LinkedHashSet());
                }
                this.urls.get((Object)quality).add(info);
            }
        }
    }

    private Map<LiveConst.Qualities, URL> extractRelevantUrls() {
        EnumMap<LiveConst.Qualities, URL> downloadUrls = new EnumMap<LiveConst.Qualities, URL>(LiveConst.Qualities.class);
        this.removeAutoM3u8IfMp4Exists();
        this.urls.entrySet().stream().filter(entry -> !((Set)entry.getValue()).isEmpty()).filter(ArdMediaArrayToDownloadUrlsConverter::isFileTypeRelevant).forEach(entry -> this.finalizeUrl((Map.Entry<LiveConst.Qualities, Set<ArdFilmUrlInfoDto>>)entry).ifPresent(url -> downloadUrls.put((LiveConst.Qualities)((Object)((Object)((Object)entry.getKey()))), (URL)url)));
        if (!downloadUrls.containsKey((Object)LiveConst.Qualities.NORMAL) && this.urls.containsKey((Object)LiveConst.Qualities.HD)) {
            Optional<URL> normalUrl = this.determineNormalUrlFromHd(this.urls.get((Object)LiveConst.Qualities.HD));
            normalUrl.ifPresent(url -> downloadUrls.put(LiveConst.Qualities.NORMAL, (URL)url));
        }
        return downloadUrls;
    }

    private void removeAutoM3u8IfMp4Exists() {
        AtomicBoolean existsMp4 = new AtomicBoolean(false);
        this.urls.values().forEach(set -> set.forEach(value -> {
            Optional<String> fileType = UrlUtils.getFileType(value.getUrl());
            if (fileType.isPresent() && "mp4".equalsIgnoreCase(fileType.get())) {
                existsMp4.set(true);
            }
        }));
        if (existsMp4.get() && this.urls.containsKey((Object)LiveConst.Qualities.NORMAL)) {
            this.urls.get((Object)LiveConst.Qualities.NORMAL).removeIf(urlInfo -> urlInfo.getQuality().equalsIgnoreCase("auto"));
        }
    }

    private Optional<URL> determineNormalUrlFromHd(Set<ArdFilmUrlInfoDto> ardFilmUrlInfoDtos) {
        FilmUrlInfoDto relevantInfo = null;
        for (ArdFilmUrlInfoDto info : ardFilmUrlInfoDtos) {
            if (info.getWidth() <= 0 || info.getHeight() <= 0) continue;
            if (relevantInfo == null) {
                relevantInfo = info;
                continue;
            }
            if (((ArdFilmUrlInfoDto)relevantInfo).getQuality().compareTo(info.getQuality()) <= 0) continue;
            relevantInfo = info;
        }
        if (relevantInfo != null) {
            try {
                return Optional.of(new URL(relevantInfo.getUrl()));
            }
            catch (MalformedURLException malformedUrlException) {
                P2Log.errorLog(987541258, (Exception)malformedUrlException, "A download URL is defect.");
            }
        }
        return Optional.empty();
    }

    private static boolean isFileTypeRelevant(Map.Entry<LiveConst.Qualities, Set<ArdFilmUrlInfoDto>> entry) {
        return entry.getValue().stream().anyMatch(video -> video.getFileType().isPresent() && !FILE_TYPE_F4M.equalsIgnoreCase(video.getFileType().get()));
    }

    private Optional<URL> finalizeUrl(Map.Entry<LiveConst.Qualities, Set<ArdFilmUrlInfoDto>> entry) {
        String url = ArdMediaArrayToDownloadUrlsConverter.determineUrl(entry.getKey(), entry.getValue());
        if (!url.isEmpty()) {
            try {
                return Optional.of(new URL(this.optimizeUrl(entry.getKey(), url)));
            }
            catch (MalformedURLException malformedUrlException) {
                P2Log.errorLog(987201204, (Exception)malformedUrlException, "A download URL is defect.");
            }
        }
        return Optional.empty();
    }

    private String optimizeUrl(LiveConst.Qualities key, String url) {
        if (key == LiveConst.Qualities.HD) {
            return this.ardOptimizer.optimizeHdUrl(url);
        }
        return url;
    }

    private static LiveConst.Qualities getQualityForNumber(int i) {
        switch (i) {
            case 0: 
            case 1: {
                return LiveConst.Qualities.SMALL;
            }
            case 3: 
            case 4: {
                return LiveConst.Qualities.HD;
            }
            case 5: {
                return LiveConst.Qualities.UHD;
            }
        }
        return LiveConst.Qualities.NORMAL;
    }

    private static ArdFilmUrlInfoDto getRelevantUrlMp4(LiveConst.Qualities aQualities, List<ArdFilmUrlInfoDto> aUrls) {
        switch (aQualities) {
            case SMALL: {
                return aUrls.get(0);
            }
            case NORMAL: {
                return aUrls.get(aUrls.size() - 1);
            }
            case HD: {
                ArdFilmUrlInfoDto relevantInfo = null;
                for (ArdFilmUrlInfoDto info : aUrls) {
                    String url;
                    if (info.getWidth() >= 1280 && info.getHeight() >= 720) {
                        if (relevantInfo == null) {
                            relevantInfo = info;
                        } else if (relevantInfo.getQuality().compareTo(info.getQuality()) < 0) {
                            relevantInfo = info;
                        }
                    }
                    if (info.getWidth() != 0 || info.getHeight() != 0 || (url = info.getUrl()).startsWith("960", url.lastIndexOf(47) + 1)) continue;
                    if (relevantInfo == null) {
                        relevantInfo = info;
                        continue;
                    }
                    if (relevantInfo.getQuality().compareTo(info.getQuality()) >= 0) continue;
                    relevantInfo = info;
                }
                return relevantInfo;
            }
        }
        return null;
    }

    private void parseMediaArray(int pluginValue, Iterator<JsonNode> mediaArray) {
        while (mediaArray.hasNext()) {
            JsonNode jsonNode = mediaArray.next();
            if (!jsonNode.has(ELEMENT_PLUGIN) || jsonNode.get(ELEMENT_PLUGIN).asInt() != pluginValue || !jsonNode.has(ELEMENT_MEDIA_STREAM_ARRAY)) continue;
            Iterator<JsonNode> it = jsonNode.get(ELEMENT_MEDIA_STREAM_ARRAY).elements();
            this.parseMediaStreamArray(it);
        }
    }

    private void parseMediaStreamArray(Iterator<JsonNode> it) {
        while (it.hasNext()) {
            JsonNode videoElement = it.next();
            String qualityAsText = JsonFactory.getString(videoElement, ELEMENT_QUALITY);
            Optional<LiveConst.Qualities> quality = ArdMediaArrayToDownloadUrlsConverter.getQuality(qualityAsText);
            if (!quality.isPresent()) continue;
            this.parseMediaStreamServer(videoElement, qualityAsText, quality.get());
            this.parseMediaStreamStream(videoElement, qualityAsText, quality.get());
        }
    }

    private void parseMediaStreamServer(JsonNode videoElement, String qualityText, LiveConst.Qualities quality) {
        if (videoElement.has(ELEMENT_SERVER)) {
            String baseUrl = videoElement.get(ELEMENT_SERVER).asText();
            String downloadUrl = this.videoElementToUrl(videoElement, baseUrl);
            this.addUrl(downloadUrl, qualityText, quality, Optional.empty(), Optional.empty());
        }
    }

    private void parseMediaStreamStream(JsonNode videoElement, String qualityText, LiveConst.Qualities quality) {
        if (videoElement.has(ELEMENT_STREAM)) {
            JsonNode videoObject = videoElement;
            JsonNode streamObject = videoObject.get(ELEMENT_STREAM);
            Optional<String> height = JsonFactory.getOptStringElement(videoObject, ELEMENT_HEIGHT);
            Optional<String> width = JsonFactory.getOptStringElement(videoObject, ELEMENT_WIDTH);
            if (streamObject.isValueNode()) {
                String baseUrl = streamObject.asText();
                String downloadUrl = this.videoElementToUrl(videoElement, baseUrl);
                this.addUrl(downloadUrl, qualityText, quality, height, width);
            } else if (streamObject.isArray()) {
                Iterator<JsonNode> it = streamObject.elements();
                while (it.hasNext()) {
                    JsonNode jn = it.next();
                    this.addUrl(jn.asText(), qualityText, quality, height, width);
                }
            }
        }
    }

    private String videoElementToUrl(JsonNode videoElement, String baseUrl) {
        if (baseUrl.isEmpty()) {
            return baseUrl;
        }
        Object url = videoElement.get(ELEMENT_STREAM).asText();
        if (((String)url).equals(baseUrl)) {
            return url;
        }
        url = ((String)url).matches("\\w+:\\w+.*") ? ((String)url).replaceFirst(URL_PREFIX_PATTERN, baseUrl) : baseUrl + (String)url;
        return url;
    }
}

