/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.controller.livesearchard;

import com.fasterxml.jackson.databind.JsonNode;
import de.p2tools.mtplayer.controller.film.FilmDataMTP;
import de.p2tools.mtplayer.controller.livesearch.JsonInfoDto;
import de.p2tools.mtplayer.controller.livesearch.tools.JsonFactory;
import de.p2tools.mtplayer.controller.livesearch.tools.LiveConst;
import de.p2tools.mtplayer.controller.livesearch.tools.LiveFactory;
import de.p2tools.mtplayer.controller.livesearch.tools.UrlUtils;
import de.p2tools.mtplayer.controller.livesearchard.ArdFilmDto;
import de.p2tools.mtplayer.controller.livesearchard.ArdFilmInfoDto;
import de.p2tools.mtplayer.controller.livesearchard.ArdVideoInfoDto;
import de.p2tools.mtplayer.controller.livesearchard.ArdVideoInfoJsonDeserializer;
import de.p2tools.mtplayer.controller.livesearchzdf.ZdfDatenFilm;
import de.p2tools.p2lib.tools.log.P2Log;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;

public class ArdFilmDeserializer {
    private static final String GERMAN_TIME_ZONE = "Europe/Berlin";
    private static final String ELEMENT_EMBEDDED = "embedded";
    private static final String ELEMENT_MEDIA_COLLECTION = "mediaCollection";
    private static final String ELEMENT_PUBLICATION_SERVICE = "publicationService";
    private static final String ELEMENT_SHOW = "show";
    private static final String ELEMENT_TEASERS = "teasers";
    private static final String ELEMENT_WIDGETS = "widgets";
    private static final String ATTRIBUTE_BROADCAST = "broadcastedOn";
    private static final String ATTRIBUTE_DURATION = "_duration";
    private static final String ATTRIBUTE_ID = "id";
    private static final String ATTRIBUTE_NAME = "name";
    private static final String ATTRIBUTE_PARTNER = "partner";
    private static final String ATTRIBUTE_SYNOPSIS = "synopsis";
    private static final String ATTRIBUTE_TITLE = "title";
    private static final DateTimeFormatter DATE_FORMAT = DateTimeFormatter.ofPattern("dd.MM.yyyy");
    private static final DateTimeFormatter TIME_FORMAT = DateTimeFormatter.ofPattern("HH:mm:ss");
    private static final Map<String, String> ADDITIONAL_SENDER = new HashMap<String, String>();
    private final ArdVideoInfoJsonDeserializer videoDeserializer = new ArdVideoInfoJsonDeserializer();

    public void deserialize(JsonInfoDto jsonInfoDto, JsonNode jsonElement) {
        if (!jsonElement.has(ELEMENT_WIDGETS) || !jsonElement.get(ELEMENT_WIDGETS).isArray()) {
            return;
        }
        Iterator<JsonNode> widgets = jsonElement.get(ELEMENT_WIDGETS).elements();
        if (!widgets.hasNext()) {
            return;
        }
        JsonNode itemObject = widgets.next();
        Optional<String> topic = ArdFilmDeserializer.parseTopic(itemObject);
        Optional<String> title = this.parseTitle(itemObject);
        Optional<String> description = itemObject.has(ATTRIBUTE_SYNOPSIS) ? Optional.of(itemObject.get(ATTRIBUTE_SYNOPSIS).asText()) : Optional.empty();
        Optional<LocalDateTime> date = ArdFilmDeserializer.parseDate(itemObject);
        Optional<Duration> duration = ArdFilmDeserializer.parseDuration(itemObject);
        Optional<ArdVideoInfoDto> videoInfo = this.parseVideoUrls(itemObject);
        Optional<String> partner = this.parsePartner(itemObject);
        if (topic.isPresent() && title.isPresent() && videoInfo.isPresent() && videoInfo.get().getVideoUrls().size() > 0) {
            ArdFilmDto filmDto = new ArdFilmDto(this.createFilm("ARD", topic.get(), title.get(), description, date, duration, videoInfo.get()));
            if (widgets.hasNext()) {
                this.parseRelatedFilms(filmDto, widgets.next());
            }
            this.addFilmToList(jsonInfoDto, filmDto);
            if (partner.isPresent() && ADDITIONAL_SENDER.containsKey(partner.get())) {
                FilmDataMTP additionalFilm = this.createFilm(ADDITIONAL_SENDER.get(partner.get()), topic.get(), title.get(), description, date, duration, videoInfo.get());
                this.addFilmToList(jsonInfoDto, new ArdFilmDto(additionalFilm));
            }
        }
    }

    private void addFilmToList(JsonInfoDto jsonInfoDto, ArdFilmDto filmDataMTP) {
        filmDataMTP.getFilm().arr[15] = String.format("https://www.ardmediathek.de/video/%s", jsonInfoDto.getArdFilmId());
        LiveFactory.setFilmSize(filmDataMTP.getFilm());
        filmDataMTP.getFilm().init();
        jsonInfoDto.getList().add(filmDataMTP.getFilm());
    }

    private static Optional<JsonNode> getMediaCollectionObject(JsonNode itemObject) {
        if (itemObject.has(ELEMENT_MEDIA_COLLECTION) && !itemObject.get(ELEMENT_MEDIA_COLLECTION).isEmpty() && itemObject.get(ELEMENT_MEDIA_COLLECTION).has(ELEMENT_EMBEDDED) && !itemObject.get(ELEMENT_MEDIA_COLLECTION).get(ELEMENT_EMBEDDED).isEmpty()) {
            return Optional.of(itemObject.get(ELEMENT_MEDIA_COLLECTION).get(ELEMENT_EMBEDDED));
        }
        return Optional.empty();
    }

    private static Optional<String> parseTopic(JsonNode playerPageObject) {
        JsonNode showObject;
        Optional<Object> topic = playerPageObject.has(ELEMENT_SHOW) && !playerPageObject.get(ELEMENT_SHOW).isEmpty() ? ((showObject = playerPageObject.get(ELEMENT_SHOW)).has(ATTRIBUTE_TITLE) ? Optional.of(showObject.get(ATTRIBUTE_TITLE).asText()) : Optional.empty()) : (playerPageObject.has(ATTRIBUTE_TITLE) ? Optional.of(playerPageObject.get(ATTRIBUTE_TITLE).asText()) : Optional.empty());
        if (topic.isPresent() && ((String)topic.get()).contains("MDR aktuell")) {
            return Optional.of(((String)topic.get()).replaceAll("[0-9][0-9]:[0-9][0-9] Uhr$", "").trim());
        }
        return topic;
    }

    private Optional<String> parseTitle(JsonNode playerPageObject) {
        if (playerPageObject.has(ATTRIBUTE_TITLE)) {
            Optional<String> title = Optional.of(playerPageObject.get(ATTRIBUTE_TITLE).asText());
            if (title.isPresent()) {
                return Optional.of(title.get().replace("H\u00f6rfassung", "Audiodeskription"));
            }
            return title;
        }
        return Optional.empty();
    }

    private static Optional<LocalDateTime> parseDate(JsonNode playerPageObject) {
        if (!playerPageObject.has(ATTRIBUTE_BROADCAST)) {
            return Optional.empty();
        }
        Optional<String> dateValue = Optional.of(playerPageObject.get(ATTRIBUTE_BROADCAST).asText());
        if (dateValue.isPresent()) {
            try {
                ZonedDateTime inputDateTime = ZonedDateTime.parse(dateValue.get());
                LocalDateTime localDateTime = inputDateTime.withZoneSameInstant(ZoneId.of(GERMAN_TIME_ZONE)).toLocalDateTime();
                return Optional.of(localDateTime);
            }
            catch (DateTimeParseException ex) {
                P2Log.errorLog(201214587, (Exception)ex, "Error parsing date time value " + dateValue.get());
            }
        }
        return Optional.empty();
    }

    private static Optional<Duration> parseDuration(JsonNode playerPageObject) {
        Optional<JsonNode> mediaCollectionObject = ArdFilmDeserializer.getMediaCollectionObject(playerPageObject);
        if (mediaCollectionObject.isPresent() && mediaCollectionObject.get().has(ATTRIBUTE_DURATION)) {
            long durationValue = mediaCollectionObject.get().get(ATTRIBUTE_DURATION).asLong();
            return Optional.of(Duration.ofSeconds(durationValue));
        }
        return Optional.empty();
    }

    private Optional<String> parsePartner(JsonNode playerPageObject) {
        if (playerPageObject.has(ELEMENT_PUBLICATION_SERVICE)) {
            JsonNode publicationServiceObject = playerPageObject.get(ELEMENT_PUBLICATION_SERVICE);
            Optional<String> partnerAttribute = JsonFactory.getOptStringElement(publicationServiceObject, ATTRIBUTE_PARTNER);
            if (partnerAttribute.isPresent()) {
                return partnerAttribute;
            }
            Optional<String> nameAttribute = JsonFactory.getOptStringElement(publicationServiceObject, ATTRIBUTE_NAME);
            if (nameAttribute.isPresent()) {
                return Optional.of(nameAttribute.get());
            }
        }
        return Optional.empty();
    }

    private static String prepareSubtitleUrl(String url) {
        return UrlUtils.addDomainIfMissing(url, "https://classic.ardmediathek.de");
    }

    private void parseRelatedFilms(ArdFilmDto filmDto, JsonNode playerPageObject) {
        if (playerPageObject.has(ELEMENT_TEASERS)) {
            JsonNode teasersElement = playerPageObject.get(ELEMENT_TEASERS);
            Iterator<JsonNode> it = teasersElement.elements();
            while (it.hasNext()) {
                JsonNode teasersItemElement = it.next();
                Optional<String> id = JsonFactory.getOptStringElement(teasersItemElement, ATTRIBUTE_ID);
                if (!id.isPresent()) continue;
                String url = "https://api.ardmediathek.de/page-gateway/pages/ard/item/" + id.get();
                filmDto.addRelatedFilm(new ArdFilmInfoDto(id.get(), url, 0));
            }
        }
    }

    private FilmDataMTP createFilm(String sender, String topic, String title, Optional<String> description, Optional<LocalDateTime> date, Optional<Duration> duration, ArdVideoInfoDto videoInfo) {
        LocalDateTime time = date.orElse(LocalDateTime.now());
        String dateValue = time.format(DATE_FORMAT);
        String timeValue = time.format(TIME_FORMAT);
        Map<LiveConst.Qualities, String> videoUrls = videoInfo.getVideoUrls();
        ZdfDatenFilm film = new ZdfDatenFilm(sender, topic, "", title, videoInfo.getDefaultVideoUrl(), dateValue, timeValue, duration.orElse(Duration.ZERO).getSeconds(), description.orElse(""));
        if (videoUrls.containsKey((Object)LiveConst.Qualities.SMALL)) {
            LiveFactory.addUrlKlein(film, videoUrls.get((Object)LiveConst.Qualities.SMALL));
        }
        if (videoUrls.containsKey((Object)LiveConst.Qualities.HD)) {
            LiveFactory.addUrlHd(film, videoUrls.get((Object)LiveConst.Qualities.HD));
        }
        if (videoInfo.getSubtitleUrlOptional().isPresent()) {
            LiveFactory.addUrlSubtitle(film, videoInfo.getSubtitleUrl());
        }
        return film;
    }

    private Optional<ArdVideoInfoDto> parseVideoUrls(JsonNode playerPageObject) {
        Optional<JsonNode> mediaCollectionObject = ArdFilmDeserializer.getMediaCollectionObject(playerPageObject);
        if (mediaCollectionObject.isPresent()) {
            ArdVideoInfoDto videoDto = this.videoDeserializer.deserialize(mediaCollectionObject.get());
            return Optional.of(videoDto);
        }
        return Optional.empty();
    }

    static {
        ADDITIONAL_SENDER.put("rbb", "RBB");
        ADDITIONAL_SENDER.put("swr", "SWR");
        ADDITIONAL_SENDER.put("mdr", "MDR");
        ADDITIONAL_SENDER.put("ndr", "NDR");
        ADDITIONAL_SENDER.put("wdr", "WDR");
        ADDITIONAL_SENDER.put("hr", "HR");
        ADDITIONAL_SENDER.put("br", "BR");
        ADDITIONAL_SENDER.put("radio_bremen", "rbtv");
    }
}

