/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.controller.history;

import de.p2tools.mtplayer.controller.config.PEvents;
import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.history.HistoryData;
import de.p2tools.mtplayer.controller.history.HistoryFactory;
import de.p2tools.p2lib.tools.duration.P2Duration;
import de.p2tools.p2lib.tools.log.P2Log;
import java.io.BufferedWriter;
import java.io.OutputStreamWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.List;
import javafx.beans.property.BooleanProperty;

public class HistoryWriteToFile
implements Runnable {
    private final List<HistoryData> list;
    private final boolean append;
    private final BooleanProperty isWorking;
    private final String settingsDir;
    private final String fileName;

    public HistoryWriteToFile(String settingsDir, String fileName, List<HistoryData> list, boolean append, BooleanProperty isWorking) {
        this.settingsDir = settingsDir;
        this.fileName = fileName;
        this.list = list;
        this.append = append;
        this.isWorking = isWorking;
    }

    @Override
    public void run() {
        this.doWork();
        this.isWorking.setValue(false);
    }

    private void doWork() {
        Path urlPath = HistoryFactory.getUrlFilePath(this.settingsDir, this.fileName);
        if (Files.notExists(urlPath, new LinkOption[0])) {
            return;
        }
        P2Duration.counterStart("doWork");
        if (this.append) {
            P2Log.sysLog("An Historyliste anf\u00fcgen: " + this.list.size() + ", Datei: " + this.fileName);
        } else {
            P2Log.sysLog("Ganze Historyliste schreiben: " + this.list.size() + ", Datei: " + this.fileName);
        }
        this.writeHistoryDataToFile(this.list, this.append);
        this.list.clear();
        ProgData.getInstance().pEventHandler.notifyListener(PEvents.EVENT_HISTORY_CHANGED);
        P2Duration.counterStop("doWork");
    }

    private boolean writeHistoryDataToFile(List<HistoryData> list, boolean append) {
        boolean ret = false;
        try (BufferedWriter bufferedWriter = append ? new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(HistoryFactory.getUrlFilePath(this.settingsDir, this.fileName), StandardOpenOption.APPEND))) : new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(HistoryFactory.getUrlFilePath(this.settingsDir, this.fileName), new OpenOption[0])));){
            for (HistoryData historyData : list) {
                String line = HistoryFactory.getLine(historyData);
                bufferedWriter.write(line);
            }
            ret = true;
        }
        catch (Exception ex) {
            P2Log.errorLog(420312459, ex);
        }
        return ret;
    }
}

