/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.controller.history;

import de.p2tools.mtplayer.controller.config.PEvents;
import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.data.download.DownloadData;
import de.p2tools.mtplayer.controller.film.FilmDataMTP;
import de.p2tools.mtplayer.controller.film.FilmToolsFactory;
import de.p2tools.mtplayer.controller.history.HistoryData;
import de.p2tools.mtplayer.controller.history.HistoryFactory;
import de.p2tools.mtplayer.controller.history.HistoryWriteToFile;
import de.p2tools.p2lib.alert.P2Alert;
import de.p2tools.p2lib.tools.date.P2DateConst;
import de.p2tools.p2lib.tools.duration.P2Duration;
import de.p2tools.p2lib.tools.log.P2Log;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import javafx.stage.Stage;

public class HistoryList
extends SimpleListProperty<HistoryData> {
    private final HISTORY_LIST historyEnum;
    private final HashSet<String> urlHash = new HashSet();
    private final String settingsDir;
    private final String fileName;
    private FilteredList<HistoryData> filteredList = null;
    private SortedList<HistoryData> sortedList = null;
    private final BooleanProperty isWorking = new SimpleBooleanProperty(false);
    private boolean found = false;

    public HistoryList(String fileName, String settingsDir, HISTORY_LIST historyEnum) {
        super(FXCollections.observableArrayList());
        this.settingsDir = settingsDir;
        this.fileName = fileName;
        this.historyEnum = historyEnum;
    }

    public void loadList() {
        P2Duration.counterStart("loadList");
        HistoryFactory.readHistoryDataFromFile(this.settingsDir, this.fileName, this);
        this.fillUrlHash();
        P2Duration.counterStop("loadList");
    }

    public SortedList<HistoryData> getSortedList() {
        this.filteredList = this.getFilteredList();
        if (this.sortedList == null) {
            this.sortedList = new SortedList<HistoryData>((ObservableList<HistoryData>)this.filteredList);
        }
        return this.sortedList;
    }

    public FilteredList<HistoryData> getFilteredList() {
        if (this.filteredList == null) {
            this.filteredList = new FilteredList<HistoryData>(this, p -> true);
        }
        return this.filteredList;
    }

    public synchronized void filteredListSetPredicate(Predicate<HistoryData> predicate) {
        this.filteredList.setPredicate(predicate);
    }

    public synchronized void filteredListSetPredFalse() {
        this.filteredList.setPredicate(p -> false);
    }

    public synchronized void filteredListSetPredTrue() {
        this.filteredList.setPredicate(p -> true);
    }

    public synchronized void clearAll(Stage stage) {
        int size = this.size();
        String title = this.historyEnum.equals((Object)HISTORY_LIST.BOOKMARK) ? "Bookmarks" : "Filme";
        if (size <= 1 || P2Alert.showAlertOkCancel(stage, "L\u00f6schen", title + " l\u00f6schen", "Soll die gesamte Liste (" + size + " " + title + ") gel\u00f6scht werden?")) {
            this.clearList();
            HistoryFactory.deleteHistoryFile(this.settingsDir, this.fileName);
            if (this.historyEnum.equals((Object)HISTORY_LIST.BOOKMARK)) {
                FilmToolsFactory.clearAllBookmarks();
            } else if (this.historyEnum.equals((Object)HISTORY_LIST.HISTORY)) {
                ProgData.getInstance().filmList.forEach(film -> {
                    film.setShown(false);
                    film.setActHist(false);
                });
            }
            ProgData.getInstance().pEventHandler.notifyListener(PEvents.EVENT_HISTORY_CHANGED);
        }
    }

    public synchronized boolean checkIfUrlAlreadyIn(String urlFilm) {
        return this.urlHash.contains(urlFilm);
    }

    public synchronized void addHistoryDataToHistory(String theme, String title, String url) {
        if (this.checkIfUrlAlreadyIn(url) || HistoryFactory.checkIfLiveStream(theme)) {
            return;
        }
        P2Duration.counterStart("addHistoryDataToHistory");
        ArrayList<HistoryData> list = new ArrayList<HistoryData>();
        String datum = P2DateConst.F_FORMAT_dd_MM_yyyy.format(new Date());
        HistoryData historyData = new HistoryData(datum, theme, title, url);
        this.addToThisList(historyData);
        list.add(historyData);
        this.writeToFile(list, true);
        P2Duration.counterStop("addHistoryDataToHistory");
    }

    public synchronized void addFilmDataListToHistory(List<FilmDataMTP> filmList) {
        if (filmList == null || filmList.isEmpty()) {
            return;
        }
        ArrayList<HistoryData> list = new ArrayList<HistoryData>(filmList.size());
        String datum = P2DateConst.F_FORMAT_dd_MM_yyyy.format(new Date());
        P2Duration.counterStart("addFilmDataToHistory");
        for (FilmDataMTP film : filmList) {
            if (film.isLive()) continue;
            if (this.historyEnum.equals((Object)HISTORY_LIST.BOOKMARK)) {
                film.setBookmark(true);
            } else if (this.historyEnum.equals((Object)HISTORY_LIST.HISTORY)) {
                film.setShown(true);
                film.setActHist(true);
            }
            if (this.checkIfUrlAlreadyIn(film.getUrlHistory())) continue;
            HistoryData historyData = new HistoryData(datum, film.arr[2], film.arr[3], film.getUrlHistory());
            this.addToThisList(historyData);
            list.add(historyData);
        }
        this.writeToFile(list, true);
        P2Duration.counterStop("addFilmDataToHistory");
    }

    public synchronized void addDownloadDataListToHistory(ArrayList<DownloadData> downloadList) {
        if (downloadList == null || downloadList.isEmpty()) {
            return;
        }
        ArrayList<HistoryData> list = new ArrayList<HistoryData>(downloadList.size());
        String datum = P2DateConst.F_FORMAT_dd_MM_yyyy.format(new Date());
        P2Duration.counterStart("addDownloadDataListToHistory");
        for (DownloadData download : downloadList) {
            if (HistoryFactory.checkIfLiveStream(download.getTheme()) || !download.getSetData().isPlay() && !download.getSetData().isSave()) continue;
            if (this.historyEnum.equals((Object)HISTORY_LIST.BOOKMARK) && download.getFilm() != null) {
                download.getFilm().setBookmark(true);
            } else if (this.historyEnum.equals((Object)HISTORY_LIST.HISTORY) && download.getFilm() != null) {
                download.getFilm().setShown(true);
                download.getFilm().setActHist(true);
            }
            if (this.checkIfUrlAlreadyIn(download.getHistoryUrl())) continue;
            HistoryData historyData = new HistoryData(datum, download.getTheme(), download.getTitle(), download.getHistoryUrl());
            this.addToThisList(historyData);
            list.add(historyData);
        }
        this.writeToFile(list, true);
        P2Duration.counterStop("addDownloadDataListToHistory");
    }

    public synchronized void removeHistoryDataFromHistory(ArrayList<HistoryData> historyDataList) {
        if (historyDataList == null || historyDataList.isEmpty()) {
            return;
        }
        P2Duration.counterStart("History: removeDataFromHistory");
        HashSet<String> hash = new HashSet<String>(historyDataList.size() + 1, 0.75f);
        for (HistoryData historyData : historyDataList) {
            hash.add(historyData.getUrl());
        }
        ProgData.getInstance().filmList.stream().forEach(film -> {
            if (hash.contains(film.getUrlForHash())) {
                film.setShown(false);
                film.setActHist(false);
            }
        });
        this.removeFromHistory(hash);
        hash.clear();
        P2Duration.counterStop("History: removeDataFromHistory");
    }

    public synchronized void removeFilmDataFromHistory(ArrayList<FilmDataMTP> filmList) {
        if (filmList == null || filmList.isEmpty()) {
            return;
        }
        P2Duration.counterStart("History: removeDataFromHistory");
        HashSet<String> hash = new HashSet<String>(filmList.size() + 1, 0.75f);
        filmList.forEach((? super E film) -> {
            if (this.historyEnum.equals((Object)HISTORY_LIST.BOOKMARK)) {
                film.setBookmark(false);
            } else if (this.historyEnum.equals((Object)HISTORY_LIST.HISTORY)) {
                film.setShown(false);
                film.setActHist(false);
            }
            hash.add(film.getUrlHistory());
        });
        this.removeFromHistory(hash);
        hash.clear();
        P2Duration.counterStop("History: removeDataFromHistory");
    }

    public synchronized void removeDownloadDataFromHistory(List<DownloadData> downloadList) {
        if (downloadList == null || downloadList.isEmpty()) {
            return;
        }
        P2Duration.counterStart("History: removeDataFromHistory");
        HashSet<String> hash = new HashSet<String>(downloadList.size() + 1, 0.75f);
        downloadList.forEach(download -> {
            if (this.historyEnum.equals((Object)HISTORY_LIST.BOOKMARK) && download.getFilm() != null) {
                download.getFilm().setBookmark(false);
            } else if (this.historyEnum.equals((Object)HISTORY_LIST.HISTORY) && download.getFilm() != null) {
                download.getFilm().setShown(false);
                download.getFilm().setActHist(false);
            }
            hash.add(download.getHistoryUrl());
        });
        this.removeFromHistory(hash);
        hash.clear();
        P2Duration.counterStop("History: removeDataFromHistory");
    }

    private void removeFromHistory(HashSet<String> removeUrlHash) {
        ArrayList<HistoryData> newHistoryList = new ArrayList<HistoryData>();
        this.found = false;
        P2Duration.counterStart("History: removeFromHistory");
        P2Log.sysLog("Aus Historyliste l\u00f6schen: " + removeUrlHash.size() + ", l\u00f6schen aus: " + this.fileName);
        this.waitWhileWorking();
        this.forEach(historyData -> {
            if (removeUrlHash.contains(historyData.getUrl())) {
                this.found = true;
            } else {
                newHistoryList.add((HistoryData)historyData);
            }
        });
        if (this.found) {
            this.replaceThisList(newHistoryList);
            this.writeToFile(newHistoryList, false);
        }
        P2Duration.counterStop("History: removeFromHistory");
    }

    private void writeToFile(List<HistoryData> list, boolean append) {
        this.waitWhileWorkingAndSetWorking();
        try {
            Thread th = new Thread(new HistoryWriteToFile(this.settingsDir, this.fileName, list, append, this.isWorking));
            th.setName("HistoryWriteToFile");
            th.start();
        }
        catch (Exception ex) {
            P2Log.errorLog(912030254, ex, "writeToFile");
            this.isWorking.setValue(false);
        }
    }

    private void waitWhileWorking() {
        while (this.isWorking.get()) {
            P2Log.errorLog(741025896, "waitWhileWorking: write to history file");
            try {
                this.wait(100L);
            }
            catch (Exception ex) {
                P2Log.errorLog(915236547, ex, "waitWhileWorking");
                this.isWorking.setValue(false);
            }
        }
    }

    private void waitWhileWorkingAndSetWorking() {
        this.waitWhileWorking();
        this.isWorking.setValue(true);
    }

    private void clearList() {
        this.urlHash.clear();
        this.clear();
    }

    private void addToThisList(HistoryData historyData) {
        this.add(historyData);
        this.urlHash.add(historyData.getUrl());
    }

    private void replaceThisList(List<HistoryData> historyData) {
        this.clearList();
        this.addAll(historyData);
        this.fillUrlHash();
    }

    private void fillUrlHash() {
        this.urlHash.clear();
        this.forEach(h -> this.urlHash.add(h.getUrl()));
    }

    public static enum HISTORY_LIST {
        HISTORY,
        ABO,
        BOOKMARK;

    }
}

