/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.controller.history;

import de.p2tools.mtplayer.controller.history.HistoryData;
import de.p2tools.p2lib.P2LibConst;
import de.p2tools.p2lib.tools.log.P2Log;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;

public class HistoryFactory {
    private static final String SEPARATOR_1 = " |#| ";
    private static final String SEPARATOR_2 = "  |###|  ";

    private HistoryFactory() {
    }

    public static boolean checkIfLiveStream(String theme) {
        return theme.equals("Livestream");
    }

    public static synchronized Path getUrlFilePath(String settingsDir, String fileName) {
        Path urlPath = null;
        try {
            urlPath = Paths.get(settingsDir, new String[0]).resolve(fileName);
            if (Files.notExists(urlPath, new LinkOption[0])) {
                urlPath = Files.createFile(urlPath, new FileAttribute[0]);
            }
        }
        catch (IOException ex) {
            P2Log.errorLog(915478960, ex);
        }
        return urlPath;
    }

    public static synchronized void deleteHistoryFile(String settingsDir, String fileName) {
        try {
            Path urlPath = HistoryFactory.getUrlFilePath(settingsDir, fileName);
            Files.deleteIfExists(urlPath);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static synchronized void readHistoryDataFromFile(String settingsDir, String fileName, List<HistoryData> dataList) {
        Path urlPath = HistoryFactory.getUrlFilePath(settingsDir, fileName);
        try (LineNumberReader in = new LineNumberReader(new InputStreamReader(Files.newInputStream(urlPath, new OpenOption[0])));){
            String line;
            while ((line = in.readLine()) != null) {
                HistoryData historyData = HistoryFactory.getHistoryDataFromLine(line);
                dataList.add(historyData);
            }
        }
        catch (Exception ex) {
            P2Log.errorLog(926362547, ex);
        }
    }

    public static String getLine(HistoryData historyData) {
        String dateStr = historyData.getDate().toString();
        String theme = historyData.getTheme();
        String title = historyData.getTitle();
        String url = historyData.getUrl();
        if (dateStr.isEmpty() && theme.isEmpty() && title.isEmpty()) {
            return url + P2LibConst.LINE_SEPARATOR;
        }
        return dateStr + SEPARATOR_1 + HistoryFactory.cleanUp(theme) + SEPARATOR_1 + HistoryFactory.cleanUp(title) + SEPARATOR_2 + url + P2LibConst.LINE_SEPARATOR;
    }

    private static String cleanUp(String s) {
        s = s.replace("\n", "");
        s = s.replace("\r\n", "");
        s = s.replace(P2LibConst.LINE_SEPARATOR, "");
        s = s.replace("|", "");
        s = s.replace(SEPARATOR_1, "");
        s = s.replace(SEPARATOR_2, "");
        return s;
    }

    private static HistoryData getHistoryDataFromLine(String line) {
        String url = "";
        String theme = "";
        String title = "";
        String date = "";
        try {
            if (line.contains(SEPARATOR_2)) {
                int a1 = line.lastIndexOf(SEPARATOR_2);
                url = line.substring(a1 += SEPARATOR_2.length()).trim();
                title = line.substring(line.lastIndexOf(SEPARATOR_1) + SEPARATOR_1.length(), line.lastIndexOf(SEPARATOR_2)).trim();
                date = line.substring(0, line.indexOf(SEPARATOR_1)).trim();
                theme = line.substring(line.indexOf(SEPARATOR_1) + SEPARATOR_1.length(), line.lastIndexOf(SEPARATOR_1)).trim();
            } else {
                url = line;
            }
        }
        catch (Exception ex) {
            P2Log.errorLog(398853224, ex);
        }
        return new HistoryData(date, theme, title, url);
    }
}

