/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.controller.history;

import de.p2tools.p2lib.mtfilm.tools.FilmDate;
import de.p2tools.p2lib.tools.GermanStringSorter;
import org.apache.commons.lang3.time.FastDateFormat;

public class HistoryData
implements Comparable<HistoryData> {
    private static final FastDateFormat sdf_datum = FastDateFormat.getInstance("dd.MM.yyyy");
    private static final GermanStringSorter sorter = GermanStringSorter.getInstance();
    public final String title;
    public final String theme;
    public final String url;
    public FilmDate date;

    public HistoryData(String date, String theme, String title, String url) {
        this.title = title;
        this.theme = theme;
        this.url = url;
        try {
            this.date = new FilmDate(sdf_datum.parse(date).getTime());
        }
        catch (Exception ignore) {
            this.date = new FilmDate(0L);
        }
    }

    public String getTitle() {
        return this.title;
    }

    public String getTheme() {
        return this.theme;
    }

    public String getUrl() {
        return this.url;
    }

    public FilmDate getDate() {
        return this.date;
    }

    @Override
    public int compareTo(HistoryData arg0) {
        return sorter.compare(this.getTitle(), arg0.getTitle());
    }
}

