/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.controller.filmfilter;

import de.p2tools.mtplayer.controller.filmfilter.FilmFilter;
import de.p2tools.p2lib.configfile.config.Config;
import de.p2tools.p2lib.configfile.config.Config_stringProp;
import de.p2tools.p2lib.configfile.pdata.P2DataSample;
import java.util.ArrayList;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;

public class TextFilter
extends P2DataSample<TextFilter>
implements Comparable<TextFilter> {
    public static String TAG = "TextFilter";
    private final StringProperty channel = new SimpleStringProperty("");
    private final StringProperty theme = new SimpleStringProperty("");
    private final StringProperty themeTitle = new SimpleStringProperty("");
    private final StringProperty title = new SimpleStringProperty("");
    private final StringProperty somewhere = new SimpleStringProperty("");

    public TextFilter() {
    }

    @Override
    public Config[] getConfigsArr() {
        ArrayList<Config_stringProp> list = new ArrayList<Config_stringProp>();
        list.add(new Config_stringProp("channel", this.channel));
        list.add(new Config_stringProp("theme", this.theme));
        list.add(new Config_stringProp("themeTitle", this.themeTitle));
        list.add(new Config_stringProp("title", this.title));
        list.add(new Config_stringProp("somewhere", this.somewhere));
        return list.toArray(new Config[0]);
    }

    @Override
    public String getTag() {
        return TAG;
    }

    public TextFilter(FilmFilter filmFilter) {
        if (filmFilter.isChannelVis()) {
            this.channel.set(filmFilter.getChannel());
        }
        if (filmFilter.isThemeVis()) {
            this.theme.set(filmFilter.isThemeIsExact() ? filmFilter.getExactTheme() : filmFilter.getTheme());
        }
        if (filmFilter.isThemeTitleVis()) {
            this.themeTitle.set(filmFilter.getThemeTitle());
        }
        if (filmFilter.isTitleVis()) {
            this.title.set(filmFilter.getTitle());
        }
        if (filmFilter.isSomewhereVis()) {
            this.somewhere.set(filmFilter.getSomewhere());
        }
    }

    public void clearFilter() {
        this.channel.set("");
        this.theme.set("");
        this.themeTitle.set("");
        this.title.set("");
        this.somewhere.set("");
    }

    public boolean filterIsEmpty() {
        if (!this.getChannel().isEmpty()) {
            return false;
        }
        if (!this.getTheme().isEmpty()) {
            return false;
        }
        if (!this.getThemeTitle().isEmpty()) {
            return false;
        }
        if (!this.getTitle().isEmpty()) {
            return false;
        }
        return this.getSomewhere().isEmpty();
    }

    public boolean filterIsSame(TextFilter tf) {
        if (!this.getChannel().equals(tf.getChannel())) {
            return false;
        }
        if (!this.getTheme().equals(tf.getTheme())) {
            return false;
        }
        if (!this.getThemeTitle().equals(tf.getThemeTitle())) {
            return false;
        }
        if (!this.getTitle().equals(tf.getTitle())) {
            return false;
        }
        return this.getSomewhere().equals(tf.getSomewhere());
    }

    public String getChannel() {
        return this.channel.getValueSafe();
    }

    public void setChannel(String channel) {
        this.channel.set(channel);
    }

    public StringProperty channelProperty() {
        return this.channel;
    }

    public String getTheme() {
        return this.theme.getValueSafe();
    }

    public void setTheme(String theme) {
        this.theme.set(theme);
    }

    public StringProperty themeProperty() {
        return this.theme;
    }

    public String getThemeTitle() {
        return this.themeTitle.getValueSafe();
    }

    public void setThemeTitle(String themeTitle) {
        this.themeTitle.set(themeTitle);
    }

    public StringProperty themeTitleProperty() {
        return this.themeTitle;
    }

    public String getTitle() {
        return this.title.getValueSafe();
    }

    public void setTitle(String title) {
        this.title.set(title);
    }

    public StringProperty titleProperty() {
        return this.title;
    }

    public String getSomewhere() {
        return this.somewhere.getValueSafe();
    }

    public void setSomewhere(String somewhere) {
        this.somewhere.set(somewhere);
    }

    public StringProperty somewhereProperty() {
        return this.somewhere;
    }
}

