/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.controller.filmfilter;

import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.filmfilter.FastFilmFilter;
import de.p2tools.mtplayer.controller.filmfilter.FilmFilter;
import de.p2tools.p2lib.mtfilm.film.FilmData;
import de.p2tools.p2lib.mtfilm.film.FilmDataProps;
import de.p2tools.p2lib.mtfilter.FilmFilterCheck;
import de.p2tools.p2lib.mtfilter.Filter;
import java.util.function.Predicate;

public class PredicateFactory {
    private PredicateFactory() {
    }

    public static Predicate<FilmData> getPredicate(ProgData progData) {
        long days;
        FilmFilter filmFilter = progData.filterWorker.getActFilterSettings();
        FastFilmFilter fastFilmFilter = progData.filterWorker.getFastFilterSettings();
        String filterChannel = filmFilter.isChannelVis() ? filmFilter.getChannel() : "";
        String filterSomewhere = filmFilter.isSomewhereVis() ? filmFilter.getSomewhere() : "";
        String filterUrl = filmFilter.isUrlVis() ? filmFilter.getUrl() : "";
        String filterShowDate = filmFilter.isShowDateVis() ? filmFilter.getShowDate() : "";
        Filter fChannel = new Filter(filterChannel, true);
        Filter fSomewhere = new Filter(filterSomewhere, true);
        Filter fUrl = new Filter(filterUrl, false);
        Filter fShowDate = new Filter(filterShowDate, false);
        boolean onlyBookmark = filmFilter.isOnlyVis() && filmFilter.isOnlyBookmark();
        boolean onlyHd = filmFilter.isOnlyVis() && filmFilter.isOnlyHd();
        boolean onlyUt = filmFilter.isOnlyVis() && filmFilter.isOnlyUt();
        boolean onlyMark = filmFilter.isOnlyVis() && filmFilter.isOnlyMark();
        boolean onlyLive = filmFilter.isOnlyVis() && filmFilter.isOnlyLive();
        boolean onlyNew = filmFilter.isOnlyVis() && filmFilter.isOnlyNew();
        boolean onlyAktHist = filmFilter.isOnlyVis() && filmFilter.getOnlyActHistory();
        boolean noAbos = filmFilter.isNotVis() && filmFilter.isNotAbo();
        boolean noShown = filmFilter.isNotVis() && filmFilter.isNotHistory();
        boolean noDouble = filmFilter.isNotVis() && filmFilter.isNotDouble();
        boolean noGeo = filmFilter.isNotVis() && filmFilter.isNotGeo();
        boolean noFuture = filmFilter.isNotVis() && filmFilter.isNotFuture();
        int checkBlack = filmFilter.blacklistOnOffProperty().getValue();
        int minLengthMinute = filmFilter.isMinMaxDurVis() ? filmFilter.getMinDur() : 0;
        int maxLengthMinute = filmFilter.isMinMaxDurVis() ? filmFilter.getMaxDur() : 150;
        int minTimeSec = filmFilter.isMinMaxTimeVis() ? filmFilter.getMinTime() : 0;
        int maxTimeSec = filmFilter.isMinMaxTimeVis() ? filmFilter.getMaxTime() : 86400;
        boolean minMaxTimeInvert = filmFilter.isMinMaxTimeInvert();
        try {
            if (filmFilter.getTimeRange() == 0) {
                days = 0L;
            } else {
                long max = 86400000L * (long)filmFilter.getTimeRange();
                days = System.currentTimeMillis() - max;
            }
        }
        catch (Exception ex) {
            days = 0L;
        }
        if (!filmFilter.isTimeRangeVis()) {
            days = 0L;
        }
        Predicate<FilmData> predicate = film -> true;
        if (onlyBookmark) {
            predicate = predicate.and(FilmDataProps::isBookmark);
        }
        if (onlyHd) {
            predicate = predicate.and(FilmDataProps::isHd);
        }
        if (onlyUt) {
            predicate = predicate.and(FilmDataProps::isUt);
        }
        if (onlyMark) {
            predicate = predicate.and(FilmDataProps::isMark);
        }
        if (onlyLive) {
            predicate = predicate.and(FilmDataProps::isLive);
        }
        if (onlyAktHist) {
            predicate = predicate.and(FilmDataProps::isActHist);
        }
        if (onlyNew) {
            predicate = predicate.and(FilmDataProps::isNewFilm);
        }
        if (noAbos) {
            predicate = predicate.and(f -> f.arr[16].isEmpty());
        }
        if (noShown) {
            predicate = predicate.and(f -> !f.isShown());
        }
        if (noDouble) {
            predicate = predicate.and(f -> !f.isDoubleUrl());
        }
        if (noGeo) {
            predicate = predicate.and(f -> !f.isGeoBlocked());
        }
        if (noFuture) {
            predicate = predicate.and(f -> !f.isInFuture());
        }
        if (checkBlack != 0) {
            predicate = checkBlack == 1 ? predicate.and(f -> !f.isBlackBlocked()) : predicate.and(FilmDataProps::isBlackBlocked);
        }
        if (days != 0L) {
            long d = days;
            predicate = predicate.and(f -> FilmFilterCheck.checkDays(d, f.filmDate.getTime()));
        }
        if (minLengthMinute != 0) {
            predicate = predicate.and(f -> FilmFilterCheck.checkMatchLengthMin(minLengthMinute, f.getDurationMinute()));
        }
        if (maxLengthMinute != 150) {
            predicate = predicate.and(f -> FilmFilterCheck.checkMatchLengthMax(maxLengthMinute, f.getDurationMinute()));
        }
        if (minTimeSec != 0 || maxTimeSec != 86400) {
            predicate = predicate.and(f -> FilmFilterCheck.checkMatchFilmTime(minTimeSec, maxTimeSec, minMaxTimeInvert, f.filmTime));
        }
        predicate = PredicateFactory.addFastFilter(filmFilter, fastFilmFilter, predicate);
        if (!fChannel.isEmpty) {
            predicate = predicate.and(f -> FilmFilterCheck.checkMatchChannelSmart(fChannel, f));
        }
        if (!fSomewhere.isEmpty) {
            predicate = predicate.and(f -> FilmFilterCheck.checkMatchSomewhere(fSomewhere, f));
        }
        if (!fUrl.isEmpty) {
            predicate = predicate.and(f -> FilmFilterCheck.checkMatchUrl(fUrl, f));
        }
        if (!fShowDate.filter.equals("")) {
            predicate = predicate.and(f -> PredicateFactory.checkShowDate(filmFilter.getShowDate(), f));
        }
        return predicate;
    }

    private static Predicate<FilmData> addFastFilter(FilmFilter filmFilter, FastFilmFilter fastFilmFilter, Predicate<FilmData> predicate) {
        Filter fastFilter = new Filter(fastFilmFilter.getFilterTerm(), true);
        boolean themeIsExact = filmFilter.isThemeIsExact();
        String filterTheme = filmFilter.isThemeVis() ? filmFilter.getResTheme() : "";
        Filter fTheme = new Filter(filterTheme, themeIsExact, true);
        String filterThemeTitle = filmFilter.isThemeTitleVis() ? filmFilter.getThemeTitle() : "";
        Filter fThemeTitle = new Filter(filterThemeTitle, true);
        String filterTitle = filmFilter.isTitleVis() ? filmFilter.getTitle() : "";
        Filter fTitle = new Filter(filterTitle, true);
        if (ProgConfig.FAST_SEARCH_ON.getValue().booleanValue() && ProgConfig.FAST_SEARCH_WHERE.getValue() == 0) {
            if (!fastFilter.isEmpty) {
                predicate = predicate.and(f -> FilmFilterCheck.checkMatchThemeTitle(fastFilter, f));
            }
        } else if (!fThemeTitle.isEmpty) {
            predicate = predicate.and(f -> FilmFilterCheck.checkMatchThemeTitle(fThemeTitle, f));
        }
        if (ProgConfig.FAST_SEARCH_ON.getValue().booleanValue() && ProgConfig.FAST_SEARCH_WHERE.getValue() == 1) {
            if (!fastFilter.isEmpty) {
                predicate = predicate.and(f -> FilmFilterCheck.checkMatchTheme(fastFilter, f));
            }
        } else if (!fTheme.isEmpty) {
            predicate = predicate.and(f -> FilmFilterCheck.checkMatchThemeExact(fTheme, f));
        }
        if (ProgConfig.FAST_SEARCH_ON.getValue().booleanValue() && ProgConfig.FAST_SEARCH_WHERE.getValue() == 2) {
            if (!fastFilter.isEmpty) {
                predicate = predicate.and(f -> FilmFilterCheck.checkMatchTitle(fastFilter, f));
            }
        } else if (!fTitle.isEmpty) {
            predicate = predicate.and(f -> FilmFilterCheck.checkMatchTitle(fTitle, f));
        }
        return predicate;
    }

    private static boolean checkShowDate(String showDate, FilmData film) {
        if (showDate.isEmpty() || film.filmDate.isEmpty()) {
            return true;
        }
        return film.arr[6].equals(showDate);
    }
}

