/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.controller.filmfilter;

import de.p2tools.mtplayer.controller.config.PEvents;
import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.film.FilmDataMTP;
import de.p2tools.mtplayer.controller.film.FilmListMTP;
import de.p2tools.mtplayer.controller.filmfilter.LiveFilter;
import de.p2tools.p2lib.mtfilm.film.FilmData;
import de.p2tools.p2lib.mtfilter.FilmFilterCheck;
import de.p2tools.p2lib.mtfilter.Filter;
import de.p2tools.p2lib.p2event.P2Listener;
import java.util.function.Predicate;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;

public final class LiveFilmFilterWorker {
    private final LiveFilter actFilterSettings = new LiveFilter();
    private final FilmListMTP liveFilmList = new FilmListMTP();

    public LiveFilmFilterWorker(ProgData progData) {
        progData.pEventHandler.addListener(new P2Listener(PEvents.EVENT_LIVE_FILTER_CHANGED){

            @Override
            public void ping() {
                LiveFilmFilterWorker.this.filterList();
            }
        });
    }

    public FilteredList<FilmDataMTP> getFilteredList() {
        return this.liveFilmList.getFilteredList();
    }

    public SortedList<FilmDataMTP> getSortedList() {
        return this.liveFilmList.getSortedList();
    }

    public FilmListMTP getLiveFilmList() {
        return this.liveFilmList;
    }

    public LiveFilter getActFilterSettings() {
        return this.actFilterSettings;
    }

    public synchronized void clearFilter() {
        this.actFilterSettings.clearFilter();
        this.filterList();
    }

    private void filterList() {
        Predicate<FilmData> predicate = filter -> true;
        String channel = this.getActFilterSettings().channelProperty().getValueSafe();
        String theme = this.getActFilterSettings().themeProperty().getValueSafe();
        String title = this.getActFilterSettings().titleProperty().getValueSafe();
        Filter fChannel = new Filter(channel, true);
        if (!fChannel.isEmpty) {
            predicate = predicate.and(f -> FilmFilterCheck.checkMatchChannelSmart(fChannel, f));
        }
        Filter fTheme = new Filter(theme, false, true);
        if (!fTheme.isEmpty) {
            predicate = predicate.and(f -> FilmFilterCheck.checkMatchThemeExact(fTheme, f));
        }
        Filter fTitle = new Filter(title, true);
        if (!fTitle.isEmpty) {
            predicate = predicate.and(f -> FilmFilterCheck.checkMatchTitle(fTitle, f));
        }
        this.liveFilmList.getFilteredList().setPredicate(predicate);
    }
}

