/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.controller.filmfilter;

import de.p2tools.mtplayer.controller.config.PEvents;
import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.data.abo.AboData;
import de.p2tools.mtplayer.controller.data.blackdata.BlacklistFilterFactory;
import de.p2tools.mtplayer.controller.filmfilter.BackwardFilmFilter;
import de.p2tools.mtplayer.controller.filmfilter.FastFilmFilter;
import de.p2tools.mtplayer.controller.filmfilter.FilmFilter;
import de.p2tools.mtplayer.controller.filmfilter.FilmFilterList;
import de.p2tools.mtplayer.controller.worker.ThemeListFactory;
import java.util.Optional;

public final class FilterWorker {
    public static final String SELECTED_FILTER_NAME = "aktuelle Einstellung";
    private final FilmFilter actFilterSettings = new FilmFilter("aktuelle Einstellung");
    private final FilmFilterList filmFilterList = new FilmFilterList();
    private final FilmFilterList backwardFilterList = new FilmFilterList("BackwardFilterList");
    private final FilmFilterList forwardFilterList = new FilmFilterList("ForwardFilterList");
    private final FastFilmFilter fastFilter = new FastFilmFilter();
    private final BackwardFilmFilter backwardFilmFilter = new BackwardFilmFilter();

    public FilterWorker() {
        this.getActFilterSettings().channelProperty().addListener(l -> ThemeListFactory.createThemeList(ProgData.getInstance(), this.getActFilterSettings().channelProperty().getValueSafe()));
    }

    public FilmFilter getActFilterSettings() {
        return this.actFilterSettings;
    }

    public FilmFilterList getFilmFilterList() {
        return this.filmFilterList;
    }

    public FilmFilterList getBackwardFilterList() {
        return this.backwardFilterList;
    }

    public FilmFilterList getForwardFilterList() {
        return this.forwardFilterList;
    }

    public FastFilmFilter getFastFilterSettings() {
        return this.fastFilter;
    }

    public BackwardFilmFilter getBackwardFilmFilter() {
        return this.backwardFilmFilter;
    }

    public synchronized void setActFilterSettings(FilmFilter sf) {
        if (sf == null) {
            return;
        }
        this.actFilterSettings.switchFilterOff(true);
        int black = this.actFilterSettings.blacklistOnOffProperty().getValue();
        sf.copyTo(this.actFilterSettings);
        this.actFilterSettings.switchFilterOff(false);
        if (this.actFilterSettings.blacklistOnOffProperty().getValue() == black) {
            this.postFilterChange();
        } else {
            this.postBlacklistChange();
        }
    }

    public synchronized void setFilterFromAbo(Optional<AboData> oAbo) {
        if (oAbo.isEmpty()) {
            return;
        }
        AboData abo = oAbo.get();
        this.actFilterSettings.switchFilterOff(true);
        this.actFilterSettings.turnOffFilter();
        this.actFilterSettings.setChannelAndVis(abo.getChannel());
        this.actFilterSettings.setThemeAndVis(abo.getTheme(), abo.isThemeExact());
        this.actFilterSettings.setThemeTitleAndVis(abo.getThemeTitle());
        this.actFilterSettings.setTitleAndVis(abo.getTitle());
        this.actFilterSettings.setSomewhereVis(true);
        this.actFilterSettings.setSomewhere(abo.getSomewhere());
        this.actFilterSettings.setMinMaxDurVis(true);
        this.actFilterSettings.setMinDur(abo.getMinDurationMinute());
        this.actFilterSettings.setMaxDur(abo.getMaxDurationMinute());
        this.actFilterSettings.setTimeRangeVis(true);
        this.actFilterSettings.setTimeRange(abo.getTimeRange());
        this.forwardFilterList.clear();
        this.actFilterSettings.switchFilterOff(false);
        this.postFilterChange();
    }

    public synchronized void clearFilter() {
        this.actFilterSettings.switchFilterOff(true);
        if (this.actFilterSettings.isTextFilterEmpty()) {
            this.actFilterSettings.clearFilter();
        } else {
            this.actFilterSettings.clearTxtFilter();
        }
        this.forwardFilterList.clear();
        this.actFilterSettings.switchFilterOff(false);
        this.postFilterChange();
    }

    private void postFilterChange() {
        this.backwardFilmFilter.addBackward();
        ProgData.getInstance().pEventHandler.notifyListener(PEvents.EVENT_FILTER_CHANGED);
    }

    private void postBlacklistChange() {
        BlacklistFilterFactory.makeBlackFilteredFilmlist();
        ProgData.getInstance().pEventHandler.notifyListener(PEvents.EVENT_FILTER_CHANGED);
    }
}

