/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.controller.filmfilter;

import de.p2tools.mtplayer.controller.config.PEvents;
import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.filmfilter.FilmFilter;
import de.p2tools.mtplayer.controller.filmfilter.PredicateFactory;
import de.p2tools.mtplayer.controller.worker.ThemeListFactory;
import de.p2tools.p2lib.p2event.P2Listener;
import de.p2tools.p2lib.tools.duration.P2Duration;
import de.p2tools.p2lib.tools.log.P2Log;
import java.util.concurrent.atomic.AtomicBoolean;
import javafx.application.Platform;

public class FilmFilterRunner {
    private final ProgData progData;
    private static final AtomicBoolean search = new AtomicBoolean(false);
    private static final AtomicBoolean research = new AtomicBoolean(false);
    private int count = 0;

    public FilmFilterRunner(final ProgData progData) {
        this.progData = progData;
        progData.aboList.listChangedProperty().addListener((observable2, oldValue, newValue) -> this.filterList());
        progData.pEventHandler.addListener(new P2Listener(PEvents.EVENT_FILTER_CHANGED){

            @Override
            public void ping() {
                FilmFilterRunner.this.filterList();
            }
        });
        progData.pEventHandler.addListener(new P2Listener(PEvents.EVENT_HISTORY_CHANGED){

            @Override
            public void ping() {
                FilmFilter filmFilter = progData.filterWorker.getActFilterSettings();
                if (filmFilter.isNotVis() && filmFilter.isNotHistory() || filmFilter.isOnlyVis() && filmFilter.getOnlyActHistory()) {
                    FilmFilterRunner.this.filterList();
                }
            }
        });
        progData.pEventHandler.addListener(new P2Listener(PEvents.EVENT_BLACKLIST_CHANGED){

            @Override
            public void ping() {
                FilmFilterRunner.this.filterList();
            }
        });
        progData.pEventHandler.addListener(new P2Listener(PEvents.EVENT_DIACRITIC_CHANGED){

            @Override
            public void ping() {
                FilmFilterRunner.this.filterList();
            }
        });
    }

    private void filterList() {
        P2Duration.counterStart("filterList");
        if (!search.getAndSet(true)) {
            research.set(false);
            try {
                Platform.runLater(() -> {
                    String text = "=======================================\n   ===== FILTERN: " + ++this.count + " =====\n=======================================";
                    P2Log.debugLog(text);
                    if (ProgData.getInstance().filterWorker.getActFilterSettings().isThemeVis() && ProgData.getInstance().filterWorker.getActFilterSettings().isThemeIsExact() && !ThemeListFactory.themeForChannelList.contains(ProgData.getInstance().filterWorker.getActFilterSettings().getExactTheme())) {
                        P2Log.debugLog("Clear filter");
                        this.progData.filterWorker.getActFilterSettings().switchFilterOff(true);
                        ProgData.getInstance().filterWorker.getActFilterSettings().setExactTheme("");
                        this.progData.filterWorker.getActFilterSettings().switchFilterOff(false);
                    }
                    this.progData.filmGuiController.getSel(true, false);
                    this.progData.filmListFiltered.filteredListSetPred(PredicateFactory.getPredicate(this.progData));
                    this.progData.filmGuiController.selectLastShown();
                    search.set(false);
                    if (research.get()) {
                        this.filterList();
                    }
                });
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else {
            research.set(true);
        }
        P2Duration.counterStop("filterList");
    }
}

