/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.controller.filmfilter;

import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.filmfilter.FilmFilter;
import de.p2tools.p2lib.alert.P2Alert;
import de.p2tools.p2lib.configfile.pdata.P2DataList;
import javafx.beans.property.SimpleListProperty;
import javafx.collections.FXCollections;

public final class FilmFilterList
extends SimpleListProperty<FilmFilter>
implements P2DataList<FilmFilter> {
    public String TAG = "SelectedFilterList";

    public FilmFilterList() {
        super(FXCollections.observableArrayList());
    }

    public FilmFilterList(String tag) {
        super(FXCollections.observableArrayList());
        this.TAG = tag;
    }

    @Override
    public String getTag() {
        return this.TAG;
    }

    @Override
    public String getComment() {
        return "Liste aller Filter";
    }

    @Override
    public FilmFilter getNewItem() {
        return new FilmFilter();
    }

    @Override
    public void addNewItem(Object obj) {
        if (obj.getClass().equals(FilmFilter.class)) {
            this.add((FilmFilter)obj);
        }
    }

    public FilmFilter getSameFilter(FilmFilter filmFilter) {
        for (FilmFilter f : this) {
            if (!f.isSame(filmFilter)) continue;
            return f;
        }
        return null;
    }

    public void addToList(FilmFilter e) {
        this.cleanBackForward();
        super.add(e);
    }

    private void cleanBackForward() {
        while (this.size() > 20) {
            this.remove(0);
        }
    }

    public int top(int idx, boolean up) {
        int ret;
        FilmFilter filmFilter = (FilmFilter)this.remove(idx);
        if (up) {
            this.add(0, filmFilter);
            ret = 0;
        } else {
            this.add(filmFilter);
            ret = this.getSize() - 1;
        }
        return ret;
    }

    public int up(int idx, boolean up) {
        FilmFilter filmFilter = (FilmFilter)this.remove(idx);
        int neu = idx;
        if (up) {
            if (neu > 0) {
                --neu;
            }
        } else if (neu < this.size()) {
            ++neu;
        }
        this.add(neu, filmFilter);
        return neu;
    }

    public void addNewStoredFilter(String name) {
        FilmFilter sf = new FilmFilter();
        ProgData.getInstance().filterWorker.getActFilterSettings().copyTo(sf);
        sf.setName(name.isEmpty() ? this.getNextName() : name);
        this.add(sf);
    }

    public String getNextName() {
        Object ret = "";
        int id = 1;
        boolean found = false;
        while (!found) {
            String name = "Filter " + id;
            if (this.stream().noneMatch(f -> name.equalsIgnoreCase(f.getName()))) {
                ret = name;
                found = true;
            }
            ++id;
        }
        return ret;
    }

    public boolean removeStoredFilter(FilmFilter sf) {
        if (sf == null) {
            return false;
        }
        if (P2Alert.showAlertOkCancel("L\u00f6schen", "Filterprofil l\u00f6schen", "Soll das Filterprofil: " + sf.getName() + "\ngel\u00f6scht werden?")) {
            this.remove(sf);
            return true;
        }
        return false;
    }

    public void removeAllStoredFilter() {
        if (P2Alert.showAlertOkCancel("L\u00f6schen", "Filterprofile l\u00f6schen", "Sollen alle Filterprofile gel\u00f6scht werden?")) {
            this.clear();
        }
    }

    public void saveStoredFilter(FilmFilter sf) {
        if (sf == null) {
            return;
        }
        String name = sf.getName();
        ProgData.getInstance().filterWorker.getActFilterSettings().copyTo(sf);
        sf.setName(name);
    }
}

