/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.controller.filmfilter;

import de.p2tools.mtplayer.controller.config.PEvents;
import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.filmfilter.FastFilmFilterProps;
import de.p2tools.mtplayer.controller.filmfilter.Filter;
import de.p2tools.p2lib.tools.log.P2Log;
import javafx.animation.PauseTransition;
import javafx.util.Duration;

public final class FastFilmFilter
extends FastFilmFilterProps
implements Filter {
    private final PauseTransition pause = new PauseTransition(Duration.millis(ProgConfig.SYSTEM_FILTER_WAIT_TIME.getValue().intValue()));

    public FastFilmFilter() {
        this.initFilter();
    }

    public void clearFilter() {
        this.setFilterTerm("");
        if (ProgConfig.SYSTEM_FILTER_RETURN.getValue().booleanValue()) {
            this.reportFilterReturn();
        }
    }

    @Override
    public void reportFilterReturn() {
        P2Log.debugLog("reportFilterReturn");
        this.pause.stop();
        ProgData.getInstance().pEventHandler.notifyListener(PEvents.EVENT_FILTER_CHANGED);
    }

    private void initFilter() {
        this.pause.setOnFinished(event -> ProgData.getInstance().pEventHandler.notifyListener(PEvents.EVENT_FILTER_CHANGED));
        this.pause.setDuration(Duration.millis(ProgConfig.SYSTEM_FILTER_WAIT_TIME.getValue().intValue()));
        ProgConfig.SYSTEM_FILTER_WAIT_TIME.addListener((observable2, oldValue, newValue) -> {
            P2Log.debugLog("SYSTEM_FILTER_WAIT_TIME: " + ProgConfig.SYSTEM_FILTER_WAIT_TIME.getValue());
            this.pause.setDuration(Duration.millis(ProgConfig.SYSTEM_FILTER_WAIT_TIME.getValue().intValue()));
        });
        this.clearFilter();
        this.filterTermProperty().addListener(l -> this.setTxtFilterChange());
    }

    private void setTxtFilterChange() {
        if (ProgConfig.SYSTEM_FILTER_RETURN.getValue().booleanValue()) {
            this.pause.stop();
        } else {
            this.pause.playFromStart();
        }
    }
}

