/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.controller.film;

import de.p2tools.mtplayer.controller.ProgSave;
import de.p2tools.mtplayer.controller.config.PEvents;
import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.config.ProgInfos;
import de.p2tools.mtplayer.controller.data.abo.AboFactory;
import de.p2tools.mtplayer.controller.data.blackdata.BlacklistFilterFactory;
import de.p2tools.mtplayer.controller.data.download.DownloadListFactory;
import de.p2tools.mtplayer.controller.data.setdata.SetFactory;
import de.p2tools.mtplayer.controller.film.FilmListMTP;
import de.p2tools.mtplayer.controller.film.FilmToolsFactory;
import de.p2tools.mtplayer.controller.mediadb.MediaDataWorker;
import de.p2tools.mtplayer.controller.update.WhatsNewFactory;
import de.p2tools.mtplayer.gui.tools.ProgTipOfDayFactory;
import de.p2tools.p2lib.mtfilm.film.FilmlistFactory;
import de.p2tools.p2lib.mtfilm.loadfilmlist.LoadFilmlist;
import de.p2tools.p2lib.mtfilm.tools.LoadFactoryConst;
import de.p2tools.p2lib.p2event.P2Event;
import de.p2tools.p2lib.p2event.P2Listener;
import de.p2tools.p2lib.tools.duration.P2Duration;
import de.p2tools.p2lib.tools.log.P2Log;
import java.util.ArrayList;
import javafx.application.Platform;

public class LoadFilmListWorker {
    private static boolean doneAtProgramStart = false;
    public LoadFilmlist loadFilmlist;
    private final ProgData progData;

    public LoadFilmListWorker(final ProgData progData) {
        this.progData = progData;
        FilmListMTP filmlistNew = new FilmListMTP();
        FilmListMTP filmlistDiff = new FilmListMTP();
        this.loadFilmlist = new LoadFilmlist(progData.pEventHandler, filmlistNew, filmlistDiff);
        progData.pEventHandler.addListener(new P2Listener(PEvents.EVENT_FILMLIST_LOAD_START){

            public void pingGui(P2Event event) {
                ProgData.FILMLIST_IS_DOWNLOADING.setValue(true);
                progData.worker.workOnFilmListLoadStart();
                if (event.getAct() == -1.0) {
                    progData.maskerPane.setMaskerVisible(true, true, false);
                } else {
                    progData.maskerPane.setMaskerVisible(true, true, true);
                }
                progData.maskerPane.setMaskerProgress(event.getAct(), event.getText());
            }
        });
        progData.pEventHandler.addListener(new P2Listener(PEvents.EVENT_FILMLIST_LOAD_PROGRESS){

            public void pingGui(P2Event event) {
                progData.maskerPane.setMaskerProgress(event.getAct(), event.getText());
            }
        });
        progData.pEventHandler.addListener(new P2Listener(PEvents.EVENT_FILMLIST_LOAD_LOADED){

            @Override
            public void pingGui() {
                progData.maskerPane.setMaskerVisible(true, true, false);
                progData.maskerPane.setMaskerProgress(-1.0, "Filmliste verarbeiten");
                ProgData.FILMLIST_IS_DOWNLOADING.setValue(false);
            }
        });
        progData.pEventHandler.addListener(new P2Listener(PEvents.EVENT_FILMLIST_LOAD_FINISHED){

            @Override
            public void pingGui() {
                P2Duration.onlyPing("Filme geladen: Nachbearbeiten");
                LoadFilmListWorker.this.afterLoadingFilmList();
            }
        });
    }

    public void loadFilmlistProgStart() {
        this.initLoadFactoryConst();
        this.loadFilmlist.loadFilmlistProgStart();
    }

    public void loadNewListFromWeb(boolean alwaysLoadNew) {
        this.initLoadFactoryConst();
        if (!alwaysLoadNew && this.progData.filmGuiController != null) {
            this.progData.filmGuiController.getSel(true, false);
        }
        this.loadFilmlist.loadNewFilmlistFromWeb(alwaysLoadNew);
    }

    public void initLoadFactoryConst() {
        LoadFactoryConst.debug = ProgData.debug;
        LoadFactoryConst.GEO_HOME_PLACE = ProgConfig.SYSTEM_GEO_HOME_PLACE.getValue();
        LoadFactoryConst.SYSTEM_LOAD_NOT_SENDER = ProgConfig.SYSTEM_LOAD_NOT_SENDER.getValue();
        LoadFactoryConst.dateStoredFilmlist = ProgConfig.SYSTEM_FILMLIST_DATE.getValue();
        LoadFactoryConst.firstProgramStart = ProgData.firstProgramStart;
        LoadFactoryConst.localFilmListFile = ProgInfos.getLocalFilmListFile();
        LoadFactoryConst.loadNewFilmlistOnProgramStart = ProgConfig.SYSTEM_LOAD_FILMLIST_ON_PROGRAMSTART.getValue() != false || ProgData.autoMode;
        LoadFactoryConst.SYSTEM_LOAD_FILMLIST_MAX_DAYS = ProgConfig.SYSTEM_LOAD_FILMLIST_MAX_DAYS.getValue();
        LoadFactoryConst.SYSTEM_LOAD_FILMLIST_MIN_DURATION = ProgConfig.SYSTEM_LOAD_FILMLIST_MIN_DURATION.getValue();
        LoadFactoryConst.removeDiacritic = ProgConfig.SYSTEM_REMOVE_DIACRITICS.getValue();
        LoadFactoryConst.userAgent = ProgConfig.SYSTEM_USERAGENT.getValue();
        LoadFactoryConst.filmlist = this.progData.filmList;
        LoadFactoryConst.loadFilmlist = this.loadFilmlist;
        LoadFactoryConst.primaryStage = ProgData.getInstance().primaryStage;
        LoadFactoryConst.filmListUrl = ProgData.filmListUrl;
        if (ProgConfig.SYSTEM_FILMLIST_FILTER.getValue() == 0) {
            LoadFactoryConst.checker = null;
        } else if (ProgConfig.SYSTEM_FILMLIST_FILTER.getValue() == 1) {
            this.progData.filmListFilter.clearCounter();
            LoadFactoryConst.checker = filmData -> BlacklistFilterFactory.checkFilmAndCountHits(filmData, this.progData.filmListFilter, true);
        } else {
            this.progData.filmListFilter.clearCounter();
            LoadFactoryConst.checker = filmData -> !BlacklistFilterFactory.checkFilmAndCountHits(filmData, this.progData.filmListFilter, true);
        }
    }

    private void afterLoadingFilmList() {
        new Thread(() -> {
            ArrayList<String> logList = new ArrayList<String>();
            logList.add("Themen suchen");
            this.progData.filmList.loadTheme();
            logList.add("Abos eintragen");
            AboFactory.setAboForFilmlist();
            logList.add("Bookmarks eintragen");
            FilmToolsFactory.markBookmarks();
            logList.add("Blacklist filtern");
            this.progData.maskerPane.setMaskerText("Blacklist filtern");
            BlacklistFilterFactory.markFilmBlack(false);
            this.progData.blackList.sortAndCleanTheList();
            this.progData.filmListFilter.sortAndCleanTheList();
            logList.add("Filme in Downloads eingetragen");
            this.progData.maskerPane.setMaskerText("Downloads eingetragen");
            DownloadListFactory.addFilmInDownloads();
            P2Log.sysLog(logList);
            P2Duration.onlyPing("Filme nachbearbeiten: Ende");
            this.progData.maskerPane.setMaskerText("Abos suchen");
            this.progData.worker.workOnFilmListLoadFinished();
            this.progData.pEventHandler.notifyListener(PEvents.EVENT_FILTER_CHANGED);
            String filmDate = FilmlistFactory.getAgeAsStringDate(this.progData.filmList.metaData);
            ProgConfig.SYSTEM_FILMLIST_DATE.setValue(this.progData.filmList.isEmpty() ? "" : filmDate);
            this.progData.maskerPane.switchOffMasker();
            if (ProgData.firstProgramStart) {
                ProgData.firstProgramStart = false;
                Platform.runLater(ProgSave::saveAll);
            }
            if (!doneAtProgramStart) {
                doneAtProgramStart = true;
                MediaDataWorker.createMediaDb();
                if (!ProgData.autoMode) {
                    WhatsNewFactory.checkUpdate();
                    Platform.runLater(() -> {
                        ProgTipOfDayFactory.showDialog(ProgData.getInstance(), false);
                        if (ProgConfig.CHECK_SET_PROGRAM_START.get()) {
                            SetFactory.checkPrograms(this.progData.primaryStage, this.progData, false);
                        }
                    });
                }
            }
        }).start();
    }
}

