/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.controller.film;

import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.film.FilmDataMTP;
import de.p2tools.mtplayer.controller.film.FilmListMTP;
import de.p2tools.mtplayer.controller.history.HistoryList;
import de.p2tools.p2lib.alert.P2Alert;
import de.p2tools.p2lib.mtfilm.film.FilmData;
import de.p2tools.p2lib.mtfilm.film.FilmDataProps;
import de.p2tools.p2lib.mtfilm.tools.LoadFactoryConst;
import de.p2tools.p2lib.tools.duration.P2Duration;
import de.p2tools.p2lib.tools.log.P2Log;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import javafx.application.Platform;
import javafx.beans.property.ListProperty;
import javafx.stage.Stage;

public class FilmToolsFactory {
    private static int countDouble = 0;

    private FilmToolsFactory() {
    }

    public static void setFilmShown(ArrayList<FilmDataMTP> filmArrayList, boolean setShown) {
        if (setShown) {
            ProgData.getInstance().historyList.addFilmDataListToHistory(filmArrayList);
        } else {
            ProgData.getInstance().historyList.removeFilmDataFromHistory(filmArrayList);
        }
    }

    public static void changeBookmarkFilm(FilmDataMTP film) {
        FilmToolsFactory.bookmarkFilm(film, !film.isBookmark());
    }

    public static void bookmarkFilm(FilmDataMTP film, boolean bookmark) {
        ArrayList<FilmDataMTP> filmArrayList = new ArrayList<FilmDataMTP>(1);
        filmArrayList.add(film);
        FilmToolsFactory.bookmarkFilmList(filmArrayList, bookmark);
    }

    public static void bookmarkFilmList(ArrayList<FilmDataMTP> filmArrayList, boolean bookmark) {
        if (bookmark) {
            ProgData.getInstance().historyListBookmarks.addFilmDataListToHistory(filmArrayList);
        } else {
            ProgData.getInstance().historyListBookmarks.removeFilmDataFromHistory(filmArrayList);
        }
    }

    public static void clearAllBookmarks() {
        FilmListMTP filmlist = ProgData.getInstance().filmList;
        filmlist.stream().forEach(film -> film.setBookmark(false));
    }

    public static void markBookmarks() {
        if (ProgData.getInstance().historyListBookmarks.isEmpty()) {
            return;
        }
        FilmListMTP filmlist = ProgData.getInstance().filmList;
        HistoryList bookmarks = ProgData.getInstance().historyListBookmarks;
        filmlist.stream().forEach(film -> {
            if (bookmarks.checkIfUrlAlreadyIn(film.getUrlHistory())) {
                film.setBookmark(true);
            }
        });
    }

    public static ArrayList<String> getSenderListNotToLoad() {
        return new ArrayList<String>(Arrays.asList(ProgConfig.SYSTEM_LOAD_NOT_SENDER.getValue().split(",")));
    }

    public static void checkAllSenderSelectedNotToLoad(Stage stage) {
        ArrayList<String> aListSenderNotToLoad = FilmToolsFactory.getSenderListNotToLoad();
        boolean allSender = true;
        for (String sender : LoadFactoryConst.SENDER) {
            Optional<String> optional = aListSenderNotToLoad.stream().filter(aktSender -> aktSender.equals(sender)).findAny();
            if (!optional.isEmpty()) continue;
            allSender = false;
            break;
        }
        if (allSender) {
            Platform.runLater(() -> P2Alert.showErrorAlert(stage, "Sender laden", "Es werden keine Filme geladen. Alle Sender sind vom Laden ausgenommen!\n\nEinstellungen -> Filmliste laden"));
        }
    }

    public static int markFilms(ListProperty<? extends FilmData> filmList) {
        String[] senderArr = ProgConfig.SYSTEM_MARK_DOUBLE_CHANNEL_LIST.getValueSafe().split(",");
        HashSet<String> urlHashSet = new HashSet<String>(filmList.size(), 0.75f);
        countDouble = 0;
        P2Duration.counterStart("markFilms");
        if (senderArr.length == 0 || senderArr.length == 1 && senderArr[0].isEmpty()) {
            try {
                P2Duration.counterStart("mark(FilmData filmData)");
                filmList.forEach(f -> {
                    FilmToolsFactory.mark(f);
                    if (!urlHashSet.add(FilmToolsFactory.getHashFromFilm(f))) {
                        ++countDouble;
                        f.setDoubleUrl(true);
                    }
                });
                P2Duration.counterStop("mark(FilmData filmData)");
            }
            catch (Exception ex) {
                P2Log.errorLog(951024789, ex);
            }
        } else {
            P2Duration.counterStart("mark(FilmData filmData)");
            filmList.forEach(f -> FilmToolsFactory.mark(f));
            for (String sender : senderArr) {
                FilmToolsFactory.addSender(filmList, urlHashSet, senderArr, sender);
            }
            FilmToolsFactory.addSender(filmList, urlHashSet, senderArr, "");
            P2Duration.counterStop("mark(FilmData filmData)");
        }
        urlHashSet.clear();
        if (ProgConfig.SYSTEM_FILMLIST_REMOVE_DOUBLE.getValue().booleanValue()) {
            P2Duration.counterStart("filmlist-remove-double");
            filmList.removeIf(FilmDataProps::isDoubleUrl);
            P2Duration.counterStop("filmlist-remove-double");
        }
        P2Duration.counterStop("markFilms");
        ProgConfig.SYSTEM_FILMLIST_COUNT_DOUBLE.setValue(countDouble);
        return countDouble;
    }

    private static String getHashFromFilm(FilmData filmData) {
        if (ProgConfig.SYSTEM_FILMLIST_DOUBLE_WITH_THEME_TITLE.get()) {
            return filmData.getTheme() + filmData.getTitle() + filmData.getUrl();
        }
        return filmData.getUrl();
    }

    private static void mark(FilmData filmData) {
        filmData.setGeoBlocked();
        filmData.setInFuture();
        filmData.setShown(ProgData.getInstance().historyList.checkIfUrlAlreadyIn(filmData.getUrlHistory()));
        if (ProgConfig.SYSTEM_FILMLIST_MARK_UT.getValue().booleanValue()) {
            ProgData.getInstance().utDataList.forEach(utData -> {
                if ((utData.getChannel().isEmpty() || filmData.getChannel().contains(utData.getChannel())) && filmData.getTitle().contains(utData.getTitle())) {
                    filmData.setUt(true);
                }
            });
        }
        if (ProgConfig.SYSTEM_FILMLIST_MARK.getValue().booleanValue()) {
            ProgData.getInstance().markDataList.forEach(utData -> {
                if ((utData.getChannel().isEmpty() || filmData.getChannel().contains(utData.getChannel())) && filmData.getTitle().contains(utData.getTitle())) {
                    filmData.setMark(true);
                }
            });
        }
    }

    private static void addSender(ListProperty<? extends FilmData> filmList, HashSet<String> urlHashSet, String[] senderArr, String sender) {
        filmList.forEach(f -> {
            if (sender.isEmpty()) {
                if (Arrays.stream(senderArr).noneMatch(s -> s.equals(f.arr[1])) && !urlHashSet.add(FilmToolsFactory.getHashFromFilm(f))) {
                    ++countDouble;
                    f.setDoubleUrl(true);
                }
            } else if (f.arr[1].equals(sender) && !urlHashSet.add(FilmToolsFactory.getHashFromFilm(f))) {
                ++countDouble;
                f.setDoubleUrl(true);
            }
        });
    }
}

