/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.controller.film;

import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.data.download.DownloadData;
import de.p2tools.mtplayer.controller.data.setdata.SetData;
import de.p2tools.mtplayer.controller.film.FilmDataMTP;
import de.p2tools.mtplayer.gui.dialog.NoSetDialogController;
import de.p2tools.mtplayer.gui.dialog.downloadadd.DownloadAddDialogController;
import de.p2tools.p2lib.P2LibConst;
import de.p2tools.p2lib.alert.P2Alert;
import java.util.ArrayList;
import java.util.List;

public class FilmSaveFactory {
    private FilmSaveFactory() {
    }

    public static void saveFilm(FilmDataMTP film) {
        ArrayList<FilmDataMTP> list = new ArrayList<FilmDataMTP>();
        list.add(film);
        FilmSaveFactory.saveFilmList(list, null);
    }

    public static void saveFilmList() {
        FilmSaveFactory.saveFilmList(ProgData.getInstance().filmGuiController.getSelList(true), null);
    }

    public static void saveFilmList(List<FilmDataMTP> list, SetData setData) {
        if (list.isEmpty()) {
            return;
        }
        ProgData progData = ProgData.getInstance();
        ArrayList<FilmDataMTP> filmsAddDownloadList = new ArrayList<FilmDataMTP>();
        if (progData.setDataList.getSetDataListSave().isEmpty()) {
            new NoSetDialogController(progData, NoSetDialogController.TEXT.SAVE);
            return;
        }
        if (setData == null) {
            setData = (SetData)progData.setDataList.getSetDataListSave().get(0);
        }
        String resolution = "";
        if (progData.filterWorker.getActFilterSettings().isOnlyHd()) {
            resolution = "hd";
        }
        for (FilmDataMTP film : list) {
            DownloadData download = progData.downloadList.getDownloadWithFilmUrl(film.arr[14]);
            if (download == null) {
                filmsAddDownloadList.add(film);
            } else if (list.size() <= 1) {
                answer = P2Alert.showAlert_yes_no("Anlegen?", "Nochmal anlegen?", "Download f\u00fcr den Film existiert bereits:" + P2LibConst.LINE_SEPARATORx2 + film.getTitle() + P2LibConst.LINE_SEPARATORx2 + "Nochmal anlegen?");
                switch (answer) {
                    case NO: {
                        return;
                    }
                    case YES: {
                        filmsAddDownloadList.add(film);
                    }
                }
            } else {
                answer = P2Alert.showAlert_yes_no_cancel("Anlegen?", "Nochmal anlegen?", "Download f\u00fcr den Film existiert bereits:" + P2LibConst.LINE_SEPARATORx2 + film.getTitle() + P2LibConst.LINE_SEPARATORx2 + "Nochmal anlegen (Ja / Nein)?" + P2LibConst.LINE_SEPARATOR + "Oder alles Abbrechen?");
                switch (answer) {
                    case CANCEL: {
                        return;
                    }
                    case NO: {
                        break;
                    }
                    case YES: {
                        filmsAddDownloadList.add(film);
                    }
                }
            }
        }
        if (!filmsAddDownloadList.isEmpty()) {
            new DownloadAddDialogController(progData, filmsAddDownloadList, setData, resolution);
        }
    }
}

