/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.controller.film;

import de.p2tools.mtplayer.controller.film.FilmDataMTP;
import de.p2tools.mtplayer.controller.film.FilmToolsFactory;
import de.p2tools.p2lib.mtfilm.film.FilmData;
import de.p2tools.p2lib.mtfilm.film.FilmDataProps;
import de.p2tools.p2lib.mtfilm.film.Filmlist;
import de.p2tools.p2lib.mtfilm.film.FilmlistFactory;
import de.p2tools.p2lib.tools.duration.P2Duration;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Optional;
import java.util.TreeSet;
import java.util.function.Predicate;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;

public class FilmListMTP
extends Filmlist<FilmDataMTP> {
    public String[][] themePerChannel = new String[][]{{""}};
    private FilteredList<FilmDataMTP> filteredList = null;
    private SortedList<FilmDataMTP> sortedList = null;

    @Override
    public FilmDataMTP getNewElement() {
        return new FilmDataMTP();
    }

    @Override
    public SortedList<FilmDataMTP> getSortedList() {
        if (this.sortedList == null || this.filteredList == null) {
            this.filteredList = new FilteredList<FilmDataMTP>(this, p -> true);
            this.sortedList = new SortedList<FilmDataMTP>((ObservableList<FilmDataMTP>)this.filteredList);
        }
        return this.sortedList;
    }

    @Override
    public FilteredList<FilmDataMTP> getFilteredList() {
        if (this.sortedList == null || this.filteredList == null) {
            this.filteredList = new FilteredList<FilmDataMTP>(this, p -> true);
            this.sortedList = new SortedList<FilmDataMTP>((ObservableList<FilmDataMTP>)this.filteredList);
        }
        return this.filteredList;
    }

    @Override
    public synchronized void filteredListSetPred(Predicate<FilmData> predicate) {
        this.getFilteredList().setPredicate(predicate);
    }

    @Override
    public synchronized int markFilms() {
        return FilmToolsFactory.markFilms(this);
    }

    @Override
    public synchronized void clear() {
        this.nr = 1;
        super.clear();
    }

    @Override
    public synchronized void sort() {
        Collections.sort(this);
        int i = 1;
        for (FilmData film : this) {
            film.no = i++;
        }
    }

    public synchronized void setMeta(FilmListMTP filmlist) {
        System.arraycopy(filmlist.metaData, 0, this.metaData, 0, 5);
    }

    @Override
    public synchronized FilmDataMTP getFilmByUrl(String url) {
        Optional<FilmDataMTP> opt = this.parallelStream().filter(f -> f.arr[14].equalsIgnoreCase(url)).findAny();
        return opt.orElse(null);
    }

    @Override
    public synchronized void getTheme(String sender, LinkedList<String> list) {
        this.stream().filter(film -> film.arr[1].equals(sender)).filter(film -> !list.contains(film.arr[2])).forEach(film -> list.add(film.arr[2]));
    }

    @Override
    public synchronized FilmDataMTP getFilmByUrl_small_high_hd(String url) {
        return this.parallelStream().filter(f -> f.arr[14].equals(url) || f.getUrlForResolution("hd").equals(url) || f.getUrlForResolution("small").equals(url)).findFirst().orElse(null);
    }

    @Override
    public synchronized String genDate() {
        return FilmlistFactory.genDate(this.metaData);
    }

    @Override
    public int getAge() {
        return FilmlistFactory.getAge(this.metaData);
    }

    public Date getAgeAsDate() {
        return FilmlistFactory.getAgeAsDate(this.metaData);
    }

    @Override
    public synchronized boolean isTooOldOrEmpty() {
        return FilmlistFactory.isTooOldOrEmpty(this, this.metaData);
    }

    @Override
    public synchronized boolean isTooOldForDiffOrEmpty() {
        return FilmlistFactory.isTooOldForDiffOrEmpty(this, this.metaData);
    }

    @Override
    public boolean isOlderThan(int second) {
        return FilmlistFactory.isOlderThan(this.metaData, second);
    }

    @Override
    public synchronized long countNewFilms() {
        return this.stream().filter(FilmDataProps::isNewFilm).count();
    }

    public synchronized void loadTheme() {
        P2Duration.counterStart("loadTheme");
        LinkedHashSet<String> senderSet = new LinkedHashSet<String>(21);
        senderSet.add("");
        this.forEach(film -> senderSet.add(film.getChannel()));
        this.sender = senderSet.toArray(new String[0]);
        int senderLength = this.sender.length;
        this.themePerChannel = new String[senderLength][];
        TreeSet[] tree = new TreeSet[senderLength];
        HashSet[] hashSet = new HashSet[senderLength];
        for (int i = 0; i < tree.length; ++i) {
            tree[i] = new TreeSet(String.CASE_INSENSITIVE_ORDER);
            tree[i].add("");
            hashSet[i] = new HashSet();
        }
        for (FilmData film2 : this) {
            String filmChannel = film2.arr[1];
            String filmTheme = film2.arr[2];
            if (!hashSet[0].contains(filmTheme)) {
                hashSet[0].add(filmTheme);
                tree[0].add(filmTheme);
            }
            for (int i = 1; i < senderLength; ++i) {
                if (!filmChannel.equals(this.sender[i]) || hashSet[i].contains(filmTheme)) continue;
                hashSet[i].add(filmTheme);
                tree[i].add(filmTheme);
            }
        }
        for (int i = 0; i < this.themePerChannel.length; ++i) {
            this.themePerChannel[i] = tree[i].toArray(new String[0]);
            tree[i].clear();
            hashSet[i].clear();
        }
        P2Duration.counterStop("loadTheme");
    }
}

