/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.controller.data.setdata;

import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.data.setdata.ProgramData;
import de.p2tools.mtplayer.controller.data.setdata.SetData;
import de.p2tools.mtplayer.gui.dialog.CheckSetDialogController;
import de.p2tools.p2lib.P2LibConst;
import de.p2tools.p2lib.alert.P2Alert;
import de.p2tools.p2lib.tools.P2InfoFactory;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Iterator;
import javafx.stage.Stage;

public class SetFactory {
    private static final ArrayList<String> winPath = new ArrayList();

    public static String getTemplatePathVlc() {
        String PATH_LINUX_VLC = "/usr/bin/vlc";
        String PATH_FREEBSD = "/usr/local/bin/vlc";
        String PATH_WIN = "\\VideoLAN\\VLC\\vlc.exe";
        Object path = "";
        try {
            switch (P2InfoFactory.getOs()) {
                case LINUX: {
                    if (System.getProperty("os.name").toLowerCase().contains("freebsd")) {
                        path = "/usr/local/bin/vlc";
                        break;
                    }
                    path = "/usr/bin/vlc";
                    break;
                }
                default: {
                    String s;
                    SetFactory.setWinProgPathVLC();
                    Iterator<String> iterator2 = winPath.iterator();
                    while (iterator2.hasNext() && !new File((String)(path = (s = iterator2.next()) + "\\VideoLAN\\VLC\\vlc.exe")).exists()) {
                    }
                    break;
                }
            }
            if (!new File((String)path).exists() && System.getenv("PATH_VLC") != null) {
                path = System.getenv("PATH_VLC");
            }
            if (!new File((String)path).exists()) {
                path = "";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return path;
    }

    public static String getTemplatePathFFmpeg() {
        String PATH_LINUX_FFMPEG = "/usr/bin/ffmpeg";
        String PATH_FREEBSD_FFMPEG = "/usr/local/bin/ffmpeg";
        String PATH_WINDOWS_FFMPEG = "bin\\ffmpeg.exe";
        String path = "";
        try {
            switch (P2InfoFactory.getOs()) {
                case LINUX: {
                    if (System.getProperty("os.name").toLowerCase().contains("freebsd")) {
                        path = "/usr/local/bin/ffmpeg";
                        break;
                    }
                    path = "/usr/bin/ffmpeg";
                    break;
                }
                default: {
                    path = "bin\\ffmpeg.exe";
                }
            }
            if (!new File(path).exists() && System.getenv("PATH_FFMPEG") != null) {
                path = System.getenv("PATH_FFMPEG");
            }
            if (!new File(path).exists()) {
                path = "";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return path;
    }

    private static void setWinProgPathVLC() {
        String[] PATH;
        String pfad;
        if (System.getenv("ProgramFiles") != null && new File(pfad = System.getenv("ProgramFiles")).exists() && !winPath.contains(pfad)) {
            winPath.add(pfad);
        }
        if (System.getenv("ProgramFiles(x86)") != null && new File(pfad = System.getenv("ProgramFiles(x86)")).exists() && !winPath.contains(pfad)) {
            winPath.add(pfad);
        }
        for (String s : PATH = new String[]{"C:\\Program Files", "C:\\Programme", "C:\\Program Files (x86)"}) {
            if (!new File(s).exists() || winPath.contains(s)) continue;
            winPath.add(s);
        }
    }

    public static boolean testPrefix(String str, String uurl, boolean prefix) {
        boolean ret = false;
        String url = uurl.toLowerCase();
        Object s1 = "";
        if (str.isEmpty()) {
            ret = true;
        } else {
            for (int i = 0; i < str.length(); ++i) {
                if (str.charAt(i) != ',') {
                    s1 = (String)s1 + str.charAt(i);
                }
                if (str.charAt(i) != ',' && i < str.length() - 1) continue;
                if (prefix) {
                    if (url.startsWith(((String)s1).toLowerCase())) {
                        ret = true;
                        break;
                    }
                } else if (url.endsWith(((String)s1).toLowerCase())) {
                    ret = true;
                    break;
                }
                s1 = "";
            }
        }
        return ret;
    }

    public static boolean checkPathWritable(String path) {
        boolean ret = false;
        File testPath = new File(path);
        try {
            if (!testPath.exists()) {
                testPath.mkdirs();
            }
            if (!path.isEmpty() && testPath.isDirectory() && testPath.canWrite()) {
                File tmpFile = File.createTempFile("mtplayer", "tmp", testPath);
                tmpFile.delete();
                ret = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    public static void checkPrograms(Stage stage, ProgData data, boolean showWhenOk) {
        if (data.setDataList.isEmpty()) {
            P2Alert.showErrorAlert(stage, "Set", "Sets pr\u00fcfen", "Es sind keine Sets vorhanden! Bitte die Standardsets importieren.");
            return;
        }
        String PIPE = "| ";
        String LEER = "      ";
        String PFEIL = " -> ";
        boolean show = showWhenOk;
        StringBuilder text = new StringBuilder();
        for (SetData setData : data.setDataList) {
            boolean ret = true;
            if (setData.isFreeLine() || setData.isLable()) continue;
            text.append("+++++++++++++++++++++++++++++++").append(P2LibConst.LINE_SEPARATOR);
            text.append("| Programmgruppe: ").append(setData.getVisibleName()).append(P2LibConst.LINE_SEPARATOR);
            String destPath = setData.getDestPath();
            if (setData.progsContainPath()) {
                if (destPath.isEmpty()) {
                    ret = false;
                    text.append("|       Zielpfad fehlt!").append(P2LibConst.LINE_SEPARATOR);
                } else if (!SetFactory.checkPathWritable(destPath)) {
                    ret = false;
                    text.append("|       Falscher Zielpfad!").append(P2LibConst.LINE_SEPARATOR);
                    text.append("|        -> Zielpfad \"").append(destPath).append("\" nicht beschreibbar!").append(P2LibConst.LINE_SEPARATOR);
                }
            }
            for (ProgramData progData : setData.getProgramList()) {
                Process process;
                if (progData.getProgPath().isEmpty()) {
                    ret = false;
                    text.append("|       Kein Programm angegeben!").append(P2LibConst.LINE_SEPARATOR);
                    text.append("|        -> Programmname: ").append(progData.getName()).append(P2LibConst.LINE_SEPARATOR);
                    text.append("|             Pfad: ").append(progData.getProgPath()).append(P2LibConst.LINE_SEPARATOR);
                    continue;
                }
                Path path = Paths.get(progData.getProgPath(), new String[0]);
                if (!Files.exists(path, new LinkOption[0])) {
                    if (progData.getProgPath().contains(File.separator)) {
                        ret = false;
                        text.append("|       Falscher Programmpfad!").append(P2LibConst.LINE_SEPARATOR);
                        text.append("|        -> Programmname: ").append(progData.getName()).append(P2LibConst.LINE_SEPARATOR);
                        text.append("|             Pfad: ").append(progData.getProgPath()).append(P2LibConst.LINE_SEPARATOR);
                        continue;
                    }
                    if (Files.isExecutable(path)) continue;
                    process = null;
                    try {
                        process = Runtime.getRuntime().exec(progData.getProgPath());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (process != null) {
                        try {
                            process.destroy();
                        }
                        catch (Exception exception) {}
                        continue;
                    }
                    ret = false;
                    text.append("|       Falscher Programmpfad!").append(P2LibConst.LINE_SEPARATOR);
                    text.append("|        -> Programmname: ").append(progData.getName()).append(P2LibConst.LINE_SEPARATOR);
                    text.append("|             Pfad: ").append(progData.getProgPath()).append(P2LibConst.LINE_SEPARATOR);
                    text.append("| Das Programm braucht einen Pfad").append(P2LibConst.LINE_SEPARATOR);
                    text.append("| oder muss im Systempfad liegen,").append(P2LibConst.LINE_SEPARATOR);
                    text.append("| damit der Start klappt!").append(P2LibConst.LINE_SEPARATOR);
                    continue;
                }
                if (Files.isExecutable(path)) continue;
                process = null;
                try {
                    process = Runtime.getRuntime().exec(progData.getProgPath());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (process != null) {
                    try {
                        process.destroy();
                    }
                    catch (Exception exception) {}
                    continue;
                }
                ret = false;
                text.append("|       Programm kann nicht gestartet werden").append(P2LibConst.LINE_SEPARATOR);
                text.append("|        -> Programmname: ").append(progData.getName()).append(P2LibConst.LINE_SEPARATOR);
                text.append("|             Pfad: ").append(progData.getProgPath()).append(P2LibConst.LINE_SEPARATOR);
            }
            if (ret) {
                text.append("|  -> Ok!").append(P2LibConst.LINE_SEPARATOR);
            } else {
                show = true;
            }
            text.append("+++++++++++++++++++++++++++++++").append(P2LibConst.LINE_SEPARATORx3);
        }
        if (show) {
            new CheckSetDialogController(text.toString());
        }
    }
}

