/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.controller.data.setdata;

import de.p2tools.mtplayer.controller.data.setdata.SetData;
import de.p2tools.p2lib.configfile.pdata.P2DataList;
import java.util.Collection;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;

public class SetDataListWorker
extends SimpleListProperty<SetData>
implements P2DataList<SetData> {
    public static final String TAG = "SetDataList";
    private BooleanProperty listChanged = new SimpleBooleanProperty(true);
    private final ObservableList<SetData> undoList = FXCollections.observableArrayList();

    public SetDataListWorker() {
        super(FXCollections.observableArrayList());
    }

    @Override
    public String getTag() {
        return TAG;
    }

    @Override
    public String getComment() {
        return "Liste aller SetData";
    }

    @Override
    public SetData getNewItem() {
        return new SetData();
    }

    @Override
    public void addNewItem(Object obj) {
        if (obj.getClass().equals(SetData.class)) {
            this.add((SetData)obj);
        }
    }

    public boolean isListChanged() {
        return this.listChanged.get();
    }

    public BooleanProperty listChangedProperty() {
        return this.listChanged;
    }

    public void setListChanged() {
        this.listChanged.set(!this.listChanged.get());
    }

    @Override
    public boolean add(SetData setData) {
        this.checkSetDataName(setData);
        return super.add(setData);
    }

    @Override
    public boolean addAll(Collection<? extends SetData> elements) {
        elements.stream().forEach(sd -> this.checkSetDataName((SetData)sd));
        return super.addAll(elements);
    }

    @Override
    public boolean addAll(int i, Collection<? extends SetData> elements) {
        elements.stream().forEach(sd -> this.checkSetDataName((SetData)sd));
        return super.addAll(i, elements);
    }

    void checkSetDataName(SetData setData) {
        Object setDataId = setData.getId();
        boolean found = false;
        int id = 0;
        block0: do {
            for (SetData sd : this) {
                if (sd.getId().equals(setDataId)) {
                    found = true;
                    setDataId = setData.getId() + "-" + ++id;
                    continue block0;
                }
                found = false;
            }
        } while (found);
        setData.setId((String)setDataId);
        if (setData.getVisibleName().isEmpty()) {
            setData.setVisibleName(setData.getId());
        }
    }

    public ObservableList<SetData> getUndoList() {
        return this.undoList;
    }

    public synchronized void addDataToUndoList(SetData setData) {
        this.undoList.clear();
        this.undoList.addAll((SetData[])new SetData[]{setData});
    }

    public synchronized void addDataToUndoList(List<SetData> list) {
        this.undoList.clear();
        this.undoList.addAll((Collection<SetData>)list);
    }

    public synchronized void undoData() {
        if (this.undoList.isEmpty()) {
            return;
        }
        this.addAll((Collection<? extends SetData>)this.undoList);
        this.undoList.clear();
    }
}

