/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.controller.data.download;

import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.data.download.DownloadData;
import de.p2tools.mtplayer.controller.data.download.DownloadFactory;
import de.p2tools.mtplayer.controller.data.download.DownloadFactoryStartDownload;
import de.p2tools.mtplayer.controller.data.download.DownloadFactoryStarts;
import de.p2tools.mtplayer.controller.data.download.DownloadFactoryStopDownload;
import de.p2tools.mtplayer.controller.data.setdata.SetData;
import de.p2tools.p2lib.configfile.pdata.P2DataList;
import de.p2tools.p2lib.tools.P2GetList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;

public class DownloadList
extends SimpleListProperty<DownloadData>
implements P2DataList<DownloadData> {
    public static final String TAG = "DownloadList";
    private final ProgData progData;
    private final ObservableList<DownloadData> undoList = FXCollections.observableArrayList();
    private final BooleanProperty downloadsChanged = new SimpleBooleanProperty(true);

    public DownloadList(ProgData progData) {
        super(FXCollections.observableArrayList());
        this.progData = progData;
    }

    @Override
    public String getTag() {
        return TAG;
    }

    @Override
    public String getComment() {
        return "Liste aller Downloads";
    }

    @Override
    public DownloadData getNewItem() {
        return new DownloadData();
    }

    @Override
    public void addNewItem(Object obj) {
        if (obj.getClass().equals(DownloadData.class)) {
            DownloadData d = (DownloadData)obj;
            d.setPlacedBack(false);
            this.add(d);
        }
    }

    public synchronized void initDownloads() {
        this.forEach(download -> {
            download.setFile(download.getDestPathFile());
            SetData setData = this.progData.setDataList.getSetDataForDownloads(download.getSetDataId());
            if (setData != null) {
                download.setSetData(setData, false);
            }
        });
    }

    public void sort() {
        Collections.sort(this);
    }

    public synchronized void addWithNo(List<DownloadData> list) {
        super.addAll(list);
        this.setNumbersInList();
    }

    public boolean getDownloadsChanged() {
        return this.downloadsChanged.get();
    }

    public synchronized void setDownloadsChanged() {
        this.downloadsChanged.set(!this.downloadsChanged.get());
    }

    public BooleanProperty downloadsChangedProperty() {
        return this.downloadsChanged;
    }

    public ObservableList<DownloadData> getUndoList() {
        return this.undoList;
    }

    public synchronized void addDownloadsToUndoList(List<DownloadData> list) {
        this.undoList.clear();
        this.undoList.addAll((Collection<DownloadData>)list);
    }

    public synchronized void undoDownloads() {
        if (this.undoList.isEmpty()) {
            return;
        }
        this.progData.historyListAbos.removeDownloadDataFromHistory(this.undoList);
        this.addAll(this.undoList);
        this.undoList.clear();
    }

    public synchronized int countStartedAndRunningDownloads() {
        int ret = 0;
        for (DownloadData download : this) {
            if (!download.isStateStartedWaiting() && !download.isStateStartedRun()) continue;
            ++ret;
        }
        return ret;
    }

    public synchronized int countRunningDownloads() {
        int count = 0;
        for (DownloadData download : this) {
            if (!download.isStateStartedRun()) continue;
            ++count;
        }
        return count;
    }

    public synchronized void preferDownloads(ArrayList<DownloadData> prefDownList) {
        DownloadFactory.preferDownloads(this, prefDownList);
    }

    public synchronized DownloadData getDownloadWithFilmUrl(String urlFilm) {
        for (DownloadData dataDownload : this) {
            if (!dataDownload.getFilmUrlNormal().equals(urlFilm)) continue;
            return dataDownload;
        }
        return null;
    }

    public synchronized List<DownloadData> getListOfStartsNotFinished(String source2) {
        return DownloadFactoryStarts.getListOfStartsNotFinished(this, source2);
    }

    public synchronized List<DownloadData> getListOfStartsNotLoading(String source2) {
        return DownloadFactoryStarts.getListOfStartsNotLoading(this, source2);
    }

    public synchronized void cleanUpButtonStarts() {
        DownloadFactoryStarts.cleanUpButtonStarts(this);
    }

    public synchronized void resetPlacedBack() {
        this.forEach(d -> d.setPlacedBack(false));
    }

    public DownloadList getCopyForSaving() {
        DownloadList dl = new DownloadList(this.progData);
        dl.addAll(this);
        dl.removeIf(download -> !download.isStateStopped() && (download.isAbo() || download.isStateFinished()));
        return dl;
    }

    public synchronized void stopDownloads(List<DownloadData> list) {
        if (DownloadFactoryStopDownload.stopDownloads(list)) {
            this.setDownloadsChanged();
        }
    }

    public synchronized void delDownloads(DownloadData download) {
        DownloadFactoryStopDownload.delDownloads(this, new P2GetList<DownloadData>().getArrayList(download));
    }

    public synchronized void delDownloads(ArrayList<DownloadData> list) {
        if (DownloadFactoryStopDownload.delDownloads(this, list)) {
            this.setDownloadsChanged();
        }
    }

    public synchronized void putBackDownloads(ArrayList<DownloadData> list) {
        if (DownloadFactoryStopDownload.putBackDownloads(list)) {
            this.setDownloadsChanged();
        }
    }

    public synchronized void startAllDownloads() {
        this.startDownloads(this, false);
    }

    public synchronized void startDownloads(DownloadData download) {
        DownloadFactoryStartDownload.startDownloads(this, new P2GetList<DownloadData>().getArrayList(download));
        this.setDownloadsChanged();
    }

    public synchronized void startDownloads(Collection<DownloadData> list, boolean alsoFinished) {
        if (DownloadFactoryStartDownload.startDownloads(this, list, alsoFinished)) {
            this.setDownloadsChanged();
        }
    }

    public synchronized void setNumbersInList() {
        int i = this.getNextNumber();
        for (DownloadData download : this) {
            if (download.isStarted()) {
                if (download.getNo() != Integer.MAX_VALUE) continue;
                download.setNo(i++);
                continue;
            }
            download.setNo(Integer.MAX_VALUE);
        }
    }

    public synchronized void renumberList(int addNr) {
        for (DownloadData download : this) {
            int i = download.getNo();
            if (i >= Integer.MAX_VALUE) continue;
            download.setNo(i + addNr);
        }
    }

    private int getNextNumber() {
        int i = 1;
        for (DownloadData download : this) {
            if (download.getNo() >= Integer.MAX_VALUE || download.getNo() < i) continue;
            i = download.getNo() + 1;
        }
        return i;
    }

    public synchronized void addNumber(ArrayList<DownloadData> downloads) {
        int i = this.getNextNumber();
        for (DownloadData download : downloads) {
            download.setNo(i++);
        }
    }
}

