/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.controller.data.download;

import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.data.download.DownloadData;
import de.p2tools.mtplayer.controller.data.download.DownloadList;
import de.p2tools.p2lib.tools.log.P2Log;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class DownloadFactoryStarts {
    private static String lastLogMsg = "";

    private DownloadFactoryStarts() {
    }

    static synchronized List<DownloadData> getListOfStartsNotFinished(DownloadList downloadList, String source2) {
        ArrayList<DownloadData> activeDownloadData = new ArrayList<DownloadData>();
        activeDownloadData.addAll(downloadList.stream().filter(DownloadData::isStateStartedRun).filter(download -> source2.equals("") || download.getSource().equals(source2)).collect(Collectors.toList()));
        return activeDownloadData;
    }

    static synchronized List<DownloadData> getListOfStartsNotLoading(DownloadList downloadList, String source2) {
        ArrayList<DownloadData> activeDownloadData = new ArrayList<DownloadData>();
        activeDownloadData.addAll(downloadList.stream().filter(DownloadData::isStateStartedWaiting).filter(download -> source2.equals("") || download.getSource().equals(source2)).collect(Collectors.toList()));
        return activeDownloadData;
    }

    public static synchronized void cleanUpButtonStarts(DownloadList downloadList) {
        Iterator it = downloadList.iterator();
        while (it.hasNext()) {
            DownloadData d = (DownloadData)it.next();
            if (!d.isStateFinished() || !d.getSource().equals("Button")) continue;
            it.remove();
        }
    }

    public static synchronized DownloadData getNextStart(DownloadList downloadList) {
        DownloadData download;
        DownloadData ret = null;
        if (!downloadList.isEmpty() && DownloadFactoryStarts.getDown(downloadList, ProgConfig.DOWNLOAD_MAX_DOWNLOADS.getValue()) && (download = DownloadFactoryStarts.nextStart(downloadList)) != null && download.isStateStartedWaiting()) {
            ret = download;
        }
        return ret;
    }

    private static DownloadData nextStart(DownloadList downloadList) {
        DownloadData tmpDownload = null;
        int nr = -1;
        DownloadData d = downloadList.stream().filter(DownloadData::isStateStartedWaiting).findAny().orElse(null);
        if (d == null) {
            DownloadFactoryStarts.logMsg("Download zum Start suchen: Keiner mit stateStartedWaiting");
        }
        for (DownloadData download : downloadList) {
            if (!download.isStateStartedWaiting() || !DownloadFactoryStarts.checkStartTime(download) || nr != -1 && download.getNo() >= nr) continue;
            tmpDownload = download;
            nr = tmpDownload.getNo();
        }
        return tmpDownload;
    }

    private static boolean checkStartTime(DownloadData download) {
        if (ProgData.autoMode) {
            return true;
        }
        if (download.getStartTime().isEmpty()) {
            return true;
        }
        try {
            LocalDateTime lNow = LocalDateTime.now();
            LocalDateTime lDownload = download.getStartTimeLdt();
            if (lNow.isAfter(lDownload)) {
                return true;
            }
            DownloadFactoryStarts.logMsg("Download zum Start suchen: Startzeit nicht erreicht");
            return false;
        }
        catch (Exception ex) {
            P2Log.errorLog(945123690, "Download-StartTime: " + download.getStartTime());
            return true;
        }
    }

    private static boolean getDown(DownloadList downloadList, int max) {
        try {
            int count = downloadList.countRunningDownloads();
            if (count >= max) {
                DownloadFactoryStarts.logMsg("Download zum Start suchen: Es laufen: " + count + " - Max: " + max);
                return false;
            }
            return true;
        }
        catch (Exception ex) {
            P2Log.errorLog(794519083, ex);
            return false;
        }
    }

    private static void logMsg(String log) {
        if (!lastLogMsg.equals(log)) {
            lastLogMsg = log;
            P2Log.sysLog(new String[]{"------------------------------------------------------------", lastLogMsg, "------------------------------------------------------------"});
        }
    }
}

