/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.controller.data.download;

import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.data.download.DownloadData;
import de.p2tools.mtplayer.controller.data.download.DownloadFactoryStopDownload;
import de.p2tools.mtplayer.controller.data.download.DownloadList;
import de.p2tools.mtplayer.gui.dialog.NoSetDialogController;
import de.p2tools.p2lib.alert.P2Alert;
import de.p2tools.p2lib.tools.duration.P2Duration;
import java.util.ArrayList;
import java.util.Collection;
import javafx.application.Platform;

public class DownloadFactoryStartDownload {
    private DownloadFactoryStartDownload() {
    }

    public static void startDownloads(DownloadList downloadList, ArrayList<DownloadData> downloads) {
        if (ProgData.getInstance().setDataList.getSetDataListSave().isEmpty()) {
            Platform.runLater(() -> new NoSetDialogController(ProgData.getInstance(), NoSetDialogController.TEXT.SAVE));
            return;
        }
        if (downloads.isEmpty()) {
            return;
        }
        downloads.forEach(DownloadData::initStartDownload);
        downloadList.addNumber(downloads);
        ProgData.getInstance().historyList.addDownloadDataListToHistory(downloads);
    }

    public static boolean startDownloads(DownloadList downloadList, Collection<DownloadData> list, boolean alsoFinished) {
        if (ProgData.getInstance().setDataList.getSetDataListSave().isEmpty()) {
            Platform.runLater(() -> new NoSetDialogController(ProgData.getInstance(), NoSetDialogController.TEXT.SAVE));
            return false;
        }
        if (list == null || list.isEmpty()) {
            return false;
        }
        P2Duration.counterStart("startDownloads");
        ArrayList<DownloadData> listStartDownloads = new ArrayList<DownloadData>();
        ProgData.getInstance().startDownload.setPaused();
        list.stream().filter(DownloadData::isStateInit).forEach(listStartDownloads::add);
        if (alsoFinished && !DownloadFactoryStartDownload.startAlsoFinishedDownloads(list, listStartDownloads)) {
            return false;
        }
        DownloadFactoryStartDownload.startDownloads(downloadList, listStartDownloads);
        P2Duration.counterStop("startDownloads");
        return true;
    }

    private static boolean startAlsoFinishedDownloads(Collection<DownloadData> list, Collection<DownloadData> listStartDownloads) {
        P2Alert.BUTTON answer = P2Alert.BUTTON.UNKNOWN;
        ArrayList<DownloadData> listDelDownloads = new ArrayList<DownloadData>();
        ArrayList<DownloadData> listDownloadsRemoveAboHistory = new ArrayList<DownloadData>();
        block4: for (DownloadData download2 : list) {
            if (download2.isStateStopped()) {
                listDelDownloads.add(download2);
                if (download2.isAbo()) {
                    listDownloadsRemoveAboHistory.add(download2);
                }
                listStartDownloads.add(download2);
            }
            if (!download2.isStateError()) continue;
            if (answer.equals((Object)P2Alert.BUTTON.UNKNOWN)) {
                answer = DownloadFactoryStopDownload.restartDownload(list.size(), download2.getTitle(), answer);
            }
            switch (answer) {
                case CANCEL: {
                    continue block4;
                }
                case NO: {
                    continue block4;
                }
            }
            listDelDownloads.add(download2);
            if (download2.isAbo()) {
                listDownloadsRemoveAboHistory.add(download2);
            }
            listStartDownloads.add(download2);
        }
        if (answer.equals((Object)P2Alert.BUTTON.CANCEL)) {
            return false;
        }
        ProgData.getInstance().historyListAbos.removeDownloadDataFromHistory(listDownloadsRemoveAboHistory);
        listDelDownloads.forEach(download -> download.stopDownload(false));
        return true;
    }
}

