/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.controller.data.download;

import de.p2tools.mtplayer.controller.data.abo.AboData;
import de.p2tools.mtplayer.controller.data.download.DownloadData;
import de.p2tools.mtplayer.controller.data.download.DownloadFactory;
import de.p2tools.mtplayer.controller.data.setdata.ProgramData;
import de.p2tools.mtplayer.controller.data.setdata.SetData;
import de.p2tools.mtplayer.gui.configdialog.panesetdata.AboSubDir;
import de.p2tools.p2lib.mtfilm.tools.FileNameUtils;
import de.p2tools.p2lib.tools.P2InfoFactory;
import de.p2tools.p2lib.tools.date.P2DateConst;
import de.p2tools.p2lib.tools.file.P2FileUtils;
import de.p2tools.p2lib.tools.log.P2Log;
import de.p2tools.p2lib.tools.net.PUrlTools;
import java.io.File;
import java.nio.file.Paths;
import java.util.Date;

public class DownloadFactoryMakeParameter {
    private DownloadFactoryMakeParameter() {
    }

    public static boolean makeProgParameter(DownloadData download, AboData abo, String name, String path) {
        try {
            ProgramData programData = download.getSetData().getProgUrl(download.getUrl());
            if (programData == null) {
                return false;
            }
            download.setType(download.getSetData().checkDownloadDirect(download.getUrl()) && download.getSetData().progsContainPath() ? "direkter Download" : "Programm");
            if (download.getType().equals("direkter Download")) {
                download.setProgramName("direkter Download");
            } else {
                download.setProgramName(programData.getName());
            }
            download.setProgramDownloadmanager(programData.isDownManager());
            DownloadFactoryMakeParameter.buildFileNamePath(download, download.getSetData(), abo, name, path);
            DownloadFactoryMakeParameter.buildProgParameter(download, programData);
        }
        catch (Exception ex) {
            P2Log.errorLog(825600145, ex);
        }
        return true;
    }

    private static void buildProgParameter(DownloadData download, ProgramData program) {
        if (download.getType().equals("direkter Download")) {
            download.setProgramCall("");
            download.setProgramCallArray("");
        } else {
            String befehlsString = program.getProgrammAufruf();
            befehlsString = DownloadFactoryMakeParameter.buildUrl(download, befehlsString);
            befehlsString = DownloadFactoryMakeParameter.replaceExec(download, befehlsString);
            download.setProgramCall(befehlsString);
            String progArray = program.getProgrammAufrufArray();
            progArray = DownloadFactoryMakeParameter.buildUrl(download, progArray);
            progArray = DownloadFactoryMakeParameter.replaceExec(download, progArray);
            download.setProgramCallArray(progArray);
        }
    }

    private static void buildFileNamePath(DownloadData download, SetData setData, AboData abo, String selName, String selPath) {
        Object name = DownloadFactoryMakeParameter.buildFileName(download, setData, abo, selName);
        String path = DownloadFactoryMakeParameter.buildFilePath(download, setData, abo, selPath);
        if (path.isEmpty()) {
            path = P2InfoFactory.getStandardDownloadPath();
        }
        if (((String)name).isEmpty()) {
            name = DownloadFactoryMakeParameter.getToday_yyyyMMdd() + "_" + download.getTheme() + "-" + download.getTitle() + ".mp4";
        }
        String[] pathName = new String[]{path, name};
        P2FileUtils.checkLengthPath(pathName);
        download.setFile(Paths.get(path, new String[]{name}).toFile());
    }

    private static String buildFileName(DownloadData download, SetData setData, AboData abo, String selName) {
        Object name;
        if (!selName.isEmpty()) {
            name = selName;
        } else {
            name = abo != null && !abo.getAboFileName().isEmpty() ? abo.getAboFileName() : setData.getDestFileName(download.getUrl());
            if (((String)name).isEmpty()) {
                name = DownloadFactoryMakeParameter.getToday_yyyyMMdd() + "_" + download.getTheme() + "-" + download.getTitle() + ".mp4";
            }
            name = DownloadFactoryMakeParameter.replaceTags(download, (String)name, false);
            String suff = "";
            if (((String)name).contains(".")) {
                suff = ((String)name).substring(((String)name).lastIndexOf("."));
                if (suff.length() <= 4 && suff.length() > 1) {
                    name = ((String)name).substring(0, ((String)name).lastIndexOf("."));
                } else {
                    suff = "";
                }
            }
            name = DownloadFactory.replaceFileNameWithReplaceList((String)name, false);
            if (((String)(name = (String)name + suff)).length() > 8) {
                String suf1 = ((String)name).substring(((String)name).length() - 8, ((String)name).length() - 4);
                String suf2 = ((String)name).substring(((String)name).length() - 4);
                if (suf1.startsWith(".") && suf2.startsWith(".") && suf1.equalsIgnoreCase(suf2)) {
                    name = ((String)name).substring(0, ((String)name).length() - 4);
                }
            }
            if (setData.getMaxSize() > 0) {
                int length = setData.getMaxSize();
                name = P2FileUtils.cutName((String)name, length);
            }
        }
        return name;
    }

    private static String buildFilePath(DownloadData download, SetData setData, AboData abo, String selPath) {
        String path;
        if (!selPath.isEmpty()) {
            path = selPath;
        } else {
            path = abo != null && !abo.getAboDir().isEmpty() ? abo.getAboDir() : (setData.getDestPath().isEmpty() ? P2InfoFactory.getStandardDownloadPath() : setData.getDestPath());
            if (abo == null && setData.isGenAboSubDir()) {
                path = P2FileUtils.addsPath(path, DownloadFactory.replaceFileNameWithReplaceList(download.getTheme(), true));
            }
            if (abo != null) {
                download.setAboName(abo.getName());
                if (abo.getAboDir().isEmpty()) {
                    String addPpath = "";
                    if (!abo.getAboSubDir().trim().isEmpty()) {
                        addPpath = abo.getAboSubDir();
                    } else if (setData.isGenAboSubDir()) {
                        AboSubDir.ENSubDir ENSubDir2 = AboSubDir.getENSubDir(setData.getAboSubDir_ENSubDirNo());
                        switch (ENSubDir2) {
                            case TITLE: {
                                addPpath = download.getTitle();
                                break;
                            }
                            case SENDER: {
                                addPpath = download.getChannel();
                                break;
                            }
                            case ABONAME: {
                                addPpath = abo.getName();
                                break;
                            }
                            case SENDEDATUM: {
                                addPpath = download.getFilmDate().get_yyyy_MM_dd();
                                break;
                            }
                            case DOWNLOADDATUM: {
                                addPpath = DownloadFactoryMakeParameter.getToday_yyyy_MM_dd();
                                break;
                            }
                            default: {
                                addPpath = download.getTheme();
                            }
                        }
                    }
                    addPpath = addPpath.trim();
                    if (!addPpath.isEmpty()) {
                        path = P2FileUtils.addsPath(path, FileNameUtils.removeIllegalCharacters(addPpath, true));
                    }
                }
            }
        }
        path = DownloadFactoryMakeParameter.replaceTags(download, path, true);
        if (path.endsWith(File.separator)) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    public static String replaceTags(DownloadData download, String replStr, boolean andReplace) {
        int length = download.getSetData().getMaxField();
        replStr = replStr.replace("%t", DownloadFactoryMakeParameter.setMaxLength(download.getTheme(), length, andReplace));
        replStr = replStr.replace("%T", DownloadFactoryMakeParameter.setMaxLength(download.getTitle(), length, andReplace));
        replStr = replStr.replace("%s", DownloadFactoryMakeParameter.setMaxLength(download.getChannel(), length, andReplace));
        replStr = replStr.replace("%N", DownloadFactoryMakeParameter.setMaxLength(PUrlTools.getFileName(download.getUrl()), length, andReplace));
        replStr = replStr.replace("%D", download.getFilmDate().isEmpty() ? DownloadFactoryMakeParameter.getToday_yyyyMMdd() : DownloadFactoryMakeParameter.cleanDate(DownloadFactoryMakeParameter.turnDate(download.getFilmDateStr())));
        replStr = replStr.replace("%d", download.getFilmTime().isEmpty() ? DownloadFactoryMakeParameter.getNow_HHMMSS() : DownloadFactoryMakeParameter.cleanDate(download.getFilmTime()));
        replStr = replStr.replace("%H", DownloadFactoryMakeParameter.getToday_yyyyMMdd());
        replStr = replStr.replace("%h", DownloadFactoryMakeParameter.getNow_HHMMSS());
        replStr = replStr.replace("%1", DownloadFactoryMakeParameter.getDMY("%1", download.getFilmDateStr().isEmpty() ? DownloadFactoryMakeParameter.getToday__yyyy_o_MM_o_dd() : download.getFilmDateStr()));
        replStr = replStr.replace("%2", DownloadFactoryMakeParameter.getDMY("%2", download.getFilmDateStr().isEmpty() ? DownloadFactoryMakeParameter.getToday__yyyy_o_MM_o_dd() : download.getFilmDateStr()));
        replStr = replStr.replace("%3", DownloadFactoryMakeParameter.getDMY("%3", download.getFilmDateStr().isEmpty() ? DownloadFactoryMakeParameter.getToday__yyyy_o_MM_o_dd() : download.getFilmDateStr()));
        replStr = replStr.replace("%4", DownloadFactoryMakeParameter.getHMS("%4", download.getFilmTime().isEmpty() ? DownloadFactoryMakeParameter.getNow_HH_MM_SS() : download.getFilmTime()));
        replStr = replStr.replace("%5", DownloadFactoryMakeParameter.getHMS("%5", download.getFilmTime().isEmpty() ? DownloadFactoryMakeParameter.getNow_HH_MM_SS() : download.getFilmTime()));
        replStr = replStr.replace("%6", DownloadFactoryMakeParameter.getHMS("%6", download.getFilmTime().isEmpty() ? DownloadFactoryMakeParameter.getNow_HH_MM_SS() : download.getFilmTime()));
        replStr = replStr.replace("%i", String.valueOf(download.getFilmNo()));
        String res = "";
        if (download.getUrl().equals(download.getUrlForResolution("normal"))) {
            res = "H";
        } else if (download.getUrl().equals(download.getUrlForResolution("hd"))) {
            res = "HD";
        } else if (download.getUrl().equals(download.getUrlForResolution("small"))) {
            res = "L";
        }
        replStr = replStr.replace("%q", res);
        replStr = replStr.replace("%S", PUrlTools.getSuffixFromUrl(download.getUrl()));
        replStr = replStr.replace("%Z", P2FileUtils.getHash(download.getUrl()));
        replStr = replStr.replace("%z", P2FileUtils.getHash(download.getUrl()) + "." + PUrlTools.getSuffixFromUrl(download.getUrl()));
        return replStr;
    }

    private static String setMaxLength(String name, int length, boolean andReplace) {
        if (andReplace) {
            name = DownloadFactory.replaceFileNameWithReplaceList(name, false);
        }
        if (length <= 0) {
            return name;
        }
        if (name.length() > length) {
            name = name.substring(0, length);
        }
        return name;
    }

    private static String getNow_HHMMSS() {
        return P2DateConst.F_FORMAT_HHmmss.format(new Date());
    }

    private static String getNow_HH_MM_SS() {
        return P2DateConst.F_FORMAT_HH__mm__ss.format(new Date());
    }

    private static String getToday_yyyyMMdd() {
        return P2DateConst.F_FORMAT_yyyyMMdd.format(new Date());
    }

    private static String getToday_yyyy_MM_dd() {
        return P2DateConst.F_FORMAT_yyyy_MM_dd.format(new Date());
    }

    private static String getToday__yyyy_o_MM_o_dd() {
        return P2DateConst.F_FORMAT_dd_MM_yyyy.format(new Date());
    }

    private static String getDMY(String s, String datum) {
        String ret = "";
        if (!datum.isEmpty()) {
            try {
                if (datum.length() == 10) {
                    switch (s) {
                        case "%1": {
                            ret = datum.substring(0, 2);
                            break;
                        }
                        case "%2": {
                            ret = datum.substring(3, 5);
                            break;
                        }
                        case "%3": {
                            ret = datum.substring(6);
                        }
                    }
                }
            }
            catch (Exception ex) {
                P2Log.errorLog(775421006, ex, datum);
            }
        }
        return ret;
    }

    private static String getHMS(String s, String zeit) {
        String ret = "";
        if (!zeit.isEmpty()) {
            try {
                if (zeit.length() == 8) {
                    switch (s) {
                        case "%4": {
                            ret = zeit.substring(0, 2);
                            break;
                        }
                        case "%5": {
                            ret = zeit.substring(3, 5);
                            break;
                        }
                        case "%6": {
                            ret = zeit.substring(6);
                        }
                    }
                }
            }
            catch (Exception ex) {
                P2Log.errorLog(775421006, ex, zeit);
            }
        }
        return ret;
    }

    private static String turnDate(String date) {
        Object ret = "";
        if (!date.isEmpty()) {
            try {
                if (date.length() == 10) {
                    Object tmp = date.substring(6);
                    tmp = (String)tmp + "." + date.substring(3, 5);
                    ret = tmp = (String)tmp + "." + date.substring(0, 2);
                }
            }
            catch (Exception ex) {
                P2Log.errorLog(775421006, ex, date);
            }
        }
        return ret;
    }

    private static String cleanDate(String date) {
        String ret = date;
        ret = ret.replace(":", "");
        ret = ret.replace(".", "");
        return ret;
    }

    private static String buildUrl(DownloadData downloadData, String execString) {
        if (downloadData.getUrlList().size() <= 1) {
            return execString.replace("%f", downloadData.getUrl());
        }
        String TRENNER = execString.contains("<>") ? "<>" : " ";
        StringBuilder url = new StringBuilder();
        boolean append = false;
        for (String u : downloadData.getUrlList()) {
            if (!append) {
                append = true;
            } else {
                url.append(TRENNER);
            }
            url.append(u);
        }
        return execString.replace("%f", url);
    }

    private static String replaceExec(DownloadData downloadData, String execString) {
        execString = execString.replace("**", downloadData.getDestPathFile());
        execString = execString.replace("%w", downloadData.getUrlWebsite());
        execString = execString.replace("%t", downloadData.getTheme());
        execString = execString.replace("%T", downloadData.getTitle());
        execString = execString.replace("%s", downloadData.getChannel());
        execString = execString.replace("%a", downloadData.getDestPath());
        execString = execString.replace("%b", downloadData.getDestFileName());
        return execString;
    }
}

