/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.controller.data.download;

import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.controller.data.download.DownloadData;
import de.p2tools.mtplayer.gui.dialog.downloaddialog.DownloadOnlyStopDialogController;
import de.p2tools.mtplayer.gui.dialog.downloaddialog.DownloadStopDialogController;
import de.p2tools.mtplayer.gui.tools.MTInfoFile;
import de.p2tools.mtplayer.gui.tools.MTSubtitle;
import de.p2tools.p2lib.P2LibConst;
import de.p2tools.p2lib.alert.P2Alert;
import de.p2tools.p2lib.dialogs.dialog.P2DialogExtra;
import de.p2tools.p2lib.tools.log.P2Log;
import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;

public class DownloadFactoryDelDownloadFiles {
    private DownloadFactoryDelDownloadFiles() {
    }

    public static void deleteFilesOfDownload(DownloadData download) {
        if (download == null) {
            return;
        }
        if (download.isStateStartedRun()) {
            P2Alert.showErrorAlert("Film l\u00f6schen", "Download l\u00e4uft noch", "Download erst stoppen!");
            return;
        }
        ObservableList<File> fileList = DownloadFactoryDelDownloadFiles.getDownloadFileList(download);
        ObservableList<DownloadData> downloadList = FXCollections.observableArrayList(download);
        if (ProgConfig.DOWNLOAD_STOP.getValue() == 1) {
            DownloadFactoryDelDownloadFiles.deleteDownloadFiles(download, true);
        } else {
            DownloadStopDialogController downloadStopDialogController = new DownloadStopDialogController(downloadList, fileList, 1);
            if (downloadStopDialogController.getState() == P2DialogExtra.STATE.STATE_DOWN_AND_FILE) {
                DownloadFactoryDelDownloadFiles.deleteDownloadFiles(download, true);
            }
        }
    }

    public static boolean stopDownloadAndDeleteFile(List<DownloadData> downloads, boolean deleteDownload) {
        ObservableList<DownloadData> foundDownloadList = FXCollections.observableArrayList();
        for (DownloadData download : downloads) {
            if (!deleteDownload && !download.isStateStartedWaiting() && !download.isStateStartedRun() && !download.isStateError()) continue;
            foundDownloadList.add(download);
        }
        if (foundDownloadList.isEmpty()) {
            return false;
        }
        ObservableList<File> fileList = DownloadFactoryDelDownloadFiles.getDownloadFileList(foundDownloadList);
        boolean delDownload = fileList.isEmpty() ? DownloadFactoryDelDownloadFiles.askForDownload(foundDownloadList, deleteDownload) : DownloadFactoryDelDownloadFiles.askForDownloadAndFile(foundDownloadList, fileList, deleteDownload);
        return delDownload;
    }

    private static boolean askForDownload(ObservableList<DownloadData> foundDownloadList, boolean delete) {
        boolean delDownload;
        if (ProgConfig.DOWNLOAD_ONLY_STOP.getValue() == 1) {
            P2Log.sysLog("Stop Download: DL l\u00f6schen");
            foundDownloadList.forEach(downloadData -> downloadData.stopDownload(false));
            delDownload = true;
        } else {
            P2Log.sysLog("Stop Download: Erst mal fragen");
            DownloadOnlyStopDialogController downloadStopDialogController = new DownloadOnlyStopDialogController(foundDownloadList, delete);
            if (downloadStopDialogController.getState() == P2DialogExtra.STATE.STATE_OK) {
                P2Log.sysLog("Stop Download: DL l\u00f6schen");
                foundDownloadList.forEach(downloadData -> downloadData.stopDownload(false));
                delDownload = true;
            } else {
                P2Log.sysLog("Stop Download: Abbruch");
                delDownload = false;
            }
        }
        return delDownload;
    }

    private static boolean askForDownloadAndFile(ObservableList<DownloadData> foundDownloadList, ObservableList<File> fileList, boolean deleteDownload) {
        boolean delDownload;
        try {
            switch (ProgConfig.DOWNLOAD_STOP.getValue()) {
                case 2: {
                    P2Log.sysLog("Stop Download: DL l\u00f6schen, Dateien nicht");
                    foundDownloadList.forEach(downloadData -> downloadData.stopDownload(false));
                    delDownload = true;
                    break;
                }
                case 1: {
                    P2Log.sysLog("Stop Download: DL und Dateien l\u00f6schen");
                    foundDownloadList.forEach(downloadData -> {
                        if (downloadData.isStateStartedRun() || downloadData.isStateStartedWaiting()) {
                            downloadData.stopDownload(true);
                        } else {
                            DownloadFactoryDelDownloadFiles.deleteFilesOfDownload(downloadData);
                        }
                    });
                    delDownload = true;
                    break;
                }
                default: {
                    P2Log.sysLog("Stop Download: Erst mal fragen");
                    DownloadStopDialogController downloadStopDialogController = new DownloadStopDialogController(foundDownloadList, fileList, deleteDownload ? 0 : 2);
                    if (downloadStopDialogController.getState() == P2DialogExtra.STATE.STATE_DOWN_AND_FILE) {
                        P2Log.sysLog("Stop Download: DL und Dateien l\u00f6schen");
                        foundDownloadList.forEach(downloadData -> {
                            if (downloadData.isStateStartedRun() || downloadData.isStateStartedWaiting()) {
                                downloadData.stopDownload(true);
                            } else {
                                DownloadFactoryDelDownloadFiles.deleteDownloadFiles(downloadData, true);
                            }
                        });
                        delDownload = true;
                        break;
                    }
                    if (downloadStopDialogController.getState() == P2DialogExtra.STATE.STATE_ONLY_DOWNLOAD) {
                        P2Log.sysLog("Stop Download: Nur DL l\u00f6schen");
                        foundDownloadList.forEach(downloadData -> downloadData.stopDownload(false));
                        delDownload = true;
                        break;
                    }
                    P2Log.sysLog("Stop Download: Abbruch");
                    delDownload = false;
                    break;
                }
            }
        }
        catch (Exception ex) {
            P2Alert.showErrorAlert("Film l\u00f6schen", "Konnte die Datei nicht l\u00f6schen!", "Fehler beim l\u00f6schen");
            P2Log.errorLog(503231450, "Fehler beim l\u00f6schen");
            delDownload = false;
        }
        return delDownload;
    }

    private static ObservableList<File> getDownloadFileList(List<DownloadData> downList) {
        ObservableList<File> delFileList = FXCollections.observableArrayList();
        downList.forEach(downloadData -> delFileList.addAll((Collection<File>)DownloadFactoryDelDownloadFiles.getDownloadFileList(downloadData)));
        return delFileList;
    }

    private static ObservableList<File> getDownloadFileList(DownloadData downloadData) {
        Path subtitlePathSrt;
        Path subtitlePath;
        Path infoPath;
        ObservableList<File> delFileList = FXCollections.observableArrayList();
        File file = downloadData.getFile();
        if (file.exists()) {
            delFileList.add(file);
        }
        if (downloadData.isInfoFile() && (infoPath = MTInfoFile.getInfoFilePath(downloadData)) != null && (file = infoPath.toFile()).exists()) {
            delFileList.add(file);
        }
        if (downloadData.isSubtitle() && (subtitlePath = MTSubtitle.getSubtitlePath(downloadData)) != null && (file = subtitlePath.toFile()).exists()) {
            delFileList.add(file);
        }
        if (downloadData.isSubtitle() && (subtitlePathSrt = MTSubtitle.getSrtPath(downloadData)) != null && (file = subtitlePathSrt.toFile()).exists()) {
            delFileList.add(file);
        }
        return delFileList;
    }

    public static void deleteDownloadFiles(DownloadData downloadData, boolean showErrorDialog) {
        block4: {
            ObservableList<File> fileList = DownloadFactoryDelDownloadFiles.getDownloadFileList(downloadData);
            if (fileList.isEmpty()) {
                return;
            }
            String delFile = "";
            try {
                for (File f : fileList) {
                    delFile = f.getAbsolutePath();
                    P2Log.sysLog(new String[]{"Datei l\u00f6schen: ", f.getAbsolutePath()});
                    if (f.delete()) continue;
                    throw new Exception();
                }
            }
            catch (Exception ex) {
                String df = delFile;
                if (!showErrorDialog) break block4;
                Platform.runLater(() -> {
                    P2Alert.showErrorAlert("Datei l\u00f6schen", "Konnte die Datei nicht l\u00f6schen!", "Fehler beim L\u00f6schen von:" + P2LibConst.LINE_SEPARATORx2 + df);
                    P2Log.errorLog(989754125, "Fehler beim l\u00f6schen: " + df);
                });
            }
        }
    }
}

