/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.controller.data.download;

import java.text.DecimalFormat;

public class DownloadConstants {
    public static final String TRENNER_PROG_ARRAY = "<>";
    public static final double PROGRESS_1_PERCENT = 0.01;
    public static final double PROGRESS_NOT_STARTED = -1.0;
    public static final double PROGRESS_WAITING = 0.0;
    public static final double PROGRESS_STARTED = 0.001;
    public static final double PROGRESS_NEARLY_FINISHED = 0.995;
    public static final double PROGRESS_FINISHED = 1.0;
    public static final int STATE_INIT = 0;
    public static final int STATE_STOPPED = 1;
    public static final int STATE_STARTED_WAITING = 2;
    public static final int STATE_STARTED_RUN = 3;
    public static final int STATE_FINISHED = 4;
    public static final int STATE_ERROR = 5;
    public static final String ALL = "";
    public static final String SRC_BUTTON = "Button";
    public static final String SRC_DOWNLOAD = "Download";
    public static final String SRC_ABO = "Abo";
    public static final String SRC_COMBO_DOWNLOAD = "nur Downloads";
    public static final String SRC_COMBO_ABO = "nur Abos";
    public static final String TYPE_DOWNLOAD = "direkter Download";
    public static final String TYPE_PROGRAM = "Programm";
    public static final String TYPE_COMBO_DOWNLOAD = "nur direkte Downloads";
    public static final String TYPE_COMBO_PROGRAM = "nur Programme";
    public static final String STATE_COMBO_NOT_STARTED = "Noch nicht gestartet";
    public static final String STATE_COMBO_WAITING = "Gestartet, wartet noch";
    public static final String STATE_COMBO_STARTED = "Gestartet, l\u00e4uft oder wartet";
    public static final String STATE_COMBO_LOADING = "L\u00e4uft";
    public static final String STATE_COMBO_ERROR = "Fehlerhaft";
    public static final int REMAINING_NOT_STARTET = Integer.MIN_VALUE;
    private static final DecimalFormat df = new DecimalFormat("###,##0.0");

    public static String getTextProgress(boolean dManager, int status, double progress) {
        Object ret = ALL;
        if (progress == -1.0) {
            ret = status == 1 ? "abgebrochen" : (status == 2 ? "wartet" : (status == 5 ? (dManager ? "extern:fehler" : "fehlerhaft") : "nicht gestartet"));
        } else if (progress == 0.0) {
            ret = dManager ? "extern" : "warten";
        } else if (progress == 0.001) {
            ret = dManager ? "extern" : "gestartet";
        } else if (progress > 0.001 && progress < 1.0) {
            ret = dManager ? "extern" : df.format(progress * 100.0) + " %";
        } else if (progress == 1.0 && status == 5) {
            ret = dManager ? "extern:fehler" : "fehlerhaft";
        } else if (progress == 1.0) {
            ret = dManager ? "extern:fertig" : "fertig";
        }
        return ret;
    }

    public static String getRemaining(int l) {
        if (l == Integer.MIN_VALUE) {
            return ALL;
        }
        if (l < 0) {
            int dauer = l / 60;
            if (dauer == 0) {
                return "\u2211:  " + -1 * l + " s";
            }
            return "\u2211:  " + -1 * dauer + " Min";
        }
        return DownloadConstants.getTextTimeLeft(l);
    }

    public static String getTextTimeLeft(long timeLeftSeconds) {
        if (timeLeftSeconds > 300L) {
            return Math.round((double)timeLeftSeconds / 60.0) + " Min.";
        }
        if (timeLeftSeconds > 230L) {
            return "5 Min.";
        }
        if (timeLeftSeconds > 170L) {
            return "4 Min.";
        }
        if (timeLeftSeconds > 110L) {
            return "3 Min.";
        }
        if (timeLeftSeconds > 60L) {
            return "2 Min.";
        }
        if (timeLeftSeconds > 30L) {
            return "1 Min.";
        }
        if (timeLeftSeconds > 20L) {
            return "30 s";
        }
        if (timeLeftSeconds > 10L) {
            return "20 s";
        }
        if (timeLeftSeconds > 0L) {
            return "10 s";
        }
        return ALL;
    }
}

