/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.controller.data.cleaningdata;

import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.data.cleaningdata.CleaningData;
import de.p2tools.mtplayer.gui.mediaSearch.MediaDataDto;

public class CleaningMediaFactory {
    private static final String TRENNER_OR = ",";
    private static final String TRENNER_AND = ":";

    private CleaningMediaFactory() {
    }

    public static String cleanSearchText(MediaDataDto mediaDataDto) {
        Object searchString = switch (mediaDataDto.buildSearchFrom.getValue()) {
            case 0 -> mediaDataDto.searchTheme.toLowerCase();
            case 1 -> mediaDataDto.searchTitle.toLowerCase();
            default -> mediaDataDto.searchTheme.toLowerCase() + " " + mediaDataDto.searchTitle.toLowerCase();
        };
        if (mediaDataDto.cleaningExact.getValue().booleanValue()) {
            return "\"" + (String)searchString + "\"";
        }
        if (!mediaDataDto.cleaning.getValue().booleanValue()) {
            return searchString;
        }
        searchString = CleaningMediaFactory.cleanSearchString((String)searchString, "(", ")");
        searchString = CleaningMediaFactory.cleanSearchString((String)searchString, "[", "]");
        searchString = CleaningMediaFactory.cleanSearchString((String)searchString, "{", "}");
        searchString = ((String)searchString).replaceAll("(0[1-9]|[12][0-9]|3[01])(\\.|\\/|-)(0[1-9]|1[0-2])(\\.|\\/|-)((?:19|20)\\d{2})", " ");
        searchString = ((String)searchString).replaceAll("(0[1-9]|[12][0-9]|3[01])(\\.|\\/|-|)(\\s?)(januar|februar|m\u00e4rz|april|mai|juni|juli|augist|september|oktober|november|dezember)(\\s?)((?:19|20)\\d{2})", " ");
        searchString = ((String)searchString).replaceAll("(0[1-9]|[12][0-9]|3[01])(\\.|\\/|-|)(\\s?)(januar|februar|m\u00e4rz|april|mai|juni|juli|augist|september|oktober|november|dezember)", " ");
        searchString = ((String)searchString).replaceAll("([0-9]+)(\\.|\\/|-)", " ");
        searchString = ((String)searchString).replaceAll("([0-9])", " ");
        while (((String)searchString).contains("  ")) {
            searchString = ((String)searchString).replaceAll("  ", " ");
        }
        if (mediaDataDto.cleaningList.getValue().booleanValue()) {
            String[] arr = ((String)searchString).split(" ");
            searchString = "";
            for (String search : arr) {
                for (CleaningData cleaningData : ProgData.getInstance().cleaningDataListMedia) {
                    if (cleaningData.getAlways()) {
                        search = search.replace(cleaningData.getCleaningString(), "");
                        continue;
                    }
                    if (!search.equals(cleaningData.getCleaningString())) continue;
                    search = "";
                }
                if (search.length() <= 2 || ((String)searchString).contains(" " + search)) continue;
                searchString = (String)searchString + " " + search;
            }
        }
        searchString = ((String)searchString).trim();
        searchString = mediaDataDto.cleaningAndOr.getValue() != false ? ((String)searchString).replaceAll(" ", TRENNER_AND) : ((String)searchString).replaceAll(" ", TRENNER_OR);
        return searchString;
    }

    private static String cleanSearchString(String str, String key1, String key2) {
        Object ret = str;
        while (((String)ret).contains(key1) && ((String)ret).contains(key2) && ((String)ret).indexOf(key1) < ((String)ret).indexOf(key2)) {
            ret = ((String)ret).substring(0, ((String)ret).indexOf(key1)) + ((String)ret).substring(((String)ret).indexOf(key2) + 1);
        }
        return ret;
    }
}

