/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.controller.data.cleaningdata;

import de.p2tools.mtplayer.controller.data.cleaningdata.CleaningData;
import de.p2tools.p2lib.configfile.config.Config;
import de.p2tools.p2lib.configfile.config.Config_boolProp;
import de.p2tools.p2lib.configfile.config.Config_stringProp;
import de.p2tools.p2lib.configfile.pdata.P2DataSample;
import java.util.ArrayList;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;

public class CleaningDataProps
extends P2DataSample<CleaningDataProps> {
    public static final String TAG = "CleaningData";
    private final StringProperty cleaningString = new SimpleStringProperty("");
    private final BooleanProperty always = new SimpleBooleanProperty(true);
    private final StringProperty codePoint = new SimpleStringProperty("");

    public CleaningDataProps() {
        this.cleaningString.addListener((u, o, n) -> this.makeUtfCodePoint());
    }

    @Override
    public Config[] getConfigsArr() {
        ArrayList<Config> list = new ArrayList<Config>();
        list.add(new Config_stringProp("cleaningString", this.cleaningString));
        list.add(new Config_boolProp("always", this.always));
        return list.toArray(new Config[0]);
    }

    public CleaningData getCopy() {
        CleaningData data = new CleaningData();
        data.setCleaningString(this.cleaningString.getValueSafe());
        data.setCodePoint(this.codePoint.getValueSafe());
        return data;
    }

    @Override
    public String getTag() {
        return TAG;
    }

    public String getCleaningString() {
        return (String)this.cleaningString.get();
    }

    public StringProperty cleaningStringProperty() {
        return this.cleaningString;
    }

    public void setCleaningString(String cleaningString) {
        this.cleaningString.set(cleaningString);
        this.makeUtfCodePoint();
    }

    public boolean getAlways() {
        return this.always.get();
    }

    public BooleanProperty alwaysProperty() {
        return this.always;
    }

    public void setAlways(boolean always) {
        this.always.set(always);
    }

    public String getCodePoint() {
        return (String)this.codePoint.get();
    }

    public StringProperty codePointProperty() {
        return this.codePoint;
    }

    public void setCodePoint(String codePoint) {
        this.codePoint.set(codePoint);
    }

    public void makeUtfCodePoint() {
        StringBuilder s = new StringBuilder();
        char[] chars = this.cleaningString.getValueSafe().toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (i > 0) {
                s.append(", ");
            }
            s.append(Character.codePointAt(chars, i));
        }
        this.codePoint.setValue(s.toString());
    }
}

