/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.controller.data.blackdata;

import de.p2tools.mtplayer.controller.config.PEvents;
import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.data.blackdata.BlackData;
import de.p2tools.mtplayer.controller.film.FilmListMTP;
import de.p2tools.mtplayer.controller.worker.Busy;
import de.p2tools.p2lib.mtfilm.film.FilmData;
import de.p2tools.p2lib.mtfilm.film.FilmDataProps;
import de.p2tools.p2lib.mtfilter.FilmFilterCheck;
import de.p2tools.p2lib.tools.duration.P2Duration;
import de.p2tools.p2lib.tools.log.P2Log;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;

public class BlacklistFilterFactory {
    public static final int BLACKLILST_FILTER_OFF = 0;
    public static final int BLACKLILST_FILTER_ON = 1;
    public static final int BLACKLILST_FILTER_INVERS = 2;
    private static long maxFilmDays = 0L;
    private static boolean doNotShowFutureFilms;
    private static boolean doNotShowGeoBlockedFilms;
    private static boolean doNotShowDoubleFilms;
    private static long minFilmDuration;
    private static int act;
    private static int now;

    private BlacklistFilterFactory() {
    }

    public static void markFilmBlackThread(boolean notify) {
        ProgData.busy.busyOnFx(Busy.BUSY_SRC.GUI, "Blacklist", -1.0, false);
        new Thread(() -> {
            BlacklistFilterFactory.markFilmBlack(notify);
            ProgData.busy.busyOffFx();
        }).start();
    }

    public static synchronized void markFilmBlack(boolean notify) {
        boolean maskerPane;
        P2Duration.counterStart("markFilmBlack");
        P2Log.sysLog("markFilmBlack -> start");
        if (ProgData.getInstance().maskerPane.isVisible()) {
            maskerPane = true;
            ProgData.getInstance().maskerPane.setMaskerText("Blacklist filtern");
        } else {
            maskerPane = false;
        }
        ProgData.getInstance().blackList.clearCounter();
        BlacklistFilterFactory.loadCurrentBlacklistSettings();
        P2Duration.counterStart("forEach");
        int sum = ProgData.getInstance().filmList.size();
        act = 0;
        now = 0;
        ProgData.getInstance().filmList.forEach(filmDataMTP -> {
            ++act;
            if (++now > 5000) {
                now = 0;
                double percent = (double)act / (double)sum;
                ProgData.busy.setProgress(percent);
                if (maskerPane) {
                    ProgData.getInstance().maskerPane.setMaskerProgress(percent, "Blacklist filtern");
                }
            }
            filmDataMTP.setBlackBlocked(BlacklistFilterFactory.checkFilmIsBlockedCompleteBlackData(filmDataMTP, ProgData.getInstance().blackList, true));
        });
        P2Duration.counterStop("forEach");
        BlacklistFilterFactory.makeBlackFilteredFilmlist();
        if (maskerPane) {
            ProgData.getInstance().maskerPane.setMaskerProgress(-1.0, "Blacklist filtern");
        }
        P2Log.sysLog("markFilmBlack -> stop");
        P2Duration.counterStop("markFilmBlack");
        if (notify) {
            ProgData.getInstance().pEventHandler.notifyListener(PEvents.EVENT_BLACKLIST_CHANGED);
        }
    }

    public static synchronized void makeBlackFilteredFilmlist() {
        ProgData progData = ProgData.getInstance();
        FilmListMTP filmList = progData.filmList;
        FilmListMTP filmListFiltered = progData.filmListFiltered;
        P2Duration.counterStart("makeBlackFilteredFilmlist");
        BlacklistFilterFactory.loadCurrentBlacklistSettings();
        filmListFiltered.clear();
        if (filmList != null) {
            filmListFiltered.setMeta(filmList);
            Stream<Object> initialStream = filmList.parallelStream();
            if (progData.filterWorker.getActFilterSettings().getBlacklistOnOff() == 2) {
                P2Log.sysLog("FilmlistBlackFilter - isBlacklistOnly");
                initialStream = initialStream.filter(FilmDataProps::isBlackBlocked);
            } else if (progData.filterWorker.getActFilterSettings().getBlacklistOnOff() == 1) {
                P2Log.sysLog("FilmlistBlackFilter - isBlacklistOn");
                initialStream = initialStream.filter(filmDataMTP -> !filmDataMTP.isBlackBlocked());
            } else {
                P2Log.sysLog("FilmlistBlackFilter - isBlacklistOff");
            }
            filmListFiltered.addAll(initialStream.toList());
            filmListFiltered.loadTheme();
        }
        P2Duration.counterStop("makeBlackFilteredFilmlist");
    }

    public static synchronized boolean checkFilmIsBlockedCompleteBlackData(FilmData filmData, List<BlackData> list, boolean incCounter) {
        if (doNotShowGeoBlockedFilms && filmData.isGeoBlocked()) {
            return true;
        }
        if (doNotShowDoubleFilms && filmData.isDoubleUrl()) {
            return true;
        }
        if (doNotShowFutureFilms && filmData.isInFuture()) {
            return true;
        }
        if (minFilmDuration != 0L && !BlacklistFilterFactory.checkOkFilmLength(filmData)) {
            return true;
        }
        if (maxFilmDays > 0L && !BlacklistFilterFactory.checkOkDate(filmData)) {
            return true;
        }
        return BlacklistFilterFactory.checkFilmAndCountHits(filmData, list, incCounter);
    }

    public static boolean checkFilmAndCountHits(FilmData filmData, List<BlackData> list, boolean countHits) {
        filmData.setLowerCase();
        for (BlackData blackData : list) {
            if (!blackData.isActive() || !BlacklistFilterFactory.checkFilmIsBlocked(blackData, filmData)) continue;
            if (countHits) {
                blackData.incCountHits();
            }
            filmData.clearLowerCase();
            return true;
        }
        filmData.clearLowerCase();
        return false;
    }

    private static void checkFilmAndCountHitsForAll(FilmData filmData, List<BlackData> list) {
        filmData.setLowerCase();
        list.parallelStream().forEach(blackData -> {
            if (BlacklistFilterFactory.checkFilmIsBlocked(blackData, filmData)) {
                blackData.incCountHits();
            }
        });
        filmData.clearLowerCase();
    }

    public static synchronized void countHits(BlackData blackData) {
        ArrayList<BlackData> bl = new ArrayList<BlackData>();
        bl.add(blackData);
        BlacklistFilterFactory.countHits(bl);
    }

    public static synchronized void countHits(List<BlackData> list) {
        P2Duration.counterStart("countHits");
        for (BlackData bl : list) {
            bl.clearCounter();
        }
        ArrayList<BlackData> copyList = new ArrayList<BlackData>(list);
        int sum = ProgData.getInstance().filmList.size();
        act = 0;
        now = 0;
        FilmListMTP filmDataMTPS = ProgData.getInstance().filmList;
        if (filmDataMTPS != null) {
            filmDataMTPS.forEach(film -> {
                ++act;
                if (++now > 1000) {
                    now = 0;
                    double percent = (double)act / (double)sum;
                    ProgData.busy.setProgress(percent);
                }
                BlacklistFilterFactory.checkFilmAndCountHitsForAll(film, copyList);
            });
        }
        P2Duration.counterStop("countHits");
    }

    private static void loadCurrentBlacklistSettings() {
        try {
            if (ProgConfig.SYSTEM_BLACKLIST_MAX_FILM_DAYS.getValue() == 0) {
                maxFilmDays = 0L;
            } else {
                long max = 86400000L * (long)ProgConfig.SYSTEM_BLACKLIST_MAX_FILM_DAYS.getValue().intValue();
                maxFilmDays = System.currentTimeMillis() - max;
            }
        }
        catch (Exception ex) {
            maxFilmDays = 0L;
        }
        minFilmDuration = ProgConfig.SYSTEM_BLACKLIST_MIN_FILM_DURATION.getValue().intValue();
        doNotShowFutureFilms = ProgConfig.SYSTEM_BLACKLIST_SHOW_NO_FUTURE.getValue();
        doNotShowGeoBlockedFilms = ProgConfig.SYSTEM_BLACKLIST_SHOW_NO_GEO.getValue();
        doNotShowDoubleFilms = ProgConfig.SYSTEM_BLACKLIST_SHOW_NO_DOUBLE.getValue();
    }

    private static boolean checkFilmIsBlocked(BlackData blackData, FilmData filmData) {
        if (blackData.quickChannel) {
            return filmData.FILM_CHANNEL_STR.contains(blackData.fChannel.filterArr[0]);
        }
        if (blackData.quickTheme) {
            if (blackData.fTheme.isExact) {
                return filmData.FILM_THEME_STR.equals(blackData.fTheme.filterArr[0]);
            }
            if (filmData.FILM_THEME_STR.contains(blackData.fTheme.filterArr[0])) {
                return !blackData.fTheme.exclude;
            }
            return blackData.fTheme.exclude;
        }
        if (blackData.quickThemTitle) {
            if (filmData.FILM_THEME_STR.contains(blackData.fThemeTitle.filterArr[0]) || filmData.FILM_TITLE_STR.contains(blackData.fThemeTitle.filterArr[0])) {
                return !blackData.fThemeTitle.exclude;
            }
            return blackData.fThemeTitle.exclude;
        }
        if (blackData.quickTitle) {
            if (filmData.FILM_TITLE_STR.contains(blackData.fTitle.filterArr[0])) {
                return !blackData.fTitle.exclude;
            }
            return blackData.fTitle.exclude;
        }
        boolean ret = FilmFilterCheck.checkFilterMatch(blackData.fChannel, blackData.fTheme, blackData.fThemeTitle, blackData.fTitle, filmData);
        return ret;
    }

    private static boolean checkOkDate(FilmData film) {
        long filmTime = film.filmDate.getTime();
        return filmTime == 0L || filmTime > maxFilmDays;
    }

    private static boolean checkOkFilmLength(FilmData film) {
        return film.getDurationMinute() == 0 || (long)film.getDurationMinute() >= minFilmDuration;
    }

    static {
        minFilmDuration = 0L;
        act = 0;
        now = 0;
    }
}

