/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.controller.data.blackdata;

import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.data.blackdata.BlackData;
import de.p2tools.mtplayer.controller.data.blackdata.BlackList;
import de.p2tools.mtplayer.controller.data.download.DownloadData;
import de.p2tools.mtplayer.controller.film.FilmDataMTP;
import de.p2tools.mtplayer.gui.dialog.AddBlackListDialogController;
import java.util.List;
import java.util.Optional;

public class BlacklistFactory {
    private BlacklistFactory() {
    }

    public static void addBlackFilm(boolean film) {
        BlackData blackData;
        if (film) {
            Optional<FilmDataMTP> filmDataMTP = ProgData.getInstance().filmGuiController.getSel(true, true);
            if (filmDataMTP.isEmpty()) {
                return;
            }
            blackData = new BlackData(filmDataMTP.get().getChannel(), filmDataMTP.get().getTheme(), filmDataMTP.get().getTitle(), "");
        } else {
            Optional<DownloadData> downloadData = ProgData.getInstance().downloadGuiController.getSel(true);
            if (downloadData.isEmpty()) {
                return;
            }
            blackData = new BlackData(downloadData.get().getChannel(), downloadData.get().getTheme(), downloadData.get().getTitle(), "");
        }
        AddBlackListDialogController addBlacklistDialogController = new AddBlackListDialogController(blackData);
        if (!addBlacklistDialogController.isOk()) {
            return;
        }
        ProgData.getInstance().blackList.addAndNotify(blackData);
    }

    public static void addBlackThemeFilm() {
        Optional<FilmDataMTP> filmSelection = ProgData.getInstance().filmGuiController.getSel(true, true);
        if (filmSelection.isEmpty()) {
            return;
        }
        BlacklistFactory.addBlack("", filmSelection.get().getTheme(), "");
    }

    public static void addBlackThemeDownload() {
        Optional<DownloadData> downloadData = ProgData.getInstance().downloadGuiController.getSel(true);
        if (downloadData.isEmpty()) {
            return;
        }
        BlacklistFactory.addBlack("", downloadData.get().getTheme(), "");
    }

    public static void addBlack(String sender, String theme, String titel) {
        BlackData blackData = new BlackData(sender, theme, titel, "");
        ProgData.getInstance().blackList.addAndNotify(blackData);
    }

    public static boolean blackIsEmpty(BlackData blackData) {
        return blackData.getChannel().isEmpty() && blackData.getTheme().isEmpty() && blackData.getTitle().isEmpty() && blackData.getThemeTitle().isEmpty();
    }

    public static boolean blackExistsAlready(BlackData blackData, List<BlackData> list) {
        for (BlackData data : list) {
            if (!data.getChannel().equalsIgnoreCase(blackData.getChannel()) || !data.getTheme().equalsIgnoreCase(blackData.getTheme()) || (!data.getTheme().isEmpty() || !blackData.getTheme().isEmpty()) && data.isThemeExact() != blackData.isThemeExact() || !data.getTitle().equalsIgnoreCase(blackData.getTitle()) || !data.getThemeTitle().equalsIgnoreCase(blackData.getThemeTitle())) continue;
            return true;
        }
        return false;
    }

    public static void addStandardsList(BlackList list) {
        BlackData bl = new BlackData("", "", "- Audiodeskription", "");
        bl.setThemeExact(false);
        list.add(bl);
        bl = new BlackData("", "", "(Audiodeskription)", "");
        bl.setThemeExact(false);
        list.add(bl);
        bl = new BlackData("", "", "(Geb\u00e4rdensprache)", "");
        bl.setThemeExact(false);
        list.add(bl);
        bl = new BlackData("", "", "mit Geb\u00e4rdensprache", "");
        bl.setThemeExact(false);
        list.add(bl);
        bl = new BlackData("", "", "(mit Untertitel)", "");
        bl.setThemeExact(false);
        list.add(bl);
        bl = new BlackData("", "", "(Originalversion mit Untertitel)", "");
        bl.setThemeExact(false);
        list.add(bl);
        bl = new BlackData("", "", "in Geb\u00e4rdensprache", "");
        bl.setThemeExact(false);
        list.add(bl);
        bl = new BlackData("", "in Geb\u00e4rdensprache", "", "");
        bl.setThemeExact(false);
        list.add(bl);
        bl = new BlackData("", "", "\"Trailer:\"", "");
        bl.setThemeExact(false);
        list.add(bl);
    }
}

