/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.controller.config;

import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.p2lib.P2LibInit;
import de.p2tools.p2lib.tools.log.P2Log;
import java.io.IOException;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.URL;

public class ProxyFactory {
    private ProxyFactory() {
    }

    public static void initProxy() {
        ProxyFactory.printPoxySettings();
        if (ProgConfig.SYSTEM_USE_PROXY.getValue().booleanValue()) {
            try {
                String host = ProxyFactory.getHost();
                String port = ProxyFactory.getPort();
                if (!host.isEmpty() && !port.isEmpty()) {
                    ProxyFactory.setupAuthenticator();
                    System.setProperty("jdk.http.auth.tunneling.disabledSchemes", "false");
                    System.setProperty("jdk.http.auth.proxying.disabledSchemes", "false");
                }
            }
            catch (Exception ex) {
                P2Log.errorLog(205468971, "Fehler beim einrichten des Proxy");
            }
            P2LibInit.initProxy(ProgConfig.SYSTEM_USE_PROXY.getValue(), ProxyFactory.getHost(), ProxyFactory.getPort(), ProxyFactory.getUser(), ProxyFactory.getPwd());
        }
    }

    private static void printPoxySettings() {
        StringBuilder log = new StringBuilder("############################################################\nProxy-Settings\nUse Proxy: " + ProgConfig.SYSTEM_USE_PROXY.getValue() + "\n");
        if (ProgConfig.SYSTEM_USE_PROXY.getValue().booleanValue()) {
            log.append("==============\nSystemProperty:\n");
            if (System.getProperty("http.proxyHost") != null && !System.getProperty("http.proxyHost").isEmpty()) {
                log.append("http.proxyHost: ").append(System.getProperty("http.proxyHost")).append("\n");
            }
            if (System.getProperty("http.proxyPort") != null && !System.getProperty("http.proxyPort").isEmpty()) {
                log.append("http.proxyPort: ").append(System.getProperty("http.proxyPort")).append("\n");
            }
            if (System.getProperty("http.proxyUser") != null && !System.getProperty("http.proxyUser").isEmpty()) {
                log.append("http.proxyUser: ").append(System.getProperty("http.proxyUser")).append("\n");
            }
            if (System.getProperty("http.proxyPassword") != null && !System.getProperty("http.proxyPassword").isEmpty()) {
                log.append("http.proxyPassword: ").append("???????").append("\n");
            }
            log.append("==============\nProgrammeinstellungen:\n");
            log.append("Host: ").append(ProgConfig.SYSTEM_PROXY_HOST.getValueSafe()).append("\n");
            log.append("Port: ").append(ProgConfig.SYSTEM_PROXY_PORT.getValueSafe()).append("\n");
            log.append("User: ").append(ProgConfig.SYSTEM_PROXY_USER.getValueSafe()).append("\n");
            log.append("PWD: ").append(ProgConfig.SYSTEM_PROXY_PWD.getValueSafe().isEmpty() ? "" : "???????").append("\n");
        }
        log.append("############################################################\n");
        P2Log.sysLog(log.toString());
    }

    private static void setupAuthenticator() {
        String user = ProxyFactory.getUser();
        String pwd = ProxyFactory.getPwd();
        if (!user.isEmpty() && !pwd.isEmpty()) {
            Authenticator.setDefault(new ProxyAuthenticator(user, pwd));
        }
    }

    public static String getHost() {
        String host = System.getProperty("http.proxyHost") != null && !System.getProperty("http.proxyHost").isEmpty() ? System.getProperty("http.proxyHost") : ProgConfig.SYSTEM_PROXY_HOST.getValueSafe();
        return host;
    }

    public static String getPort() {
        String port = System.getProperty("http.proxyPort") != null && !System.getProperty("http.proxyPort").isEmpty() ? System.getProperty("http.proxyPort") : ProgConfig.SYSTEM_PROXY_PORT.getValueSafe();
        return port;
    }

    public static String getUser() {
        String usr = System.getProperty("http.proxyUser") != null && !System.getProperty("http.proxyUser").isEmpty() ? System.getProperty("http.proxyUser") : ProgConfig.SYSTEM_PROXY_USER.getValueSafe();
        return usr;
    }

    public static String getPwd() {
        String pwd = System.getProperty("http.proxyPassword") != null && !System.getProperty("http.proxyPassword").isEmpty() ? System.getProperty("http.proxyPassword") : ProgConfig.SYSTEM_PROXY_PWD.getValueSafe();
        return pwd;
    }

    public static HttpURLConnection getUrlConnection(String url) throws IOException {
        return ProxyFactory.getUrlConnection(new URL(url));
    }

    public static HttpURLConnection getUrlConnection(URL url) throws IOException {
        HttpURLConnection httpURLConn;
        String host = ProxyFactory.getHost();
        String port = ProxyFactory.getPort();
        if (!ProgConfig.SYSTEM_USE_PROXY.getValue().booleanValue() || host.isEmpty() || port.isEmpty()) {
            httpURLConn = (HttpURLConnection)url.openConnection();
        } else {
            try {
                int iPort = Integer.parseInt(port);
                Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(host, iPort));
                httpURLConn = (HttpURLConnection)url.openConnection(proxy);
            }
            catch (Exception ex) {
                P2Log.errorLog(701208613, "Kann die Proxy-Verbindung nicht aufbauen:\n" + host + " - " + port);
                httpURLConn = (HttpURLConnection)url.openConnection();
            }
        }
        httpURLConn.setConnectTimeout(1000 * ProgConfig.SYSTEM_PARAMETER_DOWNLOAD_TIMEOUT_SECOND.getValue());
        httpURLConn.setReadTimeout(1000 * ProgConfig.SYSTEM_PARAMETER_DOWNLOAD_TIMEOUT_SECOND.getValue());
        return httpURLConn;
    }

    static class ProxyAuthenticator
    extends Authenticator {
        private final String userName;
        private final String password;

        @Override
        protected PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(this.userName, this.password.toCharArray());
        }

        public ProxyAuthenticator(String userName, String password) {
            this.userName = userName;
            this.password = password;
        }
    }
}

