/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.controller.config;

import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.p2lib.colordata.P2ColorData;
import de.p2tools.p2lib.colordata.P2ColorList;
import de.p2tools.p2lib.tools.log.P2Log;
import java.util.Comparator;
import java.util.List;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.paint.Color;

public class ProgColorList
extends P2ColorList {
    public static final P2ColorData FILM_LIVESTREAM = ProgColorList.addNewKey("COLOR_FILM_LIVESTREAM", Color.rgb(130, 0, 0), Color.rgb(100, 0, 0), "Tabelle Filme, Livestreams");
    public static final P2ColorData FILM_HISTORY = ProgColorList.addNewKey("COLOR_FILM_HISTORY", Color.rgb(223, 223, 223), Color.rgb(70, 70, 70), "Tabelle Filme, gesehen");
    public static final P2ColorData FILM_NEW = ProgColorList.addNewKey("COLOR_FILM_NEW", Color.rgb(0, 0, 240), Color.rgb(0, 0, 240), "Tabelle Filme, neue");
    public static final P2ColorData FILM_BOOKMARK = ProgColorList.addNewKey("COLOR_FILM_BOKMARK", Color.rgb(255, 236, 151), Color.rgb(177, 164, 105), "Tabelle Filme, Bookmarks");
    public static final P2ColorData FILM_GEOBLOCK = ProgColorList.addNewKey("COLOR_FILM_GEOBLOCK_BACKGROUND", Color.rgb(255, 168, 0), Color.rgb(236, 153, 0), "Tabelle Filme, geogeblockt");
    public static final P2ColorData DOWNLOAD_WAIT = ProgColorList.addNewKey("COLOR_DOWNLOAD_WAIT", Color.rgb(239, 244, 255), Color.rgb(99, 100, 105), "Tabelle Download, noch nicht gestartet");
    public static final P2ColorData DOWNLOAD_RUN = ProgColorList.addNewKey("COLOR_DOWNLOAD_RUN", Color.rgb(255, 245, 176), Color.rgb(174, 150, 85), "Tabelle Download, l\u00e4uft");
    public static final P2ColorData DOWNLOAD_FINISHED = ProgColorList.addNewKey("COLOR_DOWNLOAD_FINISHED", Color.rgb(206, 255, 202), Color.rgb(79, 129, 74), "Tabelle Download, fertig");
    public static final P2ColorData DOWNLOAD_ERROR = ProgColorList.addNewKey("COLOR_DOWNLOAD_ERROR", Color.rgb(255, 233, 233), Color.rgb(163, 82, 82), "Tabelle Download, fehlerhaft");
    public static final P2ColorData ABO_SWITCHED_OFF = ProgColorList.addNewKey("COLOR_ABO_SWITCHED_OFF", Color.rgb(225, 225, 225), Color.rgb(109, 109, 109), "Tabelle Abo, ausgeschaltet");
    public static final P2ColorData BLACK_DATA_SWITCHED_OFF = ProgColorList.addNewKey("BLACK_DATA_SWITCHED_OFF", Color.rgb(225, 225, 225), Color.rgb(109, 109, 109), "Tabelle Blacklist, ausgeschaltet");
    public static final P2ColorData DOWNLOAD_NAME_ERROR = ProgColorList.addNewKey("COLOR_DOWNLOAD_NAME_ERROR", Color.rgb(255, 233, 233), Color.rgb(200, 183, 183), "Download, Dateiname ist fehlerhaft");
    public static final List<P2ColorData> FRONT_COLOR = List.of(FILM_LIVESTREAM, FILM_NEW, FILM_GEOBLOCK);

    private ProgColorList() {
    }

    public static synchronized P2ColorList getInstance() {
        return P2ColorList.getInst();
    }

    public static void setColorTheme() {
        boolean dark = ProgConfig.SYSTEM_DARK_THEME.get();
        for (int i = 0; i < ProgColorList.getInstance().size(); ++i) {
            ((P2ColorData)ProgColorList.getInstance().get(i)).setColorTheme(dark);
        }
    }

    public static ObservableList<P2ColorData> getColorListFront() {
        ObservableList<P2ColorData> list = FXCollections.observableArrayList();
        P2ColorList pColorData = ProgColorList.getInstance();
        pColorData.stream().filter(pc -> FRONT_COLOR.contains(pc)).forEach(pc -> list.add((P2ColorData)pc));
        Comparator<P2ColorData> comparator = Comparator.comparing(P2ColorData::getText);
        FXCollections.sort(list, comparator);
        return list;
    }

    public static ObservableList<P2ColorData> getColorListBackground() {
        ObservableList<P2ColorData> list = FXCollections.observableArrayList();
        P2ColorList pColorData = ProgColorList.getInstance();
        pColorData.stream().filter(pc -> !FRONT_COLOR.contains(pc)).forEach(pc -> list.add((P2ColorData)pc));
        Comparator<P2ColorData> comparator = Comparator.comparing(P2ColorData::getText);
        FXCollections.sort(list, comparator);
        return list;
    }

    public static void setColorData(String key, String value) {
        try {
            P2ColorList list = ProgColorList.getInstance();
            list.stream().forEach(pColorData -> {
                if (pColorData.getKey().equals(key)) {
                    Color c = Color.web(value);
                    if (value.endsWith("_DARK")) {
                        pColorData.setColorDark(c);
                    } else {
                        pColorData.setColorLight(c);
                    }
                }
            });
        }
        catch (Exception ex) {
            P2Log.errorLog(956410210, "setColorData");
        }
    }
}

