/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.controller;

import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.config.ProgInfos;
import de.p2tools.mtplayer.controller.worker.Busy;
import de.p2tools.p2lib.P2LibConst;
import de.p2tools.p2lib.alert.P2Alert;
import de.p2tools.p2lib.configfile.ConfigFile;
import de.p2tools.p2lib.configfile.ConfigWriteFile;
import de.p2tools.p2lib.tools.log.P2Log;
import de.p2tools.p2lib.tools.log.P2Logger;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Date;
import org.apache.commons.lang3.time.FastDateFormat;

public class ProgSave {
    private static boolean open = true;

    private ProgSave() {
    }

    public static void saveAll() {
        ProgSave.saveAll(true);
    }

    public static void saveAll(boolean busy) {
        if (busy) {
            ProgData.busy.busyOn(Busy.BUSY_SRC.GUI, "Speichern:", -1.0, false);
        }
        P2Log.sysLog("Alle Programmeinstellungen sichern");
        Path xmlFilePath = ProgInfos.getSettingsFile();
        ConfigFile configFile = new ConfigFile(xmlFilePath.toString(), true);
        ProgConfig.addConfigData(configFile, true);
        ConfigWriteFile.writeConfigFile(configFile);
        if (ProgData.reset) {
            ProgSave.reset();
        }
        if (busy) {
            ProgData.busy.busyOffFx();
        }
    }

    private static void reset() {
        try {
            P2Log.sysLog("Programm reset: Start Pfad umbenennen");
            P2Logger.removeFileHandler();
            String dir1 = ProgInfos.getSettingsDirectory_String();
            if (dir1.endsWith(File.separator)) {
                dir1 = dir1.substring(0, dir1.length() - 1);
            }
            Path path1 = Paths.get(dir1, new String[0]);
            String dir2 = dir1 + "--" + FastDateFormat.getInstance("yyyy.MM.dd__HH.mm.ss").format(new Date());
            P2Log.sysLog("Pfad verschieben: " + dir1);
            P2Log.sysLog("  nach: " + dir2);
            Files.move(path1, Paths.get(dir2, new String[0]), StandardCopyOption.REPLACE_EXISTING);
            Files.deleteIfExists(path1);
            P2Log.sysLog("  moved :)");
        }
        catch (Exception ex) {
            P2Log.errorLog(912012014, ex, "Die Einstellungen konnten nicht zur\u00fcckgesetzt werden.");
            try {
                P2Alert.showErrorAlert("Fehler", "Einstellungen zur\u00fcckgesetzen", "Die Einstellungen konnten nicht zur\u00fcckgesetzt werden." + P2LibConst.LINE_SEPARATORx2 + "Sie m\u00fcssen jetzt das Programm beenden, dann den Ordner:" + P2LibConst.LINE_SEPARATORx2 + ProgInfos.getSettingsDirectory_String() + P2LibConst.LINE_SEPARATORx2 + "von Hand l\u00f6schen und das Programm wieder starten.");
                open = false;
            }
            catch (Exception ignore) {
                open = false;
            }
            while (open) {
                try {
                    ProgSave.class.wait(100L);
                }
                catch (Exception exception) {}
            }
        }
    }
}

