/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer;

import de.p2tools.mtplayer.MTPTester;
import de.p2tools.mtplayer.controller.ProgQuit;
import de.p2tools.mtplayer.controller.ProgSave;
import de.p2tools.mtplayer.controller.config.PShortcut;
import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.config.ProgIcons;
import de.p2tools.mtplayer.controller.update.SearchProgramUpdate;
import de.p2tools.mtplayer.controller.update.WhatsNewFactory;
import de.p2tools.mtplayer.gui.configdialog.ConfigDialogController;
import de.p2tools.mtplayer.gui.dialog.AboutDialogController;
import de.p2tools.mtplayer.gui.dialog.ImportMVDialog;
import de.p2tools.mtplayer.gui.dialog.ResetDialogController;
import de.p2tools.mtplayer.gui.mediadialog.MediaDialogController;
import de.p2tools.mtplayer.gui.tools.ProgTipOfDayFactory;
import de.p2tools.p2lib.guitools.P2Open;
import de.p2tools.p2lib.tools.log.P2Logger;
import de.p2tools.p2lib.tools.shortcut.P2ShortcutWorker;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuButton;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.Tooltip;
import javafx.scene.input.MouseButton;

public class MTPlayerMenu
extends MenuButton {
    public MTPlayerMenu() {
        this.makeButton();
        this.setOnMouseClicked(mouseEvent -> {
            if (mouseEvent.getButton().equals((Object)MouseButton.SECONDARY)) {
                ProgConfig.SYSTEM_DARK_THEME.setValue(ProgConfig.SYSTEM_DARK_THEME.getValue() == false);
            }
        });
    }

    private void makeButton() {
        ProgData progData = ProgData.getInstance();
        MenuItem miConfig = new MenuItem("Einstellungen des Programms");
        miConfig.setOnAction(e -> new ConfigDialogController(ProgData.getInstance()));
        miConfig.disableProperty().bind(ConfigDialogController.dialogIsRunning);
        MenuItem miSearchMediaCollection = new MenuItem("Mediensammlung");
        miSearchMediaCollection.setOnAction(a -> new MediaDialogController("", ""));
        P2ShortcutWorker.addShortCut(miSearchMediaCollection, PShortcut.SHORTCUT_SEARCH_MEDIACOLLECTION);
        CheckMenuItem miDarkMode = new CheckMenuItem("Dark Mode");
        miDarkMode.selectedProperty().bindBidirectional(ProgConfig.SYSTEM_DARK_THEME);
        CheckMenuItem miLive = new CheckMenuItem("Live-Suche");
        miLive.selectedProperty().bindBidirectional(ProgConfig.LIVE_FILM_IS_VISIBLE);
        MenuItem miQuit = new MenuItem("Beenden");
        miQuit.setOnAction(e -> ProgQuit.quit(false));
        P2ShortcutWorker.addShortCut(miQuit, PShortcut.SHORTCUT_QUIT_PROGRAM);
        this.setTooltip(new Tooltip("Programmeinstellungen anzeigen"));
        this.setMinWidth(Double.NEGATIVE_INFINITY);
        this.getStyleClass().addAll((String[])new String[]{"btnFunction", "btnFunc-2"});
        this.setText("");
        this.setGraphic(ProgIcons.ICON_TOOLBAR_MENU_TOP.getImageView());
        this.getItems().addAll((MenuItem[])new MenuItem[]{miConfig, miSearchMediaCollection, miDarkMode, miLive});
        this.addMenuButton();
        this.getItems().addAll((MenuItem[])new MenuItem[]{this.addHelp(progData), new SeparatorMenuItem(), miQuit});
    }

    private void addMenuButton() {
        CheckMenuItem miFilm = new CheckMenuItem("Rechte Men\u00fcleiste");
        miFilm.visibleProperty().bind(ProgData.FILM_TAB_ON);
        miFilm.selectedProperty().bindBidirectional(ProgConfig.FILM_GUI_SHOW_MENU);
        CheckMenuItem miLiveFilm = new CheckMenuItem("Rechte Men\u00fcleiste");
        miLiveFilm.visibleProperty().bind(ProgData.LIVE_FILM_TAB_ON);
        miLiveFilm.selectedProperty().bindBidirectional(ProgConfig.LIVE_FILM_GUI_SHOW_MENU);
        CheckMenuItem miDownload = new CheckMenuItem("Rechte Men\u00fcleiste");
        miDownload.visibleProperty().bind(ProgData.DOWNLOAD_TAB_ON);
        miDownload.selectedProperty().bindBidirectional(ProgConfig.DOWNLOAD_GUI_SHOW_MENU);
        CheckMenuItem miAbo = new CheckMenuItem("Rechte Men\u00fcleiste");
        miAbo.visibleProperty().bind(ProgData.ABO_TAB_ON);
        miAbo.selectedProperty().bindBidirectional(ProgConfig.ABO_GUI_SHOW_MENU);
        this.getItems().addAll((MenuItem[])new MenuItem[]{miFilm, miLiveFilm, miDownload, miAbo});
    }

    private Menu addHelp(ProgData progData) {
        MenuItem miUrlHelp = new MenuItem("Anleitung im Web");
        miUrlHelp.setOnAction(event -> P2Open.openURL("https://www.p2tools.de/mtplayer/manual/", ProgConfig.SYSTEM_PROG_OPEN_URL, ProgIcons.ICON_BUTTON_FILE_OPEN.getImageView()));
        MenuItem miLog = new MenuItem("Logdatei \u00f6ffnen");
        miLog.setOnAction(event -> P2Logger.openLogFile());
        MenuItem miShortCut = new MenuItem("Tastaturbefehle festlegen");
        miShortCut.setOnAction(event -> {
            ProgConfig.SYSTEM_CONFIG_DIALOG_TAB.setValue(0);
            ProgConfig.SYSTEM_CONFIG_DIALOG_CONFIG.setValue(5);
            new ConfigDialogController(ProgData.getInstance());
        });
        MenuItem miReset = new MenuItem("Einstellungen zur\u00fccksetzen");
        miReset.setOnAction(event -> new ResetDialogController(progData));
        MenuItem miImportMV = new MenuItem("MediathekView Einstellungen importieren");
        miImportMV.setOnAction(event -> new ImportMVDialog(progData));
        MenuItem miToolTip = new MenuItem("Tip des Tages");
        miToolTip.setOnAction(a -> ProgTipOfDayFactory.showDialog(progData, true));
        MenuItem miWhatsNew = new MenuItem("Was ist neu?");
        miWhatsNew.setOnAction(a -> WhatsNewFactory.showWhatsNew(true));
        MenuItem miSearchUpdate = new MenuItem("Gibt's ein Update?");
        miSearchUpdate.setOnAction(a -> new SearchProgramUpdate(progData).searchNewProgramVersion(true));
        MenuItem miAbout = new MenuItem("\u00dcber dieses Programm");
        miAbout.setOnAction(event -> new AboutDialogController(progData).showDialog());
        Menu mHelp = new Menu("Hilfe");
        mHelp.getItems().addAll((MenuItem[])new MenuItem[]{miUrlHelp, miLog, miShortCut, miReset, miImportMV, miToolTip, new SeparatorMenuItem(), miWhatsNew, miSearchUpdate, miAbout});
        if (ProgData.debug) {
            MenuItem miDebug = new MenuItem("Debugtools");
            miDebug.setOnAction(event -> {
                MTPTester mtpTester = new MTPTester(progData);
                mtpTester.showDialog();
            });
            MenuItem miSearchAllUpdate = new MenuItem("Alle Programm-Downloads anzeigen");
            miSearchAllUpdate.setOnAction(a -> new SearchProgramUpdate(progData).searchNewProgramVersion());
            MenuItem miResetTodayDone = new MenuItem("<SYSTEM_SEARCH_UPDATE_TODAY_DONE> zur\u00fccksetzen");
            miResetTodayDone.setOnAction(a -> ProgConfig.SYSTEM_SEARCH_UPDATE_TODAY_DONE.set("2020.01.01"));
            MenuItem miResetLastSearch = new MenuItem("<SYSTEM_SEARCH_UPDATE_LAST_DATE> zur\u00fccksetzen");
            miResetLastSearch.setOnAction(a -> ProgConfig.SYSTEM_SEARCH_UPDATE_LAST_DATE.set("2020.01.01"));
            MenuItem miResetUpdate = new MenuItem("<SYSTEM_SEARCH_UPDATE_TODAY_DONE und \nSYSTEM_SEARCH_UPDATE_LAST_DATE> zur\u00fccksetzen");
            miResetUpdate.setOnAction(a -> {
                ProgConfig.SYSTEM_SEARCH_UPDATE_TODAY_DONE.set("2020.01.01");
                ProgConfig.SYSTEM_SEARCH_UPDATE_LAST_DATE.set("2020.01.01");
            });
            MenuItem miSave = new MenuItem("Alles Speichern");
            miSave.setOnAction(a -> ProgSave.saveAll());
            mHelp.getItems().addAll((MenuItem[])new MenuItem[]{new SeparatorMenuItem(), miDebug, miSearchAllUpdate, miResetTodayDone, miResetLastSearch, miResetUpdate, miSave});
        }
        return mHelp;
    }
}

