/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer;

import de.p2tools.mtplayer.MTPlayerController;
import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.data.blackdata.BlacklistFactory;
import de.p2tools.mtplayer.gui.configdialog.ConfigDialogController;
import de.p2tools.p2lib.dialogs.dialog.P2DialogExtra;
import de.p2tools.p2lib.guitools.P2WindowIcon;

public class MTPlayerFactory {
    private MTPlayerFactory() {
    }

    public static String getOwnIconPath() {
        if (ProgConfig.SYSTEM_USE_OWN_PROGRAM_ICON.getValue().booleanValue()) {
            return ProgConfig.SYSTEM_PROGRAM_ICON_PATH.getValueSafe();
        }
        return "";
    }

    public static void setProgramIcon() {
        if (ProgConfig.SYSTEM_USE_OWN_PROGRAM_ICON.getValue().booleanValue()) {
            P2WindowIcon.setStageIcon(ProgConfig.SYSTEM_PROGRAM_ICON_PATH.getValueSafe());
        } else {
            P2WindowIcon.setStageIcon("");
        }
    }

    public static void centerGui() {
        ProgData.getInstance().primaryStage.centerOnScreen();
    }

    public static void minimizeGui() {
        ProgData.getInstance().primaryStage.setIconified(true);
        P2DialogExtra.getDialogList().forEach(p2Dialog -> p2Dialog.getStage().setIconified(true));
    }

    public static void setFilter() {
        switch (MTPlayerController.paneShown) {
            case FILM: {
                ProgConfig.FILM__FILTER_IS_SHOWING.setValue(ProgConfig.FILM__FILTER_IS_SHOWING.getValue() == false);
                break;
            }
            case LIVE_FILM: {
                ProgConfig.LIVE_FILM__FILTER_IS_SHOWING.setValue(ProgConfig.LIVE_FILM__FILTER_IS_SHOWING.getValue() == false);
                break;
            }
            case DOWNLOAD: {
                ProgConfig.DOWNLOAD__FILTER_IS_SHOWING.setValue(ProgConfig.DOWNLOAD__FILTER_IS_SHOWING.getValue() == false);
                break;
            }
            case ABO: {
                ProgConfig.ABO__FILTER_IS_SHOWING.setValue(ProgConfig.ABO__FILTER_IS_SHOWING.getValue() == false);
            }
        }
    }

    public static void setInfos() {
        switch (MTPlayerController.paneShown) {
            case FILM: {
                ProgConfig.FILM__INFO_IS_SHOWING.setValue(ProgConfig.FILM__INFO_IS_SHOWING.getValue() == false);
                break;
            }
            case LIVE_FILM: {
                ProgConfig.LIVE_FILM__INFO_IS_SHOWING.setValue(ProgConfig.LIVE_FILM__INFO_IS_SHOWING.getValue() == false);
                break;
            }
            case DOWNLOAD: {
                ProgConfig.DOWNLOAD__INFO_IS_SHOWING.setValue(ProgConfig.DOWNLOAD__INFO_IS_SHOWING.getValue() == false);
                break;
            }
            case ABO: {
                ProgConfig.ABO__INFO_IS_SHOWING.setValue(ProgConfig.ABO__INFO_IS_SHOWING.getValue() == false);
            }
        }
    }

    public static void showFilmInfos() {
        switch (MTPlayerController.paneShown) {
            case FILM: {
                ProgData.getInstance().filmGuiController.showFilmInfo();
                break;
            }
            case LIVE_FILM: {
                ProgData.getInstance().liveFilmGuiController.showFilmInfo();
                break;
            }
            case DOWNLOAD: {
                ProgData.getInstance().downloadGuiController.showFilmInfo();
                break;
            }
        }
    }

    public static void copyTheme() {
        switch (MTPlayerController.paneShown) {
            case FILM: {
                ProgData.getInstance().filmGuiController.copyFilmThemeTitle(true);
                break;
            }
            case LIVE_FILM: {
                ProgData.getInstance().liveFilmGuiController.copyFilmThemeTitle(true);
                break;
            }
            case DOWNLOAD: {
                ProgData.getInstance().downloadGuiController.copyFilmThemeTitle(true);
                break;
            }
        }
    }

    public static void copyTitle() {
        switch (MTPlayerController.paneShown) {
            case FILM: {
                ProgData.getInstance().filmGuiController.copyFilmThemeTitle(false);
                break;
            }
            case LIVE_FILM: {
                ProgData.getInstance().liveFilmGuiController.copyFilmThemeTitle(false);
                break;
            }
            case DOWNLOAD: {
                ProgData.getInstance().downloadGuiController.copyFilmThemeTitle(false);
                break;
            }
        }
    }

    public static void addBlacklist() {
        switch (MTPlayerController.paneShown) {
            case FILM: {
                BlacklistFactory.addBlackFilm(true);
                break;
            }
            case LIVE_FILM: {
                break;
            }
            case DOWNLOAD: {
                BlacklistFactory.addBlackFilm(false);
                break;
            }
        }
    }

    public static void addBlacklistTheme() {
        switch (MTPlayerController.paneShown) {
            case FILM: {
                BlacklistFactory.addBlackThemeFilm();
                break;
            }
            case LIVE_FILM: {
                break;
            }
            case DOWNLOAD: {
                BlacklistFactory.addBlackThemeDownload();
                break;
            }
        }
    }

    public static void showBlacklist() {
        new ConfigDialogController(ProgData.getInstance(), true);
    }

    public static void setMediaCollection() {
        switch (MTPlayerController.paneShown) {
            case FILM: {
                ProgData.getInstance().filmGuiController.searchFilmInMediaCollection();
                break;
            }
            case LIVE_FILM: {
                ProgData.getInstance().liveFilmGuiController.searchFilmInMediaCollection();
                break;
            }
            case DOWNLOAD: {
                ProgData.getInstance().downloadGuiController.searchFilmInMediaCollection();
                break;
            }
        }
    }

    public static void undoDels() {
        switch (MTPlayerController.paneShown) {
            case FILM: 
            case LIVE_FILM: {
                break;
            }
            case DOWNLOAD: {
                ProgData.getInstance().downloadList.undoDownloads();
                break;
            }
            case ABO: {
                ProgData.getInstance().aboList.undoAbos();
            }
        }
    }
}

