/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer;

import de.p2tools.mtplayer.MTPlayerFactory;
import de.p2tools.mtplayer.MTPlayerMenu;
import de.p2tools.mtplayer.controller.config.PEvents;
import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.config.ProgIcons;
import de.p2tools.mtplayer.controller.worker.Busy;
import de.p2tools.mtplayer.gui.AboGui;
import de.p2tools.mtplayer.gui.DownloadGui;
import de.p2tools.mtplayer.gui.FilmGui;
import de.p2tools.mtplayer.gui.LiveFilmGui;
import de.p2tools.mtplayer.gui.StatusBarController;
import de.p2tools.mtplayer.gui.filter.SearchFast;
import de.p2tools.p2lib.p2event.P2Listener;
import de.p2tools.p2lib.tools.log.P2Log;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.SplitPane;
import javafx.scene.control.Tooltip;
import javafx.scene.input.MouseButton;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.TilePane;
import javafx.scene.layout.VBox;

public class MTPlayerController
extends StackPane {
    public static PANE_SHOWN paneShown = null;
    private final Button btnFilmlist = new Button("Filmliste");
    private final Button btnFilm = new Button("Filme");
    private final Button btnLive = new Button("Live");
    private final Button btnDownload = new Button("Downloads");
    private final Button btnAbo = new Button("Abos");
    private final SearchFast searchFast = new SearchFast();
    private final BorderPane borderPane = new BorderPane();
    private final StackPane stackPaneCont = new StackPane();
    private StatusBarController statusBarController;
    private SplitPane splitPaneFilm;
    private SplitPane splitPaneLiveFilm;
    private SplitPane splitPaneDownload;
    private SplitPane splitPaneAbo;
    private final ProgData progData;
    private final FilmGui filmGui = new FilmGui();
    private final LiveFilmGui liveFilmGui = new LiveFilmGui();
    private final DownloadGui downloadGui = new DownloadGui();
    private final AboGui aboGui = new AboGui();

    public MTPlayerController() {
        this.progData = ProgData.getInstance();
        this.init();
    }

    private void init() {
        try {
            TilePane tilePane = new TilePane();
            tilePane.setPrefColumns(4);
            tilePane.setHgap(15.0);
            tilePane.setPadding(new Insets(0.0));
            tilePane.setAlignment(Pos.CENTER);
            tilePane.getChildren().addAll((Node[])new Node[]{this.btnFilm, this.btnLive, this.btnDownload, this.btnAbo});
            HBox hBoxTop = new HBox();
            hBoxTop.setPadding(new Insets(2.0, 10.0, 2.0, 10.0));
            hBoxTop.setSpacing(10.0);
            hBoxTop.setAlignment(Pos.CENTER);
            HBox.setHgrow(tilePane, Priority.SOMETIMES);
            HBox.setHgrow(this.searchFast, Priority.ALWAYS);
            hBoxTop.getChildren().addAll((Node[])new Node[]{this.btnFilmlist, tilePane, this.searchFast, new MTPlayerMenu()});
            this.splitPaneFilm = this.filmGui.pack();
            this.splitPaneLiveFilm = this.liveFilmGui.pack();
            this.splitPaneDownload = this.downloadGui.pack();
            this.splitPaneAbo = this.aboGui.pack();
            this.stackPaneCont.getChildren().addAll((Node[])new Node[]{this.splitPaneFilm, this.splitPaneLiveFilm, this.splitPaneDownload, this.splitPaneAbo});
            VBox vBox = new VBox();
            vBox.getChildren().addAll((Node[])new Node[]{this.stackPaneCont, ProgData.busy.getBusyHbox(Busy.BUSY_SRC.GUI)});
            VBox.setVgrow(this.stackPaneCont, Priority.ALWAYS);
            this.statusBarController = new StatusBarController(this.progData);
            this.statusBarController.visibleProperty().bind(ProgConfig.SYSTEM_STATUS_BAR_ON);
            this.statusBarController.managedProperty().bind(ProgConfig.SYSTEM_STATUS_BAR_ON);
            this.borderPane.setTop(hBoxTop);
            this.borderPane.setCenter(vBox);
            this.borderPane.setBottom(this.statusBarController);
            this.setPadding(new Insets(0.0));
            this.getChildren().addAll((Node[])new Node[]{this.borderPane, this.progData.maskerPane});
            this.initMaskerPane();
            this.initButton();
            if (ProgData.autoMode) {
                this.selPanelDownload();
            } else {
                this.selPanelFilm();
            }
        }
        catch (Exception ex) {
            P2Log.errorLog(597841023, ex);
        }
    }

    private void initMaskerPane() {
        StackPane.setAlignment(this.progData.maskerPane, Pos.CENTER);
        this.progData.maskerPane.setPadding(new Insets(4.0, 1.0, 1.0, 1.0));
        this.progData.maskerPane.toFront();
        Button btnStop = this.progData.maskerPane.getButton();
        this.progData.maskerPane.setButtonText("");
        btnStop.setGraphic(ProgIcons.ICON_BUTTON_CLEAR.getImageView());
        btnStop.setOnAction(a -> this.progData.loadFilmListWorker.loadFilmlist.setStop(true));
    }

    private void initButton() {
        this.btnFilmlist.setMinWidth(Double.NEGATIVE_INFINITY);
        this.btnFilmlist.getStyleClass().addAll((String[])new String[]{"btnFunction", "btnFunc-4"});
        this.btnFilmlist.setTooltip(new Tooltip("Eine neue Filmliste laden.\nWenn die Filmliste nicht zu alt ist, wird nur ein Update geladen.\nMit der rechten Maustaste wird immer die komplette Filmliste geladen."));
        this.btnFilmlist.setOnAction(e -> this.progData.loadFilmListWorker.loadNewListFromWeb(false));
        this.btnFilmlist.setOnMouseClicked(mouseEvent -> {
            if (mouseEvent.getButton().equals((Object)MouseButton.SECONDARY)) {
                this.progData.loadFilmListWorker.loadNewListFromWeb(true);
            } else if (mouseEvent.getButton().equals((Object)MouseButton.MIDDLE)) {
                this.progData.checkForNewFilmlist.check();
            }
        });
        this.progData.checkForNewFilmlist.foundNewListProperty().addListener((u, o, n) -> {
            if (this.progData.checkForNewFilmlist.isFoundNewList()) {
                this.btnFilmlist.getStyleClass().add("buttonLoadFilmlistNewList");
            } else {
                this.btnFilmlist.getStyleClass().remove("buttonLoadFilmlistNewList");
            }
        });
        this.progData.pEventHandler.addListener(new P2Listener(PEvents.EVENT_FILMLIST_LOAD_FINISHED){

            @Override
            public void pingGui() {
                if (MTPlayerController.this.stackPaneCont.getChildren().isEmpty()) {
                    return;
                }
                MTPlayerController.this.setFocus();
            }
        });
        this.btnFilm.setTooltip(new Tooltip("Filme anzeigen"));
        this.btnFilm.setOnAction(e -> this.selPanelFilm());
        this.btnFilm.setMaxWidth(Double.MAX_VALUE);
        this.btnLive.setTooltip(new Tooltip("Live-Filme suchen"));
        this.btnLive.setOnAction(e -> this.selPanelLiveFilm());
        this.btnLive.setMaxWidth(Double.MAX_VALUE);
        this.btnLive.visibleProperty().bind(ProgConfig.LIVE_FILM_IS_VISIBLE);
        this.btnLive.managedProperty().bind(this.btnLive.visibleProperty());
        ProgConfig.LIVE_FILM_IS_VISIBLE.addListener((u, o, n) -> {
            if (n.booleanValue()) {
                this.selPanelLiveFilm();
            } else {
                paneShown = PANE_SHOWN.LIVE_FILM;
                this.selPanelFilm();
            }
        });
        this.btnDownload.setTooltip(new Tooltip("Downloads anzeigen"));
        this.btnDownload.setOnAction(e -> this.selPanelDownload());
        this.btnDownload.setMaxWidth(Double.MAX_VALUE);
        this.btnAbo.setTooltip(new Tooltip("Abos anzeigen"));
        this.btnAbo.setOnAction(e -> this.selPanelAbo());
        this.btnAbo.setMaxWidth(Double.MAX_VALUE);
        this.btnFilm.setOnMouseClicked(mouseEvent -> {
            if (this.progData.maskerPane.isVisible() || paneShown != PANE_SHOWN.FILM) {
                return;
            }
            if (mouseEvent.getButton().equals((Object)MouseButton.SECONDARY)) {
                MTPlayerFactory.setInfos();
            }
        });
        this.btnLive.setOnMouseClicked(mouseEvent -> {
            if (this.progData.maskerPane.isVisible() || paneShown != PANE_SHOWN.LIVE_FILM) {
                return;
            }
            if (mouseEvent.getButton().equals((Object)MouseButton.SECONDARY)) {
                MTPlayerFactory.setInfos();
            }
        });
        this.btnDownload.setOnMouseClicked(mouseEvent -> {
            if (this.progData.maskerPane.isVisible() || paneShown != PANE_SHOWN.DOWNLOAD) {
                return;
            }
            if (mouseEvent.getButton().equals((Object)MouseButton.SECONDARY)) {
                MTPlayerFactory.setInfos();
            }
        });
        this.btnAbo.setOnMouseClicked(mouseEvent -> {
            if (this.progData.maskerPane.isVisible() || paneShown != PANE_SHOWN.ABO) {
                return;
            }
            if (mouseEvent.getButton().equals((Object)MouseButton.SECONDARY)) {
                MTPlayerFactory.setInfos();
            }
        });
    }

    private void selPanelFilm() {
        if (paneShown == PANE_SHOWN.FILM) {
            MTPlayerFactory.setFilter();
            return;
        }
        paneShown = PANE_SHOWN.FILM;
        this.setButtonStyle();
        this.splitPaneFilm.toFront();
        this.progData.filmGuiController.isShown();
        this.statusBarController.setStatusbarIndex();
        ProgData.FILM_TAB_ON.setValue(Boolean.TRUE);
        ProgData.LIVE_FILM_TAB_ON.setValue(Boolean.FALSE);
        ProgData.DOWNLOAD_TAB_ON.setValue(Boolean.FALSE);
        ProgData.ABO_TAB_ON.setValue(Boolean.FALSE);
    }

    private void selPanelLiveFilm() {
        if (paneShown == PANE_SHOWN.LIVE_FILM) {
            MTPlayerFactory.setFilter();
            return;
        }
        paneShown = PANE_SHOWN.LIVE_FILM;
        this.setButtonStyle();
        this.splitPaneLiveFilm.toFront();
        this.progData.liveFilmGuiController.isShown();
        this.statusBarController.setStatusbarIndex();
        ProgData.FILM_TAB_ON.setValue(Boolean.FALSE);
        ProgData.LIVE_FILM_TAB_ON.setValue(Boolean.TRUE);
        ProgData.DOWNLOAD_TAB_ON.setValue(Boolean.FALSE);
        ProgData.ABO_TAB_ON.setValue(Boolean.FALSE);
    }

    private void selPanelDownload() {
        if (paneShown == PANE_SHOWN.DOWNLOAD) {
            MTPlayerFactory.setFilter();
            return;
        }
        paneShown = PANE_SHOWN.DOWNLOAD;
        this.setButtonStyle();
        this.splitPaneDownload.toFront();
        this.progData.downloadGuiController.isShown();
        this.statusBarController.setStatusbarIndex();
        ProgData.FILM_TAB_ON.setValue(Boolean.FALSE);
        ProgData.LIVE_FILM_TAB_ON.setValue(Boolean.FALSE);
        ProgData.DOWNLOAD_TAB_ON.setValue(Boolean.TRUE);
        ProgData.ABO_TAB_ON.setValue(Boolean.FALSE);
    }

    private void selPanelAbo() {
        if (paneShown == PANE_SHOWN.ABO) {
            MTPlayerFactory.setFilter();
            return;
        }
        paneShown = PANE_SHOWN.ABO;
        this.setButtonStyle();
        this.splitPaneAbo.toFront();
        this.progData.aboGuiController.isShown();
        this.statusBarController.setStatusbarIndex();
        ProgData.FILM_TAB_ON.setValue(Boolean.FALSE);
        ProgData.LIVE_FILM_TAB_ON.setValue(Boolean.FALSE);
        ProgData.DOWNLOAD_TAB_ON.setValue(Boolean.FALSE);
        ProgData.ABO_TAB_ON.setValue(Boolean.TRUE);
    }

    private void setButtonStyle() {
        if (ProgConfig.LIVE_FILM_IS_VISIBLE.get()) {
            this.setButtonStyleSmall();
        } else {
            this.setButtonStyleBig();
        }
    }

    private void setButtonStyleBig() {
        this.btnFilm.getStyleClass().clear();
        this.btnLive.getStyleClass().clear();
        this.btnDownload.getStyleClass().clear();
        this.btnAbo.getStyleClass().clear();
        if (paneShown == PANE_SHOWN.FILM) {
            this.searchFast.setVisible(true);
            this.btnFilm.getStyleClass().add("btnTabTop-sel");
        } else {
            this.searchFast.setVisible(false);
            this.btnFilm.getStyleClass().add("btnTabTop");
        }
        if (paneShown == PANE_SHOWN.LIVE_FILM) {
            this.btnLive.getStyleClass().add("btnTabTop-sel");
        } else {
            this.btnLive.getStyleClass().add("btnTabTop");
        }
        if (paneShown == PANE_SHOWN.DOWNLOAD) {
            this.btnDownload.getStyleClass().add("btnTabTop-sel");
        } else {
            this.btnDownload.getStyleClass().add("btnTabTop");
        }
        if (paneShown == PANE_SHOWN.ABO) {
            this.btnAbo.getStyleClass().add("btnTabTop-sel");
        } else {
            this.btnAbo.getStyleClass().add("btnTabTop");
        }
    }

    private void setButtonStyleSmall() {
        this.btnFilm.getStyleClass().clear();
        this.btnLive.getStyleClass().clear();
        this.btnDownload.getStyleClass().clear();
        this.btnAbo.getStyleClass().clear();
        if (paneShown == PANE_SHOWN.FILM) {
            this.searchFast.setVisible(true);
            this.btnFilm.getStyleClass().add("btnTabTopSmall-sel");
        } else {
            this.searchFast.setVisible(false);
            this.btnFilm.getStyleClass().add("btnTabTopSmall");
        }
        if (paneShown == PANE_SHOWN.LIVE_FILM) {
            this.btnLive.getStyleClass().add("btnTabTopSmall-sel");
        } else {
            this.btnLive.getStyleClass().add("btnTabTopSmall");
        }
        if (paneShown == PANE_SHOWN.DOWNLOAD) {
            this.btnDownload.getStyleClass().add("btnTabTopSmall-sel");
        } else {
            this.btnDownload.getStyleClass().add("btnTabTopSmall");
        }
        if (paneShown == PANE_SHOWN.ABO) {
            this.btnAbo.getStyleClass().add("btnTabTopSmall-sel");
        } else {
            this.btnAbo.getStyleClass().add("btnTabTopSmall");
        }
    }

    public void setFocus() {
        if (paneShown == PANE_SHOWN.FILM) {
            this.progData.filmGuiController.isShown();
        }
        if (paneShown == PANE_SHOWN.LIVE_FILM) {
            this.progData.filmGuiController.isShown();
        }
        if (paneShown == PANE_SHOWN.DOWNLOAD) {
            this.progData.downloadGuiController.isShown();
        }
        if (paneShown == PANE_SHOWN.ABO) {
            this.progData.aboGuiController.isShown();
        }
    }

    public static enum PANE_SHOWN {
        FILM,
        LIVE_FILM,
        DOWNLOAD,
        ABO;

    }
}

