/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer;

import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.data.blackdata.BlackData;
import de.p2tools.mtplayer.controller.data.blackdata.BlacklistFilterFactory;
import de.p2tools.mtplayer.gui.dialog.QuitDialogController;
import de.p2tools.p2lib.dialogs.ProgInfoDialog;
import de.p2tools.p2lib.guitools.P2ColumnConstraints;
import de.p2tools.p2lib.guitools.pmask.P2MaskerPaneIndeterminate;
import de.p2tools.p2lib.mtfilm.film.FilmData;
import de.p2tools.p2lib.mtfilter.FilmFilterCheck;
import de.p2tools.p2lib.mtfilter.Filter;
import java.util.function.Predicate;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.StackPane;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;

public class MTPTester {
    private final ProgInfoDialog progInfoDialog;
    private final ProgData progData;
    private final P2MaskerPaneIndeterminate maskerPane = new P2MaskerPaneIndeterminate();

    public MTPTester(ProgData progData) {
        this.progData = progData;
        this.progInfoDialog = new ProgInfoDialog(false);
        this.addProgTest();
    }

    public void showDialog() {
        this.progInfoDialog.showDialog();
    }

    private void addProgTest() {
        if (this.progInfoDialog != null) {
            GridPane gridPane = new GridPane();
            gridPane.setHgap(5.0);
            gridPane.setVgap(5.0);
            gridPane.setPadding(new Insets(10.0));
            gridPane.getColumnConstraints().addAll((ColumnConstraints[])new ColumnConstraints[]{P2ColumnConstraints.getCcComputedSizeAndHgrow()});
            StackPane stackPane = new StackPane();
            stackPane.getChildren().addAll((Node[])new Node[]{gridPane});
            this.progInfoDialog.getVBoxCont().getChildren().addAll((Node[])new Node[]{stackPane, this.maskerPane});
            Text text = new Text("DebugTools");
            text.setFont(Font.font(null, FontWeight.BOLD, 15.0));
            int row = 0;
            Button btnAddBlack = new Button("5_000 Black");
            btnAddBlack.setOnAction(a -> {
                this.progData.blackList.clearList();
                for (int i = 0; i < 5000; ++i) {
                    BlackData bl = new BlackData();
                    bl.setThemeTitle("" + i);
                    this.progData.blackList.add(bl);
                }
            });
            gridPane.add(btnAddBlack, 0, ++row);
            Button btnBlack = new Button("Gen-Black");
            btnBlack.setOnAction(a -> BlacklistFilterFactory.markFilmBlackThread(true));
            gridPane.add(btnBlack, 0, ++row);
            Button btnQuitt = new Button("Quitt, waiting false");
            btnQuitt.setOnAction(a -> new QuitDialogController(false));
            gridPane.add(btnQuitt, 0, ++row);
        }
    }

    public void close() {
        this.maskerPane.switchOffMasker();
    }

    private static Predicate<FilmData> getPredicate(String channel) {
        Filter fChannel = new Filter(channel, true);
        Predicate<FilmData> predicate = film -> true;
        predicate = predicate.and(f -> FilmFilterCheck.checkMatchChannelSmart(fChannel, f));
        return predicate;
    }
}

